<?php
/**
* 
*/
class Reportmodel extends CI_Model
{
	
	public function __construct() {
        parent::__construct();
    }

    public function queryvatreportbydaterange($first_date,$last_date)
    {
        # code...
    }

    public function querysumofsalesreportbydaterange($first_date,$last_date)
    {
    	$this->db->select('SUM(paid_amount) as paid_amount',FALSE);
		$this->db->from('invoice');
    	$this->db->where('invoice_date >=', $first_date);
		$this->db->where('invoice_date <=', $last_date);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
		
    }
	
	public function querysalesreportbydaterange($first_date,$last_date)
    {
    	$this->db->select('*');
		$this->db->from('invoice');
    	$this->db->where('due_date >=', $first_date);
		$this->db->where('due_date <=', $last_date);
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
		
    }

    public function querysalesreportbydaterangebyinvoicedate($first_date,$last_date)
    {
        $this->db->select('*');
        $this->db->from('invoice');
        $this->db->where('invoice_date >=', $first_date);
        $this->db->where('invoice_date <=', $last_date);
        $query_results =$this->db->get();
        $results= $query_results->result();
        return $results;
        
    }

	
	public function querysumofduecollectionreportbydaterange($first_date,$last_date)
    {
    	$this->db->select('SUM(first_payment) as first_payment', FALSE);
		$this->db->from('dues');
    	$this->db->where('payment_date >=', $first_date);
		$this->db->where('payment_date <=', $last_date);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }
    
	
	public function queryduecollectionreportbydaterange($first_date,$last_date)
    {
    	$this->db->select('dues.invoice_id, dues.first_payment, dues.payment_date, invoice.customer_name');
		$this->db->from('dues');
    	$this->db->where('dues.payment_date >=', $first_date);
		$this->db->where('dues.payment_date <=', $last_date);
		$this->db->join('invoice', 'dues.invoice_id = invoice.invoice_id', 'left');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }



	public function queryitemlist()
    {
    	$this->db->select('*');
		$this->db->from('item');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function queryitemlistwithsupplier()
    {
    	$this->db->select('item.item_id,item.item_code,item.item_name,supplier.supplier_name');
		$this->db->from('item');
		$this->db->join('supplier', 'item.supplier_id = supplier.supplier_id', 'left');
		$query_results =$this->db->get();
		$results= $query_results->result_array();
		return $results;
    }

    public function queryitemlistwithsupplierbyid($item_id)
    {
    	$this->db->select('item.item_id,item.item_code,item.item_name,supplier.supplier_name');
		$this->db->from('item');
		$this->db->where('item.item_id', $item_id);
		$this->db->join('supplier', 'item.supplier_id = supplier.supplier_id', 'left');
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }

    public function queryitemreport()
    {
    	$this->db->select('item_name');
		$this->db->from('item');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function queryinvoicereportbydaterange($first_date,$last_date)
    {
    	$this->db->select('invoice_id');
		$this->db->from('invoice');
    	$this->db->where('invoice_date >=', $first_date);
		$this->db->where('invoice_date <=', $last_date);
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function queryinvoiceditemreportbyinvoiceid($invoice_id)
    {
    	$this->db->select('*');
		$this->db->from('invoiced_item');
    	$this->db->where('invoice_id', $invoice_id);
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function querysumofduereportbydaterange($first_date,$last_date)
    {
    	$this->db->select('SUM(discount) as discount', FALSE);
		$this->db->from('invoice');
    	$this->db->where('invoice_date >=', $first_date);
		$this->db->where('invoice_date <=', $last_date);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }


    public function queryprofitreportbydaterange($first_date,$last_date,$item_name)
    {
    	$this->db->select('SUM(total_price) as total_price', FALSE);
		$this->db->from('invoiced_item');
    	$this->db->where('invoice_date >=', $first_date);
		$this->db->where('invoice_date <=', $last_date);
		$this->db->where('product_name', $item_name);
		$query_results =$this->db->get();
		$results= $query_results->result_array();
		return $results;
    }

    public function querylossreportbydaterange($first_date,$last_date,$item_name)
    {
    	$this->db->select('SUM(total_cost) as total_cost', FALSE);
		$this->db->from('invoiced_item');
    	$this->db->where('invoice_date >=', $first_date);
		$this->db->where('invoice_date <=', $last_date);
		$this->db->where('product_name', $item_name);
		$query_results =$this->db->get();
		$results= $query_results->result_array();
		return $results;
    }

    public function queryinventorymasterreport($item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('inventory.item_id', $item_id);
        $this->db->order_by("inventory.inventory_id", "desc");
        $this->db->limit(1);
        $this->db->join('item', 'inventory.item_id = item.item_id', 'left');
        $this->db->join('supplier', 'inventory.supplier_id = supplier.supplier_id', 'left');
		$query_results =$this->db->get();
		$results= $query_results->result_array();
		return $results;
    }

    public function queryinventoryreportbydaterange($first_date,$last_date,$item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('inventory.item_id', $item_id);
        $this->db->where('inventory.timestamp >=', $first_date);
		$this->db->where('inventory.timestamp <=', $last_date);
        $this->db->order_by("inventory.inventory_id", "desc");
        $this->db->limit(1);
        $this->db->join('item', 'inventory.item_id = item.item_id', 'left');
        $this->db->join('supplier', 'inventory.supplier_id = supplier.supplier_id', 'left');
		$query_results =$this->db->get();
		$results= $query_results->result_array();
		return $results;
    }

    public function querysupplieditembyid($first_date,$last_date,$item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('item_id', $item_id);
        $this->db->where('created_date >=', $first_date);
		$this->db->where('created_date <=', $last_date);
		$this->db->where('sold_quantity <=', 0);
        $this->db->order_by("inventory_id", "ASC");
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function querysolditembyid($first_date,$last_date,$item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('item_id', $item_id);
        $this->db->where('created_date >=', $first_date);
		$this->db->where('created_date <=', $last_date);
		$this->db->where('sold_quantity >', 0);
        $this->db->order_by("inventory_id", "ASC");
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }


    public function querymastersupplieditembyid($item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('item_id', $item_id);
		$this->db->where('sold_quantity <=', 0);
        $this->db->order_by("inventory_id", "ASC");
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function querymastersolditembyid($item_id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('item_id', $item_id);
		$this->db->where('sold_quantity >', 0);
        $this->db->order_by("inventory_id", "ASC");
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function storeInfo()
    {
        $this->db->select('*');
        $this->db->from('app_config');
        $this->db->order_by("id", "desc");
        $this->db->limit(1);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

    public function querycurrencytag()
    {
        $this->db->select('currency_tag');
        $this->db->from('currency_info');
        $this->db->order_by("id", "desc");
        $this->db->limit(1);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }
}