<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Billingcontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		
		$this->load->model('invoicemodel','INVOICEMODEL',TRUE);
                
		$id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }
		
		/*
		echo "<pre>";
		print_r($data);
		exit();
		*/
	}

	public function index()
	{
		
	}

	public function createinvoice()
	{
		
			$data = array();
			//$dt = new DateTime();
			$one = 1;
			$data['current_date'] = date('Y-m-d');
			$data['randomSerialNUmber'] = $this->generateRandomString();
			$data['vat_rate'] = $this->INVOICEMODEL->queryvatrate();
			$data['dashboardContent'] = $this->load->view('dashboard/invoice/createinvoice', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		
	}

	public function generateRandomString()
	{	
		$this->db->select('invoice_id');
		$this->db->from('invoice');
		$this->db->order_by("id", "DESC");
		$this->db->limit("1");
		$invoice_id = $this->db->get()->row('invoice_id');
		//echo $this->db->last_query;
		
		if($invoice_id){
			return $invoice_id+1;
		}else{
			return '100';
		}

		 
	}

	public function checkproductname()
	{
		$proname = $this->input->post('proname');
		$data = $this->INVOICEMODEL->checkproductname($proname);
		echo json_encode($data);
	}

	public function checksellingpricebyname()
	{
		$proname = $this->input->post('proname');
		$proid = $this->INVOICEMODEL->checkproductid($proname);
		$data = $this->INVOICEMODEL->checksellingpricebyname($proid->item_id);
		echo json_encode($data);
	}
	
	
	public function checkstockbyitemname()
	{
		$proname = $this->input->post('proname');
		$proid = $this->INVOICEMODEL->checkproductid($proname);
		$balancestock = $this->INVOICEMODEL->checkstockbyname($proid->item_id);
		
		
		echo json_encode($balancestock);
	}

	public function getproductname()
	{
		if (isset($_GET['term'])){
	      $q = strtolower($_GET['term']);
	      $this->INVOICEMODEL->getproductname($q);
	    }
	}

	public function creategrouparray($product_name,$quantity,$selling_price,$total_price,$purchasing_price)
	{
		
            foreach($product_name as $k => $name) {
                    $group[] = array('product_name' => $name, 'quantity' => $quantity[$k], 'selling_price' => $selling_price[$k], 'total_price' => $total_price[$k], 'purchasing_price' => $purchasing_price[$k]);
            }      
               return $group; 
        
	}
	
		
	public function insertinvoice()
	{
		$data = array();
		$data['customer_name'] = $this->input->post('customer_name');
		$data['customer_mobile'] = $this->input->post('customer_mobile');
		$data['customer_address'] = $this->input->post('customer_address');
		$data['email_address'] = $this->input->post('email_address');
		$data['invoice_id'] = $this->input->post('invoice_id');
		$data['invoice_date'] = date_formate_set_db($this->input->post('invoice_date'));
		$data['due_date'] = date_formate_set_db($this->input->post('due_date'));
		$data['sub_total'] = $this->input->post('sub_total');
		$data['discount'] = $this->input->post('discount');
		$data['grand_total'] = $this->input->post('grand_total');
		$data['vat_rate'] = $this->input->post('vat_rate');
		$data['vat_amount'] = $this->input->post('vat_amount');
		$data['net_total'] = $this->input->post('net_total');
		$data['paid_amount'] = $this->input->post('paid_amount');
		$data['due_amount'] = $this->input->post('due_amount');
		$data['note'] = $this->input->post('note');
		$data['prepared_by'] = $this->session->userdata('abhinvoiser_1_1_user_name');

		

		$product_name = $this->input->post('product_name');
		$quantity = $this->input->post('quantity');
		$selling_price = $this->input->post('selling_price');
		$total_price = $this->input->post('total_price');
		$purchasing_price = $this->input->post('purchasing_price');

		
		if(empty($data['customer_name']) || empty($product_name) || empty($quantity)){
			$failed = "Please enter Required Fields!!";
			$this->session->set_flashdata('failed', $failed);
			redirect('billingcontroller/createinvoice');
		}
		
		$group = $this->creategrouparray($product_name,$quantity,$selling_price,$total_price,$purchasing_price);
		
		

		
		$invoice = $this->INVOICEMODEL->insertinvoice($data);
		
		$count = count($group);
		for ($i=0; $i <$count ; $i++) { 
		    $new = array();
		     $new['invoice_id']= $this->input->post('invoice_id');
		     $new['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
		     $new['product_name']= $group[$i]['product_name'];
		     $new['quantity']= $group[$i]['quantity'];
		     $new['selling_price']= $group[$i]['selling_price'];
		     $new['total_price']= $group[$i]['total_price'];
		     $new['purchasing_price']= $group[$i]['purchasing_price'];
		     $new['total_cost']= $group[$i]['purchasing_price'] * $group[$i]['quantity'];
		    
		     $invoiced_item = $this->INVOICEMODEL->insertinvoiceditem($new);
		}

		/*for ($j=0; $j <$count ; $j++) { 
		    $newj = array();
		    $newj['product_name']= $group[$j]['product_name'];
			$invoiced_item_name = array();
			$invoiced_item_name[$j] = $this->INVOICEMODEL->checkproductid($newj['product_name']);
			//echo $invoiced_item_name[$j]->item_id."<br>";
			$inventorydetailsbyid = array();
			$inventorydetailsbyid[$j] = $this->INVOICEMODEL->queryinventorydetailsbyid($invoiced_item_name[$j]->item_id);

			$info = array();
			$dt = new DateTime();
			$info['sold_date'] = $dt->format('Y/m/d');
			$info['item_id'] = $inventorydetailsbyid[$j]->item_id;
			$info['supplier_id'] = $inventorydetailsbyid[$j]->supplier_id;
			$info['purchasing_price'] = $inventorydetailsbyid[$j]->purchasing_price;
			$info['selling_price'] = $inventorydetailsbyid[$j]->selling_price;
			$info['first_supplied_date'] = $inventorydetailsbyid[$j]->first_supplied_date;
			$info['last_supplied_date'] = $inventorydetailsbyid[$j]->last_supplied_date;
			$info['first_supplied_stock'] = $inventorydetailsbyid[$j]->first_supplied_stock;
			$info['last_supplied_stock'] = $inventorydetailsbyid[$j]->last_supplied_stock;
			$info['created_date'] = $dt->format('Y/m/d');
			$info['sold_quantity'] = $group[$j]['quantity'];
			$info['balance_stock'] = $inventorydetailsbyid[$j]->balance_stock - $group[$j]['quantity'];

			//echo "<pre>";
			//print_r($info);
			$updateinventorybyinvoiced_item = $this->INVOICEMODEL->updateinventorybyinvoiced_item($info);

		}*/

		
		

		$invoice_id = $this->input->post('invoice_id');
		if ($invoice ) {
			redirect("billingcontroller/printviewinvoice/$invoice_id");
		}
		
		

	}
	
	public function printviewinvoice($invoice_id,$command='')
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y-m-d');

		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);

		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		
		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);

		$data['storeInfo'] = $this->INVOICEMODEL->storeInfo();

		$data['querycurrencytag'] = $this->INVOICEMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/invoice/printviewinvoice', $data,TRUE);
		//printviewinvoice
		if($command=='email')
		{
			$data['command']='email';
			$invoicedetail=$data['queryinvoicebyinvoiceid'];
			$email_address=$invoicedetail->email_address;
			$content=$this->load->view('dashboard/invoice/email_view_invoice', $data, TRUE);
			$this->load->library('email');
			$config['protocol'] = 'smtp';
		    $config['smtp_host'] = 'mail.grameensoft.com'; //change this
		    $config['smtp_port'] = '25';
		    $config['smtp_user'] = 'info@grameensoft.com'; //change this
		    $config['smtp_pass'] = '123#123#'; //change this
		    $config['mailtype'] = 'html';
		    $config['charset'] = 'iso-8859-1';
		    $config['wordwrap'] = TRUE;
		    $config['newline'] = "\r\n";
			$this->email->initialize($config);
			$this->email->clear();
			$this->email->to($email_address);
			$this->email->from('info@grameensoft.com','Zaman IT');
			$this->email->reply_to('zamanit009@gmail.com','Zaman IT');
		    $this->email->subject('Invoice from Zaman IT');
		    $this->email->message($content);
		    $this->email->send();
			echo "<script>alert('Email has been sent');</script>";
		}
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deliverychalan($invoice_id,$command='')
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y-m-d');

		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);

		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		
		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);

		$data['storeInfo'] = $this->INVOICEMODEL->storeInfo();

		$data['querycurrencytag'] = $this->INVOICEMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/invoice/deliverychalan', $data,TRUE);
		//printviewinvoice
		if($command=='email')
		{
			$data['command']='email';
			$invoicedetail=$data['queryinvoicebyinvoiceid'];
			$email_address=$invoicedetail->email_address;
			$content=$this->load->view('dashboard/invoice/email_view_invoice', $data, TRUE);
			$this->load->library('email');
			$config['protocol'] = 'smtp';
		    $config['smtp_host'] = 'mail.grameensoft.com'; //change this
		    $config['smtp_port'] = '25';
		    $config['smtp_user'] = 'info@grameensoft.com'; //change this
		    $config['smtp_pass'] = '123#123#'; //change this
		    $config['mailtype'] = 'html';
		    $config['charset'] = 'iso-8859-1';
		    $config['wordwrap'] = TRUE;
		    $config['newline'] = "\r\n";
			$this->email->initialize($config);
			$this->email->clear();
			$this->email->to($email_address);
			$this->email->from('info@grameensoft.com','Zaman IT');
			$this->email->reply_to('zamanit009@gmail.com','Zaman IT');
		    $this->email->subject('Invoice from Zaman IT');
		    $this->email->message($content);
		    $this->email->send();
			echo "<script>alert('Email has been sent');</script>";
		}
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	
	public function send_sms($invcid='')
	{
	    ob_start();
		$queryinvoicebyinvoiceid = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invcid);
		$queryinvoiceditembyinvoiceid = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invcid);
		$duepaymenthistorybyinvoiceid = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invcid);
		$total_due_paid = 0;
        foreach ($duepaymenthistorybyinvoiceid as $duepaymenthistory) {
        	$total_due_paid = $duepaymenthistory->first_payment + $total_due_paid;
        }
        $messages = 'নাম: '.$queryinvoicebyinvoiceid->customer_name."\n";
		$messages .= 'মেমো নং: '.$queryinvoicebyinvoiceid->invoice_id."\n";
		$messages .= 'মোট বিল: '.$queryinvoicebyinvoiceid->grand_total.' Tk'."\n";
		$messages .= 'জমা: '.($queryinvoicebyinvoiceid->paid_amount+$total_due_paid).' Tk'."\n";
		$messages .= 'বাকী: '.$queryinvoicebyinvoiceid->due_amount.' Tk';
		//echo $queryinvoicebyinvoiceid->customer_mobile;
		 
		$url = 'http://sms.dhakasoftit.com/smsapi?api_key=C20033165d46de6008ae78.56511566&type=text/unicode&contacts='.$queryinvoicebyinvoiceid->customer_mobile.'&senderid=CBM BRICKS&msg='.urlencode($messages);	
		 
        $gateway = preg_replace("/ /", "%20", $url);
        $result = file_get_contents($gateway);  
        if($result){

            echo $result;
        }else{
            echo $result;
        }
        ob_end_flush(); 

	}

	public function searchinvoice()
	{
		$data = array();
		$invoice_id = $this->input->post('invoice_id');
		
		$checkingexisting = $this->INVOICEMODEL->checkingexisting($invoice_id);

		if($checkingexisting){
			redirect("billingcontroller/printviewinvoice/$invoice_id");
		}else{
			$invalied_invoice = "Please enter Valid Invoice No!!";
			$this->session->set_flashdata('invalied_invoice', $invalied_invoice);
			redirect("dashboardcontroller");
		}
		
	}
	
	public function viewinvoice()
	{
		$data = array();
		$data['queryinvoice'] = $this->INVOICEMODEL->queryinvoice();
		


		$data['dashboardContent'] = $this->load->view('dashboard/invoice/viewinvoice', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function viewdueinvoice()
	{
		$data = array();
		$data['querydueinvoice'] = $this->INVOICEMODEL->querydueinvoice();
		


		$data['dashboardContent'] = $this->load->view('dashboard/invoice/viewdueinvoice', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function addpaymentbyviewdueinvoice($invoice_id)
	{
		$data = array();
		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);
		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		

		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);



		$data['dashboardContent'] = $this->load->view('dashboard/invoice/editinvoiceforaddpayment', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertpaymentofduebyinvoiceid()
	{
		$data = array();
		//$dt = new DateTime();
		$data['invoice_id'] = $this->input->post('invoice_id');
		$data['first_payment'] = $this->input->post('first_payment');
		$data['payment_date'] = date('Y-m-d');
		
		$invoice_id = $this->input->post('invoice_id');
		if(empty($data['first_payment'])){
			$failed = "
				Please insert valid amount!<br>
				";
			$this->session->set_flashdata('failed', $failed);
			redirect("billingcontroller/addpaymentbyviewdueinvoice/$invoice_id");
		}

		$querybalancebyinvoiceid = $this->INVOICEMODEL->querybalancebyinvoiceid($data['invoice_id']);


		$duedata['due_amount'] = $querybalancebyinvoiceid->due_amount - $data['first_payment'];
		
		
		$update = $this->INVOICEMODEL->updatedueamountbyinvoiceid($duedata,$invoice_id);

		$result = $this->INVOICEMODEL->insertpaymentofduebyinvoiceid($data);

		if ($result) {
			$success = "
				Payment successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("billingcontroller/addpaymentbyviewdueinvoice/$invoice_id");
		}
	}

	public function deleteinvoicebyinvoiceid($invoice_id=Null)
	{
		$invoice = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfrominvoice($invoice_id);
		$invoiced_item = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfrominvoiced_item($invoice_id);
		$dues = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfromdues($invoice_id);

		//if ($invoice && $invoiced_item && $dues) 
		{
			$success = "
				Invoice Deleted Successfully!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("billingcontroller/viewinvoice");
		}
	}


	public function delivery($invoice_id='')
	{
		if($_POST){
			$invoice_id = $this->input->post('invoice_id');
			$data = array();
			$data['current_date'] = date('Y-m-d');
			$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);
			$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
			$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);
			$data['storeInfo'] = $this->INVOICEMODEL->storeInfo();
			$data['querycurrencytag'] = $this->INVOICEMODEL->querycurrencytag();

			$data['delivered'] = $this->db->get_where('invoiced_delivery', ['invoice_id'=>$invoice_id ])->result();

			$data['dashboardContent'] = $this->load->view('dashboard/delivery/searchresult', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}else{
			$data['dashboardContent'] = $this->load->view('dashboard/delivery/searchinvoiceid', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delivery_insert()
	{
		if($_POST){
			$operation = ' + ';
			$invoice_id = $this->input->post('invoice_id');
			$invoice_item_id = $this->input->post('invoice_item_id');
			$delivery = $this->input->post('delivery');
			$data = array(
				"invoice_id" => $invoice_id,
				"invoice_item_id" => $invoice_item_id,
				"product_name" => $this->input->post('product_name'),
				"delivery_date" => $this->input->post('delivery_date'),
				"chalan_no" => $this->input->post('chalan_no'),
				"delivery" => $delivery,
			); 
			$this->db->insert('invoiced_delivery', $data);
			$oldqty = $this->db->get_where('invoiced_item', ['id'=>$invoice_item_id ])->row('delivery');
			$this->db->set('delivery', $delivery+$oldqty, false)
                    ->where(array('id' => $invoice_item_id))
                    ->update('invoiced_item');

			
            //echo $this->db->last_query();
			
			redirect("billingcontroller/delivery");
		} 
	}

	public function delivery_delete($id='',$invoice_item_id="" )
	{
		$deleteqty = $this->db->get_where('invoiced_delivery', ['id'=>$id ])->row('delivery');
		$oldqty = $this->db->get_where('invoiced_item', ['id'=>$invoice_item_id ])->row('delivery');

		$this->db->set('delivery', $oldqty-$deleteqty, false)
                    ->where(array('id' => $invoice_item_id))
                    ->update('invoiced_item');

        $this->db->delete('invoiced_delivery', ['id'=>$id]);
		redirect("billingcontroller/delivery");
	}
}
?>