<?php $__env->startSection('title', __('backend.signedInToControl')); ?>
<?php $__env->startSection('content'); ?>
    <div class="center-block w-xxl p-a-2">
        <div class="box-color r box-shadow-z4 text-color m-b-0">
            <div class="p-a-md text-center">
                <?php if(Helper::GeneralSiteSettings("style_logo_" . @Helper::currentLanguage()->code) !=""): ?>
                    <img alt="" class="app-logo"
                         src="<?php echo e(URL::to('uploads/settings/'.Helper::GeneralSiteSettings("style_logo_" . @Helper::currentLanguage()->code))); ?>">
                <?php else: ?>
                    <img alt="" src="<?php echo e(URL::to('uploads/settings/nologo.png')); ?>">
                <?php endif; ?>
            </div>
            <div class="p-a text-center">
                <h5 class="text-muted m-b-0"><strong><?php echo e(__('backend.signedInToControl')); ?></strong></h5>
            </div>
            <div class="p-a-md">
            <form name="form" method="POST" action="<?php echo e(url('/'.config('smartend.backend_path').'/login')); ?>" onsubmit="document.getElementById('login_form_submit').disabled = true; return true;">
                <?php echo e(csrf_field()); ?>

                <?php if($errors ->any()): ?>
                    <div class="alert alert-danger m-b-0">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div><?php echo e($error); ?></div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                <?php endif; ?>

                <div class="md-form-group float-label <?php echo e($errors->has('email') ? ' has-error' : ''); ?>">
                    <input type="email" name="email" value="<?php echo e(old('email')); ?>" class="md-input" required>
                    <label><?php echo e(__('backend.connectEmail')); ?></label>
                </div>
                <div class="md-form-group float-label <?php echo e($errors->has('password') ? ' has-error' : ''); ?>">
                    <input type="password" name="password" class="md-input" required>
                    <label><?php echo e(__('backend.connectPassword')); ?></label>
                </div>
                <?php if($errors->has('password')): ?>
                    <span class="help-block">
                                        <strong><?php echo e($errors->first('password')); ?></strong>
                                    </span>
                <?php endif; ?>
                <?php if(config('smartend.nocaptcha_status')): ?>
                    <div class="form-group">
                        <?php echo NoCaptcha::renderJs(@Helper::currentLanguage()->code); ?>

                        <?php echo NoCaptcha::display(); ?>

                    </div>
                <?php endif; ?>
                <div class="m-b-md text-left">
                    <label class="md-check">
                        <input type="checkbox" name="remember"><i
                            class="primary"></i> <?php echo e(__('backend.keepMeSignedIn')); ?>

                    </label>
                </div>
                <button type="submit" id="login_form_submit" class="btn primary btn-block p-x-md m-b"><?php echo e(__('backend.signIn')); ?></button>
            </form>
            <?php if(config('smartend.facebook_status') && config('smartend.facebook_id') && config('smartend.facebook_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'facebook')); ?>" class="btn btn-primary btn-block text-left">
                    <i class="fa fa-facebook"></i> <?php echo e(__('backend.loginWithFacebook')); ?>

                </a>
            <?php endif; ?>
            <?php if(config('smartend.twitter_status') && config('smartend.twitter_id') && config('smartend.twitter_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'twitter')); ?>" class="btn btn-info btn-block text-left">
                    <i class="fa  fa-twitter"></i> <?php echo e(__('backend.loginWithTwitter')); ?>

                </a>
            <?php endif; ?>
            <?php if(config('smartend.google_status') && config('smartend.google_id') && config('smartend.google_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'google')); ?>" class="btn danger btn-block text-left">
                    <i class="fa fa-google"></i> <?php echo e(__('backend.loginWithGoogle')); ?>

                </a>
            <?php endif; ?>
            <?php if(config('smartend.linkedin_status') && config('smartend.linkedin_id') && config('smartend.linkedin_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'linkedin')); ?>" class="btn btn-primary btn-block text-left">
                    <i class="fa fa-linkedin"></i> <?php echo e(__('backend.loginWithLinkedIn')); ?>

                </a>
            <?php endif; ?>
            <?php if(config('smartend.github_status') && config('smartend.github_id') && config('smartend.github_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'github')); ?>" class="btn btn-default dark btn-block text-left">
                    <i class="fa fa-github"></i> <?php echo e(__('backend.loginWithGitHub')); ?>

                </a>
            <?php endif; ?>
            <?php if(config('smartend.bitbucket_status') && config('smartend.bitbucket_id') && config('smartend.bitbucket_secret')): ?>
                <a href="<?php echo e(route('social.oauth', 'bitbucket')); ?>" class="btn primary btn-block text-left">
                    <i class="fa fa-bitbucket"></i> <?php echo e(__('backend.loginWithBitbucket')); ?>

                </a>
            <?php endif; ?>

            <?php if(Helper::GeneralWebmasterSettings("register_status")): ?>
                <a href="<?php echo e(url('/'.config('smartend.backend_path').'/register')); ?>" class="btn info btn-block text-left">
                    <i class="fa fa-user-plus"></i> <?php echo e(__('backend.createNewAccount')); ?>

                </a>
            <?php endif; ?>
            <div class="p-v-lg text-center">
                <div class="m-t"><a href="<?php echo e(url('/'.config('smartend.backend_path').'/password/reset')); ?>"
                                    class="text-primary _600"><?php echo e(__('backend.forgotPassword')); ?></a></div>
            </div>
            </div>
        </div>


    </div>
<?php $__env->stopSection(); ?>


<?php echo $__env->make('dashboard.layouts.auth', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/marketandcommuni/public_html/core/resources/views/auth/login.blade.php ENDPATH**/ ?>