<?php $__env->startSection('content'); ?>
    <div>
        <?php
        $title_var = "title_" . @Helper::currentLanguage()->code;
        $title_var2 = "title_" . config('smartend.default_language');
        $details_var = "details_" . @Helper::currentLanguage()->code;
        $details_var2 = "details_" . config('smartend.default_language');
        if ($Topic->$title_var != "") {
            $title = $Topic->$title_var;
        } else {
            $title = $Topic->$title_var2;
        }
        if ($Topic->$details_var != "") {
            $details = $details_var;
        } else {
            $details = $details_var2;
        }
        $section = "";
        try {
            if ($Topic->section->$title_var != "") {
                $section = $Topic->section->$title_var;
            } else {
                $section = $Topic->section->$title_var2;
            }
        } catch (Exception $e) {
            $section = "";
        }
        ?>
        <section class="breadcrumbs">
            <div class="container">

                <div class="d-flex justify-content-between align-items-center">
                    <h2><?php echo e($title); ?></h2>
                    <ol>
                        <li><a href="<?php echo e(Helper::homeURL()); ?>"><?php echo e(__("backend.home")); ?></a></li>
                        <li><?php echo e($title); ?></li>
                    </ol>
                </div>

            </div>
        </section>

        <section id="contact" class="contact">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <article class="mb-5">
                            <?php if($WebmasterSection->type==2 && $Topic->video_file!=""): ?>
                                
                                <div class="post-video">
                                    <div class="video-container">
                                        <?php if($Topic->video_type ==1): ?>
                                            <?php
                                            $Youtube_id = Helper::Get_youtube_video_id($Topic->video_file);
                                            ?>
                                            <?php if($Youtube_id !=""): ?>
                                                
                                                <iframe allowfullscreen
                                                        src="https://www.youtube.com/embed/<?php echo e($Youtube_id); ?>">
                                                </iframe>
                                            <?php endif; ?>
                                        <?php elseif($Topic->video_type ==2): ?>
                                            <?php
                                            $Vimeo_id = Helper::Get_vimeo_video_id($Topic->video_file);
                                            ?>
                                            <?php if($Vimeo_id !=""): ?>
                                                
                                                <iframe allowfullscreen
                                                        src="https://player.vimeo.com/video/<?php echo e($Vimeo_id); ?>?title=0&amp;byline=0">
                                                </iframe>
                                            <?php endif; ?>

                                        <?php else: ?>
                                            <video width="100%" height="300" controls>
                                                <source src="<?php echo e(URL::to('uploads/topics/'.$Topic->video_file)); ?>"
                                                        type="video/mp4">
                                                Your browser does not support the video tag.
                                            </video>
                                        <?php endif; ?>


                                    </div>
                                </div>
                            <?php elseif($WebmasterSection->type==3 && $Topic->audio_file!=""): ?>
                                
                                <div class="post-video">
                                    <div class="video-container">
                                        <audio controls>
                                            <source src="<?php echo e(URL::to('uploads/topics/'.$Topic->audio_file)); ?>"
                                                    type="audio/mpeg">
                                            Your browser does not support the audio element.
                                        </audio>

                                    </div>
                                </div>

                            <?php elseif(count($Topic->photos)>0): ?>
                                
                                <div class="post-slider">
                                    <!-- start flexslider -->
                                    <div id="post-slider" class="flexslider">
                                        <ul class="slides">
                                            <?php if($Topic->photo_file !=""): ?>
                                                <li>
                                                    <img src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"
                                                         alt="<?php echo e($title); ?>"/>
                                                </li>
                                            <?php endif; ?>
                                            <?php $__currentLoopData = $Topic->photos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li>
                                                    <img src="<?php echo e(URL::to('uploads/topics/'.$photo->file)); ?>"
                                                         alt="<?php echo e($photo->title); ?>"/>
                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </ul>
                                    </div>
                                    <!-- end flexslider -->
                                </div>

                            <?php else: ?>
                                
                                <div class="post-image">
                                    <?php if($Topic->photo_file !=""): ?>
                                        <img src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"
                                             alt="<?php echo e($title); ?>"/>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php echo $Topic->$details; ?>

                            <?php if($Topic->attach_file !=""): ?>
                                <?php
                                $file_ext = strrchr($Topic->attach_file, ".");
                                $file_ext = strtolower($file_ext);
                                ?>
                                <div class="bottom-article">
                                    <?php if($file_ext ==".jpg"|| $file_ext ==".jpeg"|| $file_ext ==".png"|| $file_ext ==".gif"): ?>
                                        <div class="text-center">
                                            <img src="<?php echo e(URL::to('uploads/topics/'.$Topic->attach_file)); ?>"
                                                 alt="<?php echo e($title); ?>"/>
                                        </div>
                                    <?php else: ?>
                                        <a href="<?php echo e(URL::to('uploads/topics/'.$Topic->attach_file)); ?>">
                                            <strong><i class="fa fa-paperclip"></i>
                                                &nbsp;<?php echo e(__('frontend.downloadAttach')); ?></strong>
                                        </a>
                                    <?php endif; ?>
                                </div>
                            <?php endif; ?>

                            <?php echo $__env->make("frontEnd.topic.files", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </article>
                    </div>
                </div>
                <?php echo $__env->make("frontEnd.topic.maps", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>

            <div class="container">
                <div class="row">

                    <div class="col-lg-4">
                        <h3 class="sub-title"><?php echo e(__('frontend.contactDetails')); ?></h3>
                        <div class="info">
                            <?php if(Helper::GeneralSiteSettings("contact_t1_" . @Helper::currentLanguage()->code) !=""): ?>
                                <div class="address">
                                    <i class="bi bi-geo-alt"></i>
                                    <h4><?php echo e(__('frontend.address')); ?>:</h4>
                                    <p><?php echo e(Helper::GeneralSiteSettings("contact_t1_" . @Helper::currentLanguage()->code)); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if(Helper::GeneralSiteSettings("contact_t3") !=""): ?>
                                <div class="phone">
                                    <i class="bi bi-telephone"></i>
                                    <h4><?php echo e(__('frontend.callPhone')); ?>:</h4>
                                    <p><span
                                            dir="ltr"><?php echo e(Helper::GeneralSiteSettings("contact_t3")); ?></span></p>
                                </div>
                            <?php endif; ?>
                            <?php if(Helper::GeneralSiteSettings("contact_t5") !=""): ?>
                                <div class="phone">
                                    <i class="bi bi-telephone"></i>
                                    <h4><?php echo e(__('frontend.callMobile')); ?>:</h4>
                                    <p><span
                                            dir="ltr"><?php echo e(Helper::GeneralSiteSettings("contact_t5")); ?></span></p>
                                </div>
                            <?php endif; ?>
                            <?php if(Helper::GeneralSiteSettings("contact_t4") !=""): ?>
                                <div class="phone">
                                    <i class="fa fa-fax"></i>
                                    <h4><?php echo e(__('frontend.callFax')); ?>:</h4>
                                    <p><span
                                            dir="ltr"><?php echo e(Helper::GeneralSiteSettings("contact_t4")); ?></span></p>
                                </div>
                            <?php endif; ?>
                            <?php if(Helper::GeneralSiteSettings("contact_t6") !=""): ?>
                                <div class="email">
                                    <i class="bi bi-envelope"></i>
                                    <h4><?php echo e(__('frontend.email')); ?>:</h4>
                                    <p><?php echo e(Helper::GeneralSiteSettings("contact_t6")); ?></p>
                                </div>
                            <?php endif; ?>
                            <?php if(Helper::GeneralSiteSettings("contact_t7_" . @Helper::currentLanguage()->code) !=""): ?>
                                <div class="email">
                                    <i class="bi bi-clock"></i>
                                    <h4><?php echo e(__('frontend.callTimes')); ?>:</h4>
                                    <p><?php echo e(Helper::GeneralSiteSettings("contact_t7_" . @Helper::currentLanguage()->code)); ?></p>
                                </div>
                            <?php endif; ?>
                        </div>

                    </div>

                    <div class="col-lg-8 mt-5 mt-lg-0" id="contact-form-container">
                        <h3 class="sub-title"><?php echo e(__('frontend.getInTouch')); ?></h3>
                        <?php echo e(Form::open(['route'=>['contactPageSubmit'],'method'=>'POST','class'=>'php-email-form','id'=>'contactForm'])); ?>

                        <div class="row">
                            <div class="col-md-4 form-group">
                                <?php echo Form::text('contact_name',@Auth::user()->name, array('placeholder' => __('frontend.yourName'),'class' => 'form-control','id'=>'name','required'=>'required')); ?>

                            </div>
                            <div class="col-md-4 form-group mt-3 mt-md-0">
                                <?php echo Form::email('contact_email',@Auth::user()->email, array('placeholder' => __('frontend.yourEmail'),'class' => 'form-control','id'=>'email','required'=>'required')); ?>

                            </div>
                            <div class="col-md-4 form-group mt-3 mt-md-0">
                                <?php echo Form::text('contact_phone',"", array('placeholder' => __('frontend.phone'),'class' => 'form-control','id'=>'phone','required'=>'required')); ?>

                            </div>
                        </div>
                        <div class="form-group mt-3">
                            <?php echo Form::text('contact_subject',"", array('placeholder' => __('frontend.subject'),'class' => 'form-control','id'=>'subject','required'=>'required')); ?>

                        </div>
                        <div class="form-group mt-3">
                            <?php echo Form::textarea('contact_message','', array('placeholder' => __('frontend.message'),'class' => 'form-control','id'=>'message','rows'=>'10','required'=>'required')); ?>

                        </div>

                        <?php if(config('smartend.nocaptcha_status')): ?>
                            <div class="form-group mt-3">
                                <?php echo NoCaptcha::renderJs(@Helper::currentLanguage()->code); ?>

                                <?php echo NoCaptcha::display(); ?>

                            </div>
                        <?php endif; ?>
                        <div class="submit-message"></div>
                        <div>
                            <button type="submit" id="contactFormSubmit" class="btn btn-lg btn-theme"><i
                                    class="fa-solid fa-paper-plane"></i> <?php echo e(__('frontend.sendMessage')); ?></button>
                        </div>
                        <?php echo e(Form::close()); ?>


                    </div>

                </div>

            </div>
        </section>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('footInclude'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#contactForm').submit(function (evt) {
                evt.preventDefault();
                let btn = $('#contactFormSubmit');
                btn.html("<img src=\"<?php echo e(asset('assets/dashboard/images/loading.gif')); ?>\" style=\"height: 20px\"/> <?php echo __('frontend.sendMessage'); ?>");
                btn.prop('disabled', true);
                var formData = new FormData(this);
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route("contactPageSubmit")); ?>",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (result) {
                        let stat = 'alert-danger';
                        if (result.stat === 'success') {
                            stat = 'alert-success';
                            $('#contactForm')[0].reset();
                        }
                        let confirm = '<div class="alert ' + stat + ' alert-dismissible fade show mt-3" role="alert">' + result.msg + '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>';
                        $("#contactForm .submit-message").html(confirm);
                        btn.html('<i class="fa-solid fa-paper-plane"></i> <?php echo __('frontend.sendMessage'); ?>');
                        btn.prop('disabled', false);
                    }
                });
                return false;
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontEnd.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/contact.blade.php ENDPATH**/ ?>