<div id="order">
    <div class="row">
        <div class="col-lg-12">
            <br>
            <h4><i class="fa-solid fa-cart-plus"></i> <?php echo e(__('frontend.orderForm')); ?>

            </h4>
            <div class="bottom-article">
                <?php echo e(Form::open(['route'=>['orderSubmit'],'method'=>'POST','class'=>'orderForm','id'=>'orderForm'])); ?>

                <div class="row">
                    <div class="col-md-4 form-group">
                        <label for="order_name"
                               class="form-control-label"><?php echo __('frontend.name'); ?></label>
                        <?php echo Form::text('order_name',@Auth::user()->name, array('placeholder' => __('frontend.yourName'),'class' => 'form-control','id'=>'order_name', 'required'=> '')); ?>

                    </div>
                    <div class="col-md-4 form-group">
                        <label for="order_phone"
                               class="form-control-label"><?php echo __('frontend.phone'); ?></label>
                        <?php echo Form::text('order_phone',"", array('placeholder' => __('frontend.phone'),'class' => 'form-control','id'=>'order_phone', 'required'=> '')); ?>

                    </div>
                    <div class="col-md-4 form-group">
                        <label for="order_email"
                               class="form-control-label"><?php echo __('frontend.email'); ?></label>
                        <?php echo Form::email('order_email',@Auth::user()->email, array('placeholder' => __('frontend.yourEmail'),'class' => 'form-control','id'=>'order_email', 'required'=> '')); ?>

                    </div>
                </div>
                <div class="form-group">
                    <?php echo Form::textarea('order_message','', array('placeholder' => __('frontend.notes'),'class' => 'form-control','id'=>'order_message','rows'=>'5')); ?>

                </div>

                <?php if(config('smartend.nocaptcha_status')): ?>
                    <div class="form-group">
                        <?php echo NoCaptcha::renderJs(@Helper::currentLanguage()->code); ?>

                        <?php echo NoCaptcha::display(); ?>

                    </div>
                <?php endif; ?>
                <div class="submit-message"></div>
                <div>
                    <input type="hidden" name="topic_id" value="<?php echo e($Topic->id); ?>">
                    <button type="submit" id="orderFormSubmit"
                            class="btn btn-lg btn-theme"><i
                            class="fa-solid fa-paper-plane"></i> <?php echo e(__('frontend.sendOrder')); ?>

                    </button>
                </div>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('after-scripts'); ?>
    <script type="text/javascript">
        $(document).ready(function () {
            $('#orderForm').submit(function (evt) {
                evt.preventDefault();
                let btn = $('#orderFormSubmit');
                btn.html("<img src=\"<?php echo e(asset('assets/dashboard/images/loading.gif')); ?>\" style=\"height: 20px\"/> <?php echo __('frontend.sendOrder'); ?>");
                btn.prop('disabled', true);
                var formData = new FormData(this);
                $.ajax({
                    type: "POST",
                    url: "<?php echo e(route("orderSubmit")); ?>",
                    data: formData,
                    cache: false,
                    contentType: false,
                    processData: false,
                    success: function (result) {
                        let stat = 'alert-danger';
                        if (result.stat === 'success') {
                            stat = 'alert-success';
                            $('#orderForm')[0].reset();
                        }
                        let confirm = '<div class="alert ' + stat + ' alert-dismissible fade show mt-3" role="alert">' + result.msg + '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button></div>';
                        $("#orderForm .submit-message").html(confirm);
                        btn.html('<i class="fa-solid fa-paper-plane"></i> <?php echo __('frontend.sendOrder'); ?>');
                        btn.prop('disabled', false);
                    }
                });
                return false;
            });
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/topic/order.blade.php ENDPATH**/ ?>