<?php
$StaffLimit = 6; // 0 = all
$Staff = Helper::Topics(Helper::GeneralWebmasterSettings("home_content5_section_id"), 0, $StaffLimit, 1);
?>
<?php if(count($Staff)>0): ?>
    <section id="staff" class="staff">
        <div class="container">

            <div class="section-title">
                <h2><?php echo e(__('frontend.homeStaffTitle')); ?></h2>
                <p><?php echo e(__('frontend.homeStaffDesc')); ?></p>
            </div>

            <div class="row">
                <?php
                $section_url = "";
                ?>
                <?php $__currentLoopData = $Staff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Topic): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                    if ($Topic->$title_var != "") {
                        $title = $Topic->$title_var;
                    } else {
                        $title = $Topic->$title_var2;
                    }
                    if ($Topic->$details_var != "") {
                        $details = $details_var;
                    } else {
                        $details = $details_var2;
                    }
                    if ($section_url == "") {
                        $section_url = Helper::sectionURL($Topic->webmaster_id);
                    }
                    $topic_link_url = Helper::topicURL($Topic->id);
                    $HomeSectionType = @$Topic->webmasterSection->type;
                    if (!@$require_mp3_player && $HomeSectionType == 3) {
                        $require_mp3_player = 1;
                    }
                    ?>
                    <div class="col-lg-6 mb-4">
                        <div class="member d-flex align-items-start">
                            <?php if($Topic->photo_file !=""): ?>
                                <a href="<?php echo e($topic_link_url); ?>">
                                    <div class="pic">
                                        <img class="img-fluid" loading="lazy"
                                             src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>" width="120" height="120"
                                             alt="<?php echo e($title); ?>"/>
                                    </div>
                                </a>
                            <?php endif; ?>
                            <div class="member-info">
                                <a href="<?php echo e($topic_link_url); ?>"><h4><?php echo $title; ?></h4></a>
                                
                                <?php echo $__env->make("frontEnd.topic.fields",["cols"=>12,"Fields"=>@$Topic->webmasterSection->customFields->where("in_listing",true)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                <span></span>

                                <?php if(strip_tags($Topic->$details) !=""): ?>
                                    <p>
                                        <?php echo mb_substr(strip_tags($Topic->$details),0, 140)."..."; ?>

                                        <a href="<?php echo e($topic_link_url); ?>"><?php echo e(__("frontend.moreDetails")); ?></a>
                                    </p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

            </div>

            <div class="row">
                <div class="col-lg-12">
                    <div class="more-btn">
                        <a href="<?php echo e(url($section_url)); ?>" class="btn btn-theme"><i
                                class="fa fa-angle-left"></i>&nbsp; <?php echo e(__('frontend.viewMore')); ?>

                            &nbsp;<i
                                class="fa fa-angle-right"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/homepage/row3.blade.php ENDPATH**/ ?>