<?php if(Helper::GeneralWebmasterSettings("text_editor") ==2): ?>
    <script src="<?php echo e(asset("assets/dashboard/js/ckeditor/ckeditor.js")); ?>"></script>
    <script>
        CKEDITOR.editorConfig = function (config) {
            config.language = '<?php echo e(@Helper::currentLanguage()->code); ?>';
            config.height = 500;
            config.uiColor = '#ffffff';
            config.toolbarCanCollapse = true;
            config.filebrowserImageBrowseUrl = '/file-manager/ckeditor';
            config.contentsCss = '<?php echo e(URL::asset('assets/dashboard/css/bootstrap/dist/css/bootstrap.min.css')); ?>?v=<?php echo e(Helper::system_version()); ?>';
            config.extraPlugins = 'toc';
        };
    </script>
<?php elseif(Helper::GeneralWebmasterSettings("text_editor") ==1): ?>
    <?php
    $tiny_key = Helper::GeneralWebmasterSettings("tiny_key");
    if ($tiny_key == "") {
        $tiny_key = "no-key";
    }
    ?>
    <script src="//cdn.tiny.cloud/1/<?php echo e($tiny_key); ?>/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>
    <script>
        tinymce.init({
            selector: '.tinymce',
            height: 550,
            directionality: '<?php echo e(@Helper::currentLanguage()->direction); ?>',
            language: '<?php echo e(@Helper::currentLanguage()->code); ?>',
            relative_urls : false,
            remove_script_host : false,
            convert_urls : true,
            plugins: 'print preview paste importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap hr pagebreak nonbreaking anchor toc insertdatetime advlist lists wordcount imagetools textpattern noneditable help charmap quickbars emoticons',
            imagetools_cors_hosts: ['picsum.photos'],
            menubar: 'file edit view insert format tools table help',
            toolbar: 'undo redo | bold italic underline strikethrough | fontselect fontsizeselect formatselect | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
            content_css: "<?php echo e(URL::asset('assets/dashboard/css/bootstrap/dist/css/bootstrap.min.css')); ?>?v=<?php echo e(Helper::system_version()); ?>",
            toolbar_sticky: false,
            toolbar_mode: 'sliding',
            file_picker_callback(callback, value, meta) {
                let x = window.innerWidth || document.documentElement.clientWidth || document.getElementsByTagName('body')[0].clientWidth
                let y = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight

                tinymce.activeEditor.windowManager.openUrl({
                    url: '/file-manager/tinymce5',
                    title: '<?php echo e(__("backend.fileManager")); ?>',
                    width: x * 0.8,
                    height: y * 0.8,
                    onMessage: (api, message) => {
                        callback(message.content, {text: message.text})
                    }
                })
            }
        });
    </script>
    <style>
        .tox-notification--warning {
            display: none !important;
        }
    </style>
<?php else: ?>
    <script src="<?php echo e(asset("assets/dashboard/js/summernote/dist/summernote.js")); ?>"></script>
    <script>
        function sendFile(file, editor, welEditable, lang) {
            data = new FormData();
            data.append("file", file);
            data.append("_token", "<?php echo e(csrf_token()); ?>");
            $.ajax({
                data: data,
                type: 'POST',
                xhr: function () {
                    var myXhr = $.ajaxSettings.xhr();
                    if (myXhr.upload) myXhr.upload.addEventListener('progress', progressHandlingFunction, false);
                    return myXhr;
                },
                url: "<?php echo e(route("topicsPhotosUpload")); ?>",
                cache: false,
                contentType: false,
                processData: false,
                success: function (url) {
                    var image = $('<img>').attr('src', '<?php echo e(asset("uploads/topics/")); ?>/' + url);
                    <?php $__currentLoopData = Helper::languagesList(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ActiveLanguage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($ActiveLanguage->box_status): ?>
                    if (lang == "<?php echo e($ActiveLanguage->code); ?>") {
                        $('.summernote_<?php echo e($ActiveLanguage->code); ?>').summernote("insertNode", image[0]);
                    }
                    <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                }
            });
        }

        // update progress bar
        function progressHandlingFunction(e) {
            if (e.lengthComputable) {
                $('progress').attr({value: e.loaded, max: e.total});
                // reset progress on complete
                if (e.loaded == e.total) {
                    $('progress').attr('value', '0.0');
                }
            }
        }
    </script>
<?php endif; ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/dashboard/layouts/editor.blade.php ENDPATH**/ ?>