<style>
:root{ 
    --white:#fff;
    --background: #F5F5F5;
    --main-color: #05BEC0; 
}
.serviceBox{
    color: var(--white);
    background: var(--background);
    font-family: 'Roboto', sans-serif;
    text-align: left;
    position: relative;
    z-index: 0;
}
.serviceBox img{
    margin: 0 0 0 38px;
}

.serviceBox .title{
    background-color: var(--main-color);
    font-size: 13px;
    font-weight: 500;
    text-transform: uppercase;
    padding: 10px 10px 10px;
    box-shadow: inset 0 -6px 6px rgba(0,0,0,0.3);
    margin: 0 0 20px;
}
.serviceBox .description{
    color: #999;
    font-size: 13px;
    line-height: 25px;
    margin: 4px 10px 0;
    text-align: center;
}
.serviceBox .service-icon{
    background-color: var(--main-color);
    font-size: 35px;
    line-height: 35px;
    padding: 25px 0 15px;
    box-shadow: inset 0 6px 6px rgba(0,0,0,0.3);
}
.serviceBox.green{ --main-color: #00b106; }
@media only screen and (max-width: 1199px){
   .serviceBox{ margin: 0 0 40px; }
}
.rsidebar-whc ul{
  padding: 10px 0;  
}
.rsidebar-whc ul li{
  background: url("https://rhd.portal.gov.bd/themes/responsive_npf/images/bg_block_list.png") no-repeat scroll 0 0 rgba(0, 0, 0, 0);
  border-bottom: 1px solid transparent;
  border-image: linear-gradient(to right, #683091 0%, #8bc643 100%);
  border-image-slice: 1;
  font-size: 70%;
  height: auto;
  list-style-type: none;
  margin-bottom: 5px;
  padding-left: 32px;
  padding-top: 0px;
  padding-bottom: 8px;
  background-position: left;
}
.wrapper {
    width: 212px;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 15px 40px rgba(0, 0, 0, 0.12);
}

.wrapper header {
    display: flex;
    align-items: center;
    padding: 25px 30px 10px;
    justify-content: space-between;
}

header .icons {
    display: flex;
    margin: 0 0 20px 0;
}

header .icons span {
    height: 25px;
    width: 25px;
    margin: 0 1px;
    cursor: pointer;
    color: #878787;
    text-align: center;
    line-height: 27px;
    font-size: 15px;
    user-select: none;
    border-radius: 50%;
}

.icons span:last-child {
    margin-right: -10px;
}

header .icons span:hover {
    background: #f2f2f2;
}

header .current-date {
    font-size: 14px;
    font-weight: 500;
}

.calendar {
    padding: 0px;
}

.calendar ul {
    display: flex;
  flex-wrap: wrap;
  list-style: none;
  text-align: left;
  margin-left: -16px;
}

.calendar .days {
    margin-bottom: 20px;
}

.calendar li {
    color: #333;
    width: calc(100% / 7);
  font-size: 10px;
}

.calendar .weeks li {
    font-weight: 500;
    cursor: default;
}

.calendar .days li {
    z-index: 1;
    cursor: pointer;
    position: relative;
    margin-top: 15px;
}

.days li.inactive {
    color: #aaa;
}

.days li.active {
    color: #fff;
}

.days li::before {
    position: absolute;
    content: "";
    left: 20%;
  top: 50%;
  height: 25px;
  width: 25px;
    z-index: -1;
    border-radius: 50%;
    transform: translate(-50%, -50%);
}

.days li.active::before {
    background: #9B59B6;
}

.days li:not(.active):hover::before {
    background: #f2f2f2;
}
</style>

<div class="container" style="">
    <div class="row">
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title">Honorable Minister</h3>
                <img alt="" src="https://rhd.portal.gov.bd/sites/default/files/files/rhd.portal.gov.bd/npfblock//2021-01-14-10-32-47f967c89f00b06399b3bf9860618ce5.JPG" style="border-style:solid; border-width:1px; height:145px; width:135px">
                <p class="description">
                <span class="text-dark">
                Mr. Obaidul Quader, MP

                Honorable Minister<br>
                
                Ministry of Road Transport and Bridges
                <br>
                <a href="#" style="float: inline-end;">Details...</a>
                </span>
                </p>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title">Secretary</h3>
                <img alt="" src="https://rhd.portal.gov.bd/sites/default/files/files/rhd.portal.gov.bd/npfblock/81c0c72f_60f0_41c7_94aa_6d10e96e60a7/2022-06-05-11-22-7bb15dafe453b14d4099f417b19ff950.jpg" style="border-style:solid; border-width:1px; height:145px; width:135px">
                <p class="description">
                <span class="text-dark">
                A B M Amin Ullah Nuri
                <br>
                Secretary
                <br>
                Road Transport and Highways Division
                <br>
                <a href="#" style="float: inline-end;">Details...</a>
                </span>
                </p>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title">Chief Engineer</h3>
                <img alt="" src="https://rhd.portal.gov.bd/sites/default/files/files/rhd.portal.gov.bd/npfblock//2023-07-02-10-47-3031c94a694e654ec14d610f32803f5a.jpg" style="border-style:solid; border-width:1px; height:145px; width:135px">
                <p class="description">
                <span class="text-dark">
                Syed Moinul Hasan
                <br>
                Chief Engineer
                <br>
                Roads and Highways Department
                <br>
                <a href="#" style="float: inline-end;">Details...</a>
                </span>
                </p>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title">Publication: A Changing Scenario</h3>
                <a href="#">
                <img alt="" src="https://bangladesh.gov.bd/sites/default/files/files/bangladesh.gov.bd/files/bf4d64c5_4154_4bd2_99d5_45417fcea069/A%20Changing%20Scenario.png" style="border-style:solid; border-width:1px; width:180px;margin: 0 0 0 16px;">
                </a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12 mt-3">
            <div class="serviceBox rsidebar-whc green">
                <h3 class="title">Internal eServices</h3>
                <ul class="">   
                  <li><a href="#" title="Officers' e-mail / Mobile No">Officers' e-mail / Mobile No</a></li>
                  <li><a href="#" title="e-GP Project Information forms">e-GP Project Information forms</a></li>
                  <li><a href="#" title="Personal Data Sheet Update Form">Personal Data Sheet Update Form</a></li>
                  <li><a href="#" title="Web mail">Web mail</a></li>
                  <li><a href="#" title="e-nothi form">e-nothi form</a></li>
                  <li><a href="#" title="Digital Nothi Number">Digital Nothi Number</a></li>
                </ul>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <a href="#"><h3 class="title text-center text-light">All</h3></a>
                <a href="#">
                <img alt="" src="https://rhd.portal.gov.bd/sites/default/files/files/btcl.portal.gov.bd/page/504001e6_3ae9_4d5c_8812_cfc3f6bf6fa1/2023-05-17-05-19-8f5613e215b7e3862d073765f22f8456.png" style="border-style:solid; border-width:1px; width:195px;margin: 0 0 8px 8px;">
                </a>
                <a href="#">
                <img alt="" src="https://rhd.portal.gov.bd/sites/default/files/files/btcl.portal.gov.bd/page/b7105a91_1576_4367_881b_3c27692ec31a/2023-05-16-09-33-4cadb23704651f9f0a9e8beb137880ab.png" style="border-style:solid; border-width:1px; width:195px;margin: 0 0 8px 8px;">
                </a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title">Event Calander</h3>
                <div class="wrapper">
                <header>
                    <p class="current-date text-dark"></p>
                    <div class="icons">
                        <span id="prev" class="material-symbols-rounded"><i class="fa fa-arrow-left"></i></span>
                        <span id="next" class="material-symbols-rounded"><i class="fa fa-arrow-right"></i></span>
                    </div>
                </header>
                <div class="calendar">
                    <ul class="weeks">
                        <li>Sun</li>
                        <li>Mon</li>
                        <li>Tue</li>
                        <li>Wed</li>
                        <li>Thu</li>
                        <li>Fri</li>
                        <li>Sat</li>
                    </ul>
                    <ul class="days"></ul>
                </div>
            </div>
            <div style="margin-top: 10px;margin-bottom: 10px;">
        		<a href="/site/view/calendar_event" class="btn btn-dark btn-sm" style="display:block; text-align:center; text-decoration:underline;" title="">All Event</a>
        	</div>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <a href="#"><h3 class="title text-center text-light">Central e-Services</h3></a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title text-center text-light"> Website Hit Count </h3>
                <script type="text/javascript" src="https://www.free-counters.org/count/fdww"></script><br>
                 <a href='https://www.acadoo.de/leistungen/ghostwriter-masterarbeit/'>Masterarbeit Hilfe</a> <script type='text/javascript' src='https://www.whomania.com/ctr?id=f08790eb291c93b5f0fb55601564eb4afe990af0'></script>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green rsidebar-whc">
                <a href="#"><h3 class="title text-center text-light">Important Link</h3></a>
                <ul class="">   
                  <li><a href="#" title="">E-Info Cell</a></li>
                  <li><a href="#" title="">Finance Division</a></li>
                  <li><a href="#" title="">Road Transport and Highways Division</a></li>
                  <li><a href="#" title="">E-Nothi</a></li>
                  <li><a href="#" title="">e-GP</a></li>
                  <li><a href="#" title="">CPTU</a></li>
                </ul>
                <div style="margin-top: 5px;margin-bottom: 10px;">
        		<a href="/site/view/calendar_event" class="btn btn-dark btn-sm" style="display:block; text-align:center; text-decoration:underline;" title="">All Link</a>
        	</div>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <a href="#"><h3 class="title text-center text-light">Service Simplification</h3></a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title text-center text-light">Sheikh Russell Medal 2024</h3>
                <a href="#">
                <img alt="" src="http://cabinet.portal.gov.bd/sites/default/files/files/cabinet.portal.gov.bd/npfblock//rasel.jpeg" style="border-style:solid; border-width:1px; width:180px;margin: 0 0 0 16px;">
                </a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title text-center text-light">National Anthem</h3>
                <audio controls="" style="width:100%" __idm_id__="819201">
                 <source src="https://rhd.portal.gov.bd/sites/default/files/files/cabinet.portal.gov.bd/page/e5f25d4e_f0a7_4b2a_a07c_3ec69a793516/bd_national_anthem.mp3" type="audio/mp3">
                </audio>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green rsidebar-whc">
                <a href="#"><h3 class="title text-center text-light">Innovation Corner</h3></a>
                <ul class="">   
                  <li><a href="#" title="">Digital Innovation</a></li>
                  <li><a href="#" title="">Annual Innovation Action Planning</a></li>
                  <li><a href="#" title="">Idia Bank</a></li>
                </ul>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <a href="#"><h3 class="title text-center text-light">Nabospondon</h3></a>
                <a href="#">
                <img alt="" src="https://admin.portal.gov.bd/sites/default/files/files/admin.portal.gov.bd/npfblock//2023-12-12-17-32-bf5f839dc328e3aa0d192ada900eaf76.jpg" style="border-style:solid; border-width:1px;width:195px;margin: 0 0 8px 8px;">
                </a>
                <a href="#">
                <img alt="" src="https://admin.portal.gov.bd/sites/default/files/files/admin.portal.gov.bd/npfblock/8230d39d_adbc_444b_b5da_e91d7e1974b5/2023-10-17-04-46-956184e9a6c84adb47014df04dd87510.jpg" style="border-style:solid; border-width:1px; width:195px;margin: 0 0 8px 8px;">
                </a>
                <a href="#">
                <img alt="" src="https://ictd.portal.gov.bd/sites/default/files/files/ictd.portal.gov.bd/npfblock/6c9cad15_7fa7_4419_b4d5_b3b21dc228a5/bkkb_button_en.png" style="border-style:solid; border-width:1px; width:195px;margin: 0 0 8px 8px;">
                </a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <a href="#"><h3 class="title text-center text-light">Govt. office attachment application form</h3></a>
            </div>
        </div>
        <div class="col-md-12 col-sm-12">
            <div class="serviceBox green">
                <h3 class="title text-center text-light">Emergency Helpline Number</h3>
                <a href="#">
                <img alt="" src="https://admin.portal.gov.bd/sites/default/files/files/admin.portal.gov.bd/npfblock//2023-11-23-10-25-af9547ee397434fcd852c354feeeaa92.png" style="border-style:solid; border-width:1px; width:195px;margin: 0 0 8px 8px;">
                </a>
            </div>
        </div>
    </div>
</div>

