-@extends('dashboard.layouts.master')
@section('title', __('Sub Slider Banner'))
@push("after-styles")
    <link href="{{ asset("assets/dashboard/js/iconpicker/fontawesome-iconpicker.min.css") }}" rel="stylesheet">
@endpush
@section('content')
    <div class="padding">
        <div class="box">
            <div class="box-header dker">
                <h3><i class="material-icons">&#xe02e;</i> {{ __('backend.bannerAdd') }}</h3>
                <small>
                    <a href="{{ route('adminHome') }}">{{ __('backend.home') }}</a> /
                    <a href="">{{ __('backend.adsBanners') }}</a>
                </small>
            </div>
            <div class="box-tool">
                <ul class="nav">
                    <li class="nav-item inline">
                        <a class="nav-link" href="{{route("subsliders")}}">
                            <i class="material-icons md-18">×</i>
                        </a>
                    </li>
                </ul>
            </div>
            <div class="box-body">
                {{ Form::open(['route' => ['subslidersStore'], 'method' => 'POST', 'files' => true]) }}

                @foreach(Helper::languagesList() as $ActiveLanguage)
                    @if($ActiveLanguage->box_status)
                        <!-- Banner Title -->
                        <div class="form-group row">
                            <label class="col-sm-2 form-control-label">
                                {!! __('backend.bannerTitle') !!} {!! @Helper::languageName($ActiveLanguage) !!}
                            </label>
                            <div class="col-sm-10">
                                {!! Form::text('title_' . @$ActiveLanguage->code, '', [
                                    'placeholder' => __('backend.enterBannerTitle'),
                                    'class' => 'form-control',
                                    'required' => '',
                                    'dir' => @$ActiveLanguage->direction
                                ]) !!}
                            </div>
                        </div>
                    @endif
                @endforeach
                
                <!-- File Upload Section -->
                <div id="files_div">
                    @foreach(Helper::languagesList() as $ActiveLanguage)
                        @if($ActiveLanguage->box_status)
                            <div class="form-group row">
                                <label class="col-sm-2 form-control-label">
                                    {!! __('Banner') !!} {!! @Helper::languageName($ActiveLanguage) !!}
                                </label>
                                <div class="col-sm-10">
                                    {!! Form::file('file_' . $ActiveLanguage->code, ['class' => 'form-control', 'accept' => 'image/*']) !!}
                                </div>
                            </div>
                        @endif
                    @endforeach
                </div>
                
                @foreach(Helper::languagesList() as $ActiveLanguage)
                    @if($ActiveLanguage->box_status)
                        <!-- Banner Details -->
                        <div class="form-group row">
                            <label class="col-sm-2 form-control-label">
                                {!! __('backend.bannerDetails') !!} {!! @Helper::languageName($ActiveLanguage) !!}
                            </label>
                            <div class="col-sm-10">
                                {!! Form::textarea('details_' . $ActiveLanguage->code, '', [
                                    'placeholder' => __('backend.enterBannerDetails'),
                                    'class' => 'form-control',
                                    'dir' => @$ActiveLanguage->direction,
                                    'rows' => 3
                                ]) !!}
                            </div>
                        </div>
                    @endif
                @endforeach
                
                <!-- Submit Button -->
                <div class="form-group row m-t-md">
                    <div class="offset-sm-2 col-sm-10">
                        <button type="submit" class="btn btn-primary m-t">
                            <i class="material-icons">&#xe31b;</i> {!! __('backend.add') !!}
                        </button>
                        <a href="{{ route('Banners') }}" class="btn btn-default m-t">
                            <i class="material-icons">&#xe5cd;</i> {!! __('backend.cancel') !!}
                        </a>
                    </div>
                </div>
                
                {{ Form::close() }}

            </div>
        </div>
    </div>
@endsection
@push("after-scripts")
    <script src="{{ asset("assets/dashboard/js/iconpicker/fontawesome-iconpicker.js") }}"></script>
    <script>
        $(function () {
            $('.icp-auto').iconpicker({placement: '{{ (@Helper::currentLanguage()->direction=="rtl")?"topLeft":"topRight" }}'});
        });
    </script>
@endpush
