@extends('dashboard.layouts.master')
@section('title', __('Home Sub Sliders'))
@section('content')
    <div class="padding">
        <div class="box">
            

                    <div class="row p-a">
                        <div class="col-sm-12">
                                <a class="btn btn-fw primary marginBottom5"
                                   href="{{ route('subslidersCreate') }}">
                                    <i class="material-icons">&#xe02e;</i> Add New</a>
                        </div>
                    </div>


                <div class="table-responsive">
                    <table class="table table-bordered m-a-0">
                        <thead class="dker">
                        <tr>
                            <th class="width20 dker">
                                <label class="ui-check m-a-0">
                                    <input id="checkAll" type="checkbox"><i></i>
                                </label>
                            </th>
                            <th>{{ __('Title') }}</th>
                            <th class="text-center width200">{{ __('Banner') }}</th>
                            <th class="text-center width50">{{ __('backend.status') }}</th>
                            <th class="text-center" style="width:150px;">{{ __('backend.options') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="dker"><label class="ui-check m-a-0">
                                        <input type="checkbox" name="ids[]" value=""><i
                                            class="dark-white"></i>
                                        -
                                    </label>
                                </td>
                                <td class="h6">-</td>
                                <td class="text-center">
                                   -
                                </td>
                                <td class="text-center">
                                    <i class="fa fa-check inline"></i>
                                </td>
                                <td class="text-center">
                                        <a class="btn btn-sm success"
                                           href="" data-toggle="tooltip"
                                           data-original-title="{{ __('backend.edit') }}">
                                            <i class="material-icons">&#xe3c9;</i>
                                        </a>
                                        <button type="button" class="btn btn-sm warning"
                                                onclick="DeleteBanner" data-toggle="tooltip"
                                                data-original-title="{{ __('backend.delete') }}">
                                            <i class="material-icons">&#xe872;</i>
                                        </button>

                                </td>
                            </tr>
                        </tbody>
                    </table>

                </div>
                <footer class="dker p-a">
                    <div class="row">
                        <div class="col-sm-3 hidden-xs">
                            <!-- .modal -->
                            <div id="m-all" class="modal fade" data-backdrop="true">
                                <div class="modal-dialog" id="animate">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">{{ __('backend.confirmation') }}</h5>
                                        </div>
                                        <div class="modal-body text-center p-lg">
                                            <p>
                                                {{ __('backend.confirmationDeleteMsg') }}
                                            </p>
                                        </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn dark-white p-x-md"
                                                    data-dismiss="modal">{{ __('backend.no') }}</button>
                                            <button type="submit"
                                                    class="btn danger p-x-md">{{ __('backend.yes') }}</button>
                                        </div>
                                    </div><!-- /.modal-content -->
                                </div>
                            </div>
                            <!-- / .modal -->
                        </div>

                        <div class="col-sm-6 text-right text-center-xs">
                            
                        </div>
                    </div>
                </footer>
        </div>
    </div>

    <!-- .modal -->
    <div id="DeleteBanner" class="modal fade" data-backdrop="true">
        <div class="modal-dialog" id="animate">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">{{ __('backend.confirmation') }}</h5>
                </div>
                <div class="modal-body text-center p-lg">
                    <p>
                        {{ __('backend.confirmationDeleteMsg') }}
                        <br>
                        <strong>--</strong>
                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark-white p-x-md"
                            data-dismiss="modal">{{ __('backend.no') }}</button>
                    <a id="DeleteBannerBtn" href=""
                       class="btn danger p-x-md">{{ __('backend.yes') }}</a>
                </div>
            </div><!-- /.modal-content -->
        </div>
    </div>
    <!-- / .modal -->
@endsection
@push("after-scripts")
    <script type="text/javascript">
        $("#checkAll").click(function () {
            $('input:checkbox').not(this).prop('checked', this.checked);
        });
        $("#action").change(function () {
            if (this.value == "delete") {
                $("#submit_all").css("display", "none");
                $("#submit_show_msg").css("display", "inline-block");
            } else {
                $("#submit_all").css("display", "inline-block");
                $("#submit_show_msg").css("display", "none");
            }
        });

        function DeleteBanner(id) {
            $("#DeleteBanner").modal("show");
            $("#DeleteBannerBtn").attr("href", "/" + id);
        }
    </script>
@endpush
