<?php 
$success = $this->session->flashdata('success');
if($success){?> 

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-info">
                <?php 
                    echo $success;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>

<?php

}
?>
<?php 
$failed = $this->session->flashdata('failed');
if($failed){?>

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-warning">
                <?php 
                    echo $failed;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>
 
<?php

}
 
?>
<div class="col-md-12">
    <div class="box box-primary">
        <div class="box-header">
            <h3 class="box-title">Add Patient Invoice</h3>
        </div><!-- /.box-header -->
    </div>
</div>

<form action="<?php echo base_url();?>patients/invoice_create" method="post" enctype="multipart/form-data">
<div class="col-md-6">
    <!-- general form elements -->
    <div class="box-body">
         <div class="form-group">
            <label for="exampleInputPassword1">Invoice ID <sup>*</sup></label>
            <input name="invoice_id" type="text" class="form-control" id="" placeholder="Invoice ID" required="" readonly="" value="<?php echo $idnumber ?> ">
        </div>
        
        
        <div class="form-group">
            <label for="exampleInputPassword1">Select Patient <sup>*</sup></label>
            <select name="patient_id" class="form-control selectpicker" required="" id="patient_id"  data-live-search="true">
                <option value="">Select Doctor</option>
                <?php foreach ($patients as $key => $patient) { ?>
                    <option value="<?php echo $patient->id ?>" >PID<?php echo $patient->idnumber ?> (<?php echo $patient->name ?>) </option>
                <?php } ?>
            </select>
            <p id="drname"></p>
            <p id="specialist"></p> 
            <input name="doctor_id" id="doctor_id" type="hidden" >
        </div>

    </div><!-- /.box-body -->
</div>

<div class="col-md-6">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Invoice Date</label>
            <input name="invoice_date" type="date" class="form-control" value="<?php echo date('m/d/Y') ?>" >
        </div>
        
        
        <div class="form-group">
            <label for="exampleInputPassword1">Fee/Test <sup>*</sup></label>
            <select name="type" class="form-control" required="" id="type">
                <option value="">Select One</option>
                <option value="fee">Fee</option>
                <option value="test">Test</option>
            </select>
        </div>
        
        
    </div><!-- /.box-body -->
 
</div>

<div class="col-md-6" id="feeamount">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Dr. Fee Amount</label>
            <input name="amount" type="text" class="form-control" id="amount" placeholder="500" >
        </div>
    </div>
</div>

<div class="col-md-6" id="testamount">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Test</label>
            <select class="form-control selectpicker" name="test_id[]" multiple data-dropup-auto="false" data-size="10"
                <option value="">Select Test</option>
                <?php foreach ($test as $key => $value) { ?>
                    <option value="<?php echo $value->id ?>"><?php echo $value->testName ?> (<?php echo $value->fee ?>) </option>
                <?php } ?>
            </select>
        </div>
    </div>
</div>

<div class="col-md-12" >
     
        <button type="submit" class="btn btn-primary" >Create Invoice</button>
     
</div>

</form>

<script>
$(function() {
    $('#feeamount').hide(); 
    $('#type').change(function(){
        if($('#type').val() == 'fee') {
            $('#feeamount').show(); 
        } else {
            $('#feeamount').hide(); 
        } 
    });
    
    $('#testamount').hide(); 
    $('#type').change(function(){
        if($('#type').val() == 'test') {
            $('#testamount').show(); 
        } else {
            $('#testamount').hide(); 
        } 
    });
});

     
    $('#patient_id').change(function(){
        var patient_id = $(this).val();
         //alert(patient_id);
    
       $.get( "<?php echo site_url('patients/ajaxpatients')?>/"+patient_id, function( data ) {
           var obj = JSON.parse(data);
          $( "#drname" ).html( obj.drname ); 
          $( "#specialist" ).html( obj.specialist );  
          $( "#doctor_id" ).val( obj.doctor_id ); 
          //console.log(data);
        });
    });
</script>

