<?php 
$success = $this->session->flashdata('success');
if($success){?> 

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-info">
                <?php 
                    echo $success;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>

<?php

}
?>
<?php 
$failed = $this->session->flashdata('failed');
if($failed){?>

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-warning">
                <?php 
                    echo $failed;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>
 
<?php

}
 
?>
<div class="col-md-12">
    <div class="box box-primary">
        <div class="box-header">
            <h3 class="box-title">Edit Medicines Sales</h3>
        </div><!-- /.box-header -->
    </div>
</div>

<form action="<?php echo base_url();?>medicines/sales_edit" method="post" enctype="multipart/form-data">

<div class="col-md-4">
    <!-- general form elements -->
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Select Patient <sup>*</sup></label>
            <select name="patient_id" class="form-control selectpicker" required="" data-live-search="true">
                <option value="">Select Patient</option>
                <?php foreach ($patients as $key => $patient) { ?>
                    <option value="<?php echo $patient->id ?>" <?php echo (($patient->id==$invoice->patient_id)?'selected="selected"':"") ?>><?php echo $patient->idnumber ?> (<?php echo $patient->name ?>) </option>
                <?php } ?>
            </select>
             
        </div>

    </div><!-- /.box-body -->
</div>
<div class="col-md-4">
    <div class="form-group">
        <label for="exampleInputPassword1">Invoice ID <sup>*</sup></label>
        <input name="invoice_id" type="text" class="form-control" id="" placeholder="Invoice ID" required="" readonly="" value="<?php echo $invoice->invoice_id ?> ">
        <input name="id" type="hidden" value="<?php echo $invoice->id ?> ">
    </div>
</div>
<div class="col-md-4">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Invoice Date</label>
            <input name="invoice_date" type="text" class="form-control date" value="<?php echo date_formate_set($invoice->invoice_date) ?>" >
        </div>
    </div><!-- /.box-body -->
</div>

 

<div class="col-md-4">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Medicines</label>
            <select class="form-control selectpicker" id="medicines_id" data-live-search="true" data-size="10">
                <option value="">Select Medicine</option>
                <?php foreach ($medicines as $key => $value) { ?>
                    <option value="<?php echo $value->id ?>" data-name="<?php echo $value->name ?>" data-price="<?php echo $value->price ?>"><?php echo $value->name ?></option>
                <?php } ?>
            </select>
        </div>
    </div>
</div>

<div class="col-md-8">
    <div class="box-body">
        <table class="table">
            <thead>
                <tr>
                    <th>Medicine Name</th>
                    <th>Quantity</th>
                    <th>Price</th>
                    <th>Total</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody id="tableDynamic">
                <?php foreach ($items as $key => $item) {
                    $i = $key+1; ?>
                <tr>
                    <td>
                        <input type="text" class="form-control" value="<?php echo $item->name ?>" readonly>
                        <input name="medicine_id[]" type="hidden" value="<?php echo $item->medicine_id ?>">
                    </td> 
                    <td> 
                        <input name="quantity[]" id="quantity_<?php echo $i ?>" type="text" class="form-control quant" value="<?php echo $item->quantity ?>">
                    </td>
                    <td>
                        <input name="price[]"  type="text" class="form-control" value="<?php echo $item->price ?>" id="unitprice_<?php echo $i ?>" readonly > 
                    </td>
                    <td>
                        <input name="total[]" id="totalprice_<?php echo $i ?>"  type="text" class="form-control totalprice" value="<?php echo $item->total_price ?>">
                    </td>
                    <td>
                        <a href="javascript:void(0);" id="deleteRow_<?php echo $i ?>"  class="deleteRow btn btn-danger btn-flat btn-sm">Delete</a>
                    </td>
                </tr>
                <?php } ?>

            </tbody>
            <tfoot>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Subtotal</strong></td>
                    <td colspan="2"> 
                        <input type="text" name="subtotal" id="subtotal" class="form-control" readonly="" value="<?php echo $invoice->sub_total ?>">
                    </td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Discount</strong></td>
                    <td colspan="2"><input type="text" name="discount" id="discount" class="form-control" value="<?php echo $invoice->discount ?>"></td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Net Total</strong></td>
                    <td colspan="2"><input type="text" name="net_total" id="net_total" class="form-control" readonly="" value="<?php echo $invoice->net_total ?>"></td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Paid</strong></td>
                    <td colspan="2"><input type="text" name="paidamount" id="paidamount" class="form-control" value="<?php echo $invoice->paid_amount ?>"></td>
                </tr>
                <tr>
                    <td colspan="4" style="text-align: right;"><strong>Due Balance</strong></td>
                    <td colspan="2"><input type="text" name="dueamount" id="dueamount" class="form-control" readonly="" value="<?php echo $invoice->due_amount ?>"></td>
                </tr>
            </tfoot>
        </table>
         
    </div>
</div>


<div class="col-md-12" >
     
    <button type="submit" class="btn btn-primary" >Create Invoice</button>
     
</div>

</form>

<script>
    var scntDiv = $('#tableDynamic');
    var i = $('#tableDynamic tr').size() + 1;
   
    $('#medicines_id').change(function() {
        var medicine_id = $('#medicines_id').val();
        var medicine_name = $("#medicines_id option:selected").attr('data-name');
        var medicine_price = $("#medicines_id option:selected").attr('data-price'); 
         
        $('<tr><td><input type="text" class="form-control" value="'+medicine_name+'" readonly><input name="medicine_id[]" type="hidden" value="'+medicine_id+'"></td> <td> <input name="quantity[]" id="quantity_'+i+'" type="text" class="form-control quant" value="1"></td><td><input name="price[]"  type="text" class="form-control" value="'+medicine_price+'" id="unitprice_'+i+'" readonly > </td><td><input name="total[]" id="totalprice_'+i+'"  type="text" class="form-control totalprice" value="'+medicine_price+'"></td><td><a href="javascript:void(0);" id="deleteRow_'+i+'"  class="deleteRow btn btn-danger btn-flat btn-sm">Delete</a></td></tr>').appendTo(scntDiv);
        i++;
        totalcalculate();
        return false;
    });

    $(document).on("click", ".deleteRow", function (e) {
        if($('#tableDynamic tr').size()>1){
            var target = e.target;

            var id_arr = $(this).attr('id');
            var id = id_arr.split("_");
            var element_id = id[id.length-1];
            //console.log(element_id);

            var totalprice =parseFloat( $("#totalprice_"+element_id).val());
            var subtotal = parseFloat($("#subtotal").val());
            var net_total = parseFloat($("#net_total").val());
            var dueamount = parseFloat($("#dueamount").val());

            if (!isNaN(totalprice)) {
            

            $("#subtotal").val(subtotal-totalprice);
            //$("#grandtotal").val(net_total-totalprice);
            $("#net_total").val(net_total-totalprice);
            $("#dueamount").val(dueamount-totalprice);
 

            }
            
            $(target).closest('tr').remove();
        

        }else{
            //alert('One row should be present in table');
        }
    });


    $(document).on("keyup", "#discount", function(event){
        var discount = $(this).val();
 
        var subtotal = parseFloat($("#subtotal").val());
        var net_total = parseFloat($("#net_total").val());
        var dueamount = parseFloat($("#dueamount").val());
        var paidamount = parseFloat($("#paidamount").val());
 
        $("#net_total").append().val(subtotal - discount);
        $("#dueamount").append().val((subtotal - discount)-paidamount);
    });

    $(document).on("keyup", "#paidamount", function(event){
        var paidamount = $(this).val();
        var net_total = $("#net_total").val();
        var dueamount = $("#dueamount").val();

        $("#dueamount").append().val(net_total - paidamount);
    });

    $(document).on("keyup", ".quant", function(){
        var quant = parseInt($(this).val());
        var id_arr = $(this).attr('id');
        var id = id_arr.split("_");
        var element_id = id[id.length-1];
        //console.log(element_id);
        
        var totalprice = $("#totalprice_"+element_id).val();
        
        $("#totalprice_"+element_id).prop('value','');
        $("#totalprice_"+element_id).attr({placeholder: 'Total Price...'});


        var total = $("#unitprice_"+element_id).val() * $("#quantity_"+element_id).val();

        $("#totalprice_"+element_id).val(total);

        totalcalculate();
                    
    });


    function totalcalculate() {
        $("#tableDynamic tr").each(function() {
            row_total = 0; 
            $("td .totalprice").each(function() {
               row_total += Number($(this).val());
            }); 
            $("#subtotal").append().val(row_total);
            var discount = $("#discount").val();
            $("#net_total").append().val(row_total-discount);
            var paid = $("#paidamount").val();
            var dueamount = (row_total-discount)-paid;
            $("#dueamount").append().val(dueamount);
            
        });
    }

</script>

