<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Waitingsticker extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
	}
	 
	public function add()
	{
		$data = array();
		if($_POST){
		    $data['passenger_id']=  $this->input->post('passenger_id',true);
		    $data['agent_id']=  $this->input->post('agent_id',true);
        	$data['country']=  $this->input->post('country',true);
        	$data['date']=  date_formate_set_db($this->input->post('date',true));
        	$data['training']=  $this->input->post('training',true);
        	$data['medical']=  $this->input->post('medical',true);
        	$data['visa']=  $this->input->post('visa',true);
        	$data['flight']=  $this->input->post('flight',true);
		     
			$this->db->insert('waitingsticker', $data);
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('waitingsticker/add');
		}else{
		    $data['agents'] = $this->db->get('agents')->result();
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	
	public function viewlist()
	{
	    if($_POST){
	        $agent_id=  $this->input->post('agent_id',true); 
		    $agents = $this->db->get_where('agents',['id'=>$agent_id])->row();
		    
		    $data['agentsname'] = $agents->name;
    		$data['waitingsticker'] = $this->db->select('w.*, p.name, p.passport')
    		->join('passenger p', 'p.id=w.passenger_id', 'left')
    		->where('p.agent_id', $agent_id)
    		->get('waitingsticker w')->result();
    		
    		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
    		$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/print', $data, TRUE);
    		$this->load->view('dashboard/master_dashboard_panel',$data);
		
		
	    }else{
		$data = array();
		$data['waitingsticker'] = $this->db->select('w.*, p.name, p.passport')
			->join('passenger p', 'p.id=w.passenger_id', 'left')
			->get('waitingsticker w')->result();
        $data['agents'] = $this->db->get('agents')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/list', $data, TRUE);
		
		$this->load->view('dashboard/master_dashboard_panel',$data);
	    }
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$data['agent_id']=  $this->input->post('agent_id',true);
		    $data['passenger_id']=  $this->input->post('passenger_id',true);
        	$data['country']=  $this->input->post('country',true);
        	$data['date']=  date_formate_set_db($this->input->post('date',true));
        	$data['training']=  $this->input->post('training',true);
        	$data['medical']=  $this->input->post('medical',true);
        	$data['visa']=  $this->input->post('visa',true);
        	$data['flight']=  $this->input->post('flight',true);

  			
			$this->db->update('waitingsticker', $data, ['id'=>$id]);
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('waitingsticker/viewlist');
		}else{
		    $data['agents'] = $this->db->get('agents')->result();
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['sticker'] = $this->db->get_where('waitingsticker',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function view($id='')
	{ 
		$data['sticker'] = $this->db->select('w.*, p.name, p.passport')
			->join('passenger p', 'p.id=w.passenger_id', 'left')
			->where('w.id', $id)
			->get('waitingsticker w')->row();
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
		$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/view', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
		 
	}

	public function delete($id='')
	{
		 
		$this->db->delete('waitingsticker', ['id'=>$id]);
		$success = 'Deleted  Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('waitingsticker/viewlist');
	}


	public function prints($value='')
	{
		 
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
		$data['waitingsticker'] = $this->db->select('w.*, p.name, p.passport')
		->join('passenger p', 'p.id=w.passenger_id', 'left')
		->get('waitingsticker w')->result();
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
		$data['dashboardContent'] = $this->load->view('dashboard/waitingsticker/print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
		 
	}

}