<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Suppliercontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('suppliermodel','SUPPLIERMODEL',TRUE);
		
                $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }
		/*
		echo "<pre>";
		print_r($data);
		exit();
		*/
	}

	

	public function addsupplier()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/supplier/addsupplier', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertsupplier()
	{
		$data = array();
		$data['supplier_name'] = $this->input->post('supplier_name');
		$data['other_supplier_details'] = $this->input->post('other_supplier_details');
		$data['supplier_phone'] = $this->input->post('supplier_phone');
		$data['supplier_email'] = $this->input->post('supplier_email');
		$data['supplier_cell_phone'] = $this->input->post('supplier_cell_phone');

		if(empty($data['supplier_name'])){
			$failed = "Please enter Suplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('suppliercontroller/addsupplier');
		}

		$duplicate = $this->SUPPLIERMODEL->duplicateSupplierChecker($data['supplier_name']);

		if($duplicate){
			$failed = "Please enter Unique Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('suppliercontroller/addsupplier');
		}else{
			$result = $this->SUPPLIERMODEL->insertSupplierInfo($data);
		}

		$supplier_name = $this->input->post('supplier_name');
		$other_supplier_details = $this->input->post('other_supplier_details');
		$supplier_phone = $this->input->post('supplier_phone');
		$supplier_email = $this->input->post('supplier_email');
		$supplier_cell_phone = $this->input->post('supplier_cell_phone');
		
		if ($result) {
			$success = "
				Data successfully inserted!<br>
				Supplier Name : $supplier_name<br>
				Address: $other_supplier_details<br>
				Phone Number: $supplier_phone<br>
				Email Address: $supplier_email<br>
				Mobile Number: $supplier_cell_phone<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('suppliercontroller/addsupplier');
		}
	}

	public function viewsupplier()
	{
		$data = array();
		$data['viewsupplierlist'] = $this->SUPPLIERMODEL->viewsupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/supplier/viewsupplierlist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deletesupplier($id)
	{
		$this->SUPPLIERMODEL->deletesupplier($id);
		$success = 'Deleted Suplier Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('suppliercontroller/viewsupplier');
	}

	public function updatesupplier($id)
	{
		$data = array();
		$data['querysupplier'] = $this->SUPPLIERMODEL->querysupplier($id);
		$data['dashboardContent'] = $this->load->view('dashboard/supplier/editsupplier', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function changesupplierinfo()
	{
		$data = array();
		$id = $this->input->post('supplier_id');
		$data['supplier_name'] = $this->input->post('supplier_name');
		$data['other_supplier_details'] = $this->input->post('other_supplier_details');
		$data['supplier_phone'] = $this->input->post('supplier_phone');
		$data['supplier_email'] = $this->input->post('supplier_email');
		$data['supplier_cell_phone'] = $this->input->post('supplier_cell_phone');

		if(empty($data['supplier_name'])){
			$failed = "Please enter Suplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect("suppliercontroller/updatesupplier/$id");
		}

		$duplicate = $this->SUPPLIERMODEL->duplicateSupplierChecker($data['supplier_name']);

		if($duplicate){
			$failed = "Please enter Unique Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect("suppliercontroller/updatesupplier/$id");
		}else{
			$result = $this->SUPPLIERMODEL->changesupplierinfo($id, $data);
		}

		//$result = $this->SUPPLIERMODEL->changesupplierinfo($id, $data);
		
		$supplier_name = $this->input->post('supplier_name');
		$other_supplier_details = $this->input->post('other_supplier_details');
		$supplier_phone = $this->input->post('supplier_phone');
		$supplier_email = $this->input->post('supplier_email');
		$supplier_cell_phone = $this->input->post('supplier_cell_phone');
		
		if ($result) {
			$success = "
				Data successfully updated!<br>
				Supplier Name : $supplier_name<br>
				Address: $other_supplier_details<br>
				Phone Number: $supplier_phone<br>
				Email Address: $supplier_email<br>
				Mobile Number: $supplier_cell_phone<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("suppliercontroller/updatesupplier/$id");
		}
	}

}