<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Reportcontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
		
               $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }
		/*
		echo "<pre>";
		print_r($data);
		exit();
		*/
	}

	public function salesreportform()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/report/salesreportform', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function querysalesreportbydaterange()
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/salesreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$data['totalexpanse'] = $this->expense($first_date,$last_date);
		$data['querysalesreportbydaterange'] = $this->REPORTMODEL->querysalesreportbydaterange($first_date,$last_date);

		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['querycurrencytag'] = $this->REPORTMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printsalesreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
		
	}

	public function expense($first_date,$last_date)
	{
		return $this->db->select('SUM(amount) as totalamount')
		->from('dailyexpanse')
		->where('date >=',$first_date)
		->where('date <=',$last_date)
		->get()->row('totalamount');
	}




	public function duecollectionreportform()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/report/duecollectionreportform', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function queryduecollectionreportbydaterange()
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/duecollectionreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$data['querysumofduecollectionreportbydaterange'] = $this->REPORTMODEL->querysumofduecollectionreportbydaterange($first_date,$last_date);
		$data['querysumofsalesreportbydaterange'] = $this->REPORTMODEL->querysumofsalesreportbydaterange($first_date,$last_date);
		
		
		
		$data['queryduecollectionreportbydaterange'] = $this->REPORTMODEL->queryduecollectionreportbydaterange($first_date,$last_date);
		$data['querynewcollectionreportbydaterange'] = $this->REPORTMODEL->querysalesreportbydaterangebyinvoicedate($first_date,$last_date);

		/*
		echo "<pre>";
		print_r($data['queryduecollectionreportbydaterange']);
		exit();
		*/
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['querycurrencytag'] = $this->REPORTMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printduecollectionreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}




	public function inventoryreportform()
	{
		$data = array();
		$data['queryitemlist'] = $this->REPORTMODEL->queryitemlist();
		$data['dashboardContent'] = $this->load->view('dashboard/report/inventoryreportform', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function inventorymasterreport()
	{
		$data = array();

		$iteminfo = $this->REPORTMODEL->queryitemlistwithsupplier();
		
		$countiteminfo = count($iteminfo);
		$queryinventoryreportbydaterange = array();
		for ($i=0; $i <$countiteminfo ; $i++) { 
			
			$queryinventoryreportbydaterange[$i] = $this->REPORTMODEL->queryinventorymasterreport($iteminfo[$i]['item_id']);
		}
		

		
		$data['queryinventoryreportbydaterange'] = $queryinventoryreportbydaterange;
		
		/*echo "<pre>";
		print_r($data['queryinventoryreportbydaterange']);
		exit();*/

		$data['dashboardContent'] = $this->load->view('dashboard/report/viewinventorymasterreport', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function printinventorymasterreport()
	{
		$data = array();

		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$iteminfo = $this->REPORTMODEL->queryitemlistwithsupplier();
		
		$countiteminfo = count($iteminfo);
		$queryinventoryreportbydaterange = array();
		for ($i=0; $i <$countiteminfo ; $i++) { 
			
			$queryinventoryreportbydaterange[$i] = $this->REPORTMODEL->queryinventorymasterreport($iteminfo[$i]['item_id']);
		}
		

		
		$data['queryinventoryreportbydaterange'] = $queryinventoryreportbydaterange;
		
		/*echo "<pre>";
		print_r($data['queryinventoryreportbydaterange']);
		exit();*/
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printinventorymasterreport', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function printinventorymasterreportbyid()
	{
		$data = array();

		$dt = new DateTime();
		$data['current_date'] = $dt->format('Y/m/d');

		$item_id = $this->input->post('item_id');
		
		$data['queryitemlistwithsupplierbyid'] = $this->REPORTMODEL->queryitemlistwithsupplierbyid($item_id);

		$data['querysupplieditembyid'] = $this->REPORTMODEL->querymastersupplieditembyid($item_id);

		$data['querysolditembyid'] = $this->REPORTMODEL->querymastersolditembyid($item_id);

		/*echo "<pre>";
		print_r($data['querysolditembyid']);
		exit();*/
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printinventorymasterreportbyid', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function queryinventoryreportbydaterange()
	{
		$data = array();

		$date_range = $this->input->post('date_range');

		$data['date_range'] = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/inventoryreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$iteminfo = $this->REPORTMODEL->queryitemlistwithsupplier();
		
		$countiteminfo = count($iteminfo);
		$queryinventoryreportbydaterange = array();
		for ($i=0; $i <$countiteminfo ; $i++) { 
			
			$queryinventoryreportbydaterange[$i] = $this->REPORTMODEL->queryinventoryreportbydaterange($first_date,$last_date,$iteminfo[$i]['item_id']);
		}
		

		
		$data['queryinventoryreportbydaterange'] = $queryinventoryreportbydaterange;
		
		/*echo "<pre>";
		print_r($data['queryinventoryreportbydaterange']);
		exit();*/

		$data['dashboardContent'] = $this->load->view('dashboard/report/viewinventoryreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}


	public function printinventoryreportbydate()
	{
		$data = array();

		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');

		$data['date_range'] = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/inventoryreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$iteminfo = $this->REPORTMODEL->queryitemlistwithsupplier();
		
		$countiteminfo = count($iteminfo);
		$queryinventoryreportbydaterange = array();
		for ($i=0; $i <$countiteminfo ; $i++) { 
			
			$queryinventoryreportbydaterange[$i] = $this->REPORTMODEL->queryinventoryreportbydaterange($first_date,$last_date,$iteminfo[$i]['item_id']);
		}
		

		
		$data['queryinventoryreportbydaterange'] = $queryinventoryreportbydaterange;
	
		/*echo "<pre>";
		print_r($data['queryinventoryreportbydaterange']);
		exit();*/
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printinventoryreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function printinventoryreportbyid()
	{
		$data = array();

		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');
		$item_id = $this->input->post('item_id');

		$data['date_range'] = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/inventoryreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$data['queryitemlistwithsupplierbyid'] = $this->REPORTMODEL->queryitemlistwithsupplierbyid($item_id);

		$data['querysupplieditembyid'] = $this->REPORTMODEL->querysupplieditembyid($first_date,$last_date,$item_id);

		$data['querysolditembyid'] = $this->REPORTMODEL->querysolditembyid($first_date,$last_date,$item_id);

		/*echo "<pre>";
		print_r($data['querysolditembyid']);
		exit();*/
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printinventoryreportbyid', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}


	public function profitlossreportform()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/report/profitlossreportform', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function queryprofitlossreportbydaterange()
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/profitlossreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];

		$data['queryitemreport'] = $this->REPORTMODEL->queryitemreport();

		$countitem = count($data['queryitemreport']);

		$sdata = array();
		for ($i=0; $i <$countitem ; $i++) { 
			$sdata[$i] = $this->REPORTMODEL->queryprofitreportbydaterange($first_date,$last_date,$data['queryitemreport'][$i]->item_name);
		}
		
		$data['queryprofitreportbydaterange'] = $sdata;
		

		$lodata = array();
		for ($i=0; $i <$countitem ; $i++) { 
			$lodata[$i] = $this->REPORTMODEL->querylossreportbydaterange($first_date,$last_date,$data['queryitemreport'][$i]->item_name);
		}
		
		$data['querylossreportbydaterange'] = $lodata;

		/*echo "<pre>";
		print_r($data['queryprofitreportbydaterange']);
		exit();*/
		

		$data['querysumofduereportbydaterange'] = $this->REPORTMODEL->querysumofduereportbydaterange($first_date,$last_date);
		
		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['querycurrencytag'] = $this->REPORTMODEL->querycurrencytag();


		$data['dashboardContent'] = $this->load->view('dashboard/report/printprofitlossreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function vatreportform()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/report/vatreportform', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function queryvatreportbydaterange()
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y/m/d');

		$date_range = $this->input->post('date_range');

		if(empty($date_range)){
			$failed = "Please enter Date Range";
			$this->session->set_flashdata('failed', $failed);
			redirect('reportcontroller/vatreportform');
		}
		$dateexplode = explode("-",$date_range);

		$first_date = $dateexplode[0];
		$last_date = $dateexplode[1];

		$data['first_date'] = $dateexplode[0];
		$data['last_date'] = $dateexplode[1];
		
		$data['querysalesreportbydaterange'] = $this->REPORTMODEL->querysalesreportbydaterange($first_date,$last_date);

		$data['storeInfo'] = $this->REPORTMODEL->storeInfo();

		$data['querycurrencytag'] = $this->REPORTMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/report/printvatreportbydaterange', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
}