<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Medicines extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('itemmodel','ITEMMODEL',TRUE);
		
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        }
		
	}

	

	public function add()
	{
		$data = array();
		//$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/medicines/add', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertitem()
	{
		$data = array();
		$data['name'] = $this->input->post('name');
		$data['supplier'] = $this->input->post('supplier');
		$data['category'] = $this->input->post('category');
		$data['price'] = $this->input->post('price');

		if(empty($data['name']) || empty($data['supplier'])){
			$failed = "Please enter both  Name and Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('medicines/add');
		}

		$duplicate = $this->ITEMMODEL->duplicateItemChecker($data['name']);

		if($duplicate){
			$failed = "Please enter Unique Item Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('medicines/add');
		}else{
			$result = $this->ITEMMODEL->insertItemInfo($data);
		}
		
		if ($result) {
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('medicines/add');
		}
	}


	public function viewlist()
	{
		$data = array();
		$data['medicines'] = $this->ITEMMODEL->viewist();
		$data['dashboardContent'] = $this->load->view('dashboard/medicines/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$data['name'] = $this->input->post('name');
			$data['supplier'] = $this->input->post('supplier');
			$data['category'] = $this->input->post('category');
			$data['price'] = $this->input->post('price');
  			
			$this->db->update('medicines', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('medicines/viewlist');
		}else{
			$data['medicine'] = $this->db->get_where('medicines',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/medicines/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


	public function delete($id)
	{
		$this->ITEMMODEL->deleteitem($id);
		$success = 'Deleted Item Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('medicines/viewlist');
	}

	public function sales()
	{
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age');
		$this->db->from('invoice i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		$data['invoices'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/medicines/saleslist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);

	}

	public function sales_add($value='')
	{
		if($_POST){
			$serial = $this->db->select('invoice_id')->order_by('id','desc')->limit(1)->get('invoice')->row('invoice_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'M')+1;
	            $idnumber = "M".$idnumber;
	        }else{
	            $idnumber = "M10001"; 
	        }

			$data['invoice_id']=  $idnumber;
		    $data['invoice_date']=  date_formate_set_db($this->input->post('invoice_date'));
        	$data['patient_id']=  $this->input->post('patient_id',true);
        	$data['sub_total']=  $this->input->post('subtotal');
        	$data['discount']=  $this->input->post('discount');
        	$data['net_total']=  $this->input->post('net_total');
        	$data['paid_amount']=  $this->input->post('paidamount');
        	$data['due_amount']=  $this->input->post('net_total')-$this->input->post('paidamount');
        	$data['prepared_by']=  $this->session->userdata('fullname');
        	
			$this->db->insert('invoice', $data);
			$invoice_id = $this->db->insert_id();
			
			$medicine_id = $this->input->post('medicine_id');
			 
    		foreach ($medicine_id as $key => $id) { 
    		    $test['medicine_id']= $id;
    		    $test['invoice_id']= $invoice_id;
    		    $test['quantity']= $this->input->post('quantity')[$key];
    		    $test['price']= $this->input->post('price')[$key];
    		    $test['total_price']= $this->input->post('price')[$key]*$this->input->post('quantity')[$key];
    		    $test['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
    		    
    		    $this->db->insert('invoiced_item', $test);
    		     
    		}
      		redirect('medicines/sales_print/'.$invoice_id);
      		 
		}
		else{
			$serial = $this->db->select('invoice_id')->order_by('id','desc')->limit(1)->get('invoice')->row('invoice_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'M')+1;
	            $idnumber = "M".$idnumber;
	        }else{
	            $idnumber = "M10001"; 
	        }

			$data['invoiceid'] = $idnumber;
			$data['patients'] = $this->db->get('patients')->result();
			$data['medicines'] = $this->db->get('medicines')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/medicines/sales_add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function sales_edit($invoice_id='')
	{
		if($_POST){
			$invoice_id = $this->input->post('id');

		    $data['invoice_date']=  date_formate_set_db($this->input->post('invoice_date'));
        	$data['patient_id']=  $this->input->post('patient_id',true);
        	$data['sub_total']=  $this->input->post('subtotal');
        	$data['discount']=  $this->input->post('discount');
        	$data['net_total']=  $this->input->post('net_total');
        	$data['paid_amount']=  $this->input->post('paidamount');
        	$data['due_amount']=  $this->input->post('net_total')-$this->input->post('paidamount');
        	$data['prepared_by']=  $this->session->userdata('fullname');
        	
			$this->db->update('invoice', $data, ['id'=>$invoice_id]);
 
			$this->db->delete('invoiced_item', ['invoice_id'=>$invoice_id]);
			$medicine_id = $this->input->post('medicine_id');
    		foreach ($medicine_id as $key => $id) { 
    		    $test['medicine_id']= $id;
    		    $test['invoice_id']= $invoice_id;
    		    $test['quantity']= $this->input->post('quantity')[$key];
    		    $test['price']= $this->input->post('price')[$key];
    		    $test['total_price']= $this->input->post('price')[$key]*$this->input->post('quantity')[$key];
    		    $test['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
    		    
    		    $this->db->insert('invoiced_item', $test);
    		     
    		}
      		redirect('medicines/sales_print/'.$invoice_id);
      		 
		}
		else{

			$this->db->select('i.*, p.idnumber, p.name AS pname, p.age');
			$this->db->from('invoice i');
			$this->db->join('patients p', 'i.patient_id=p.id','left');
			$this->db->where('i.id', $invoice_id);
			$data['invoice'] = $this->db->get()->row();

			$this->db->select('m.name, i.*');
			$this->db->from('invoiced_item i');
			$this->db->join('medicines m', 'i.medicine_id=m.id','left');
			$this->db->where('i.invoice_id', $invoice_id);
			$data['items'] = $this->db->get()->result(); 

			
			$data['patients'] = $this->db->get('patients')->result();
			$data['medicines'] = $this->db->get('medicines')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/medicines/sales_edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function sales_print($invoice_id='')
	{
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age');
		$this->db->from('invoice i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		$this->db->where('i.id', $invoice_id);
		$data['invoice'] = $this->db->get()->row();

		$this->db->select('m.name, i.*');
		$this->db->from('invoiced_item i');
		$this->db->join('medicines m', 'i.medicine_id=m.id','left');
		$this->db->where('i.invoice_id', $invoice_id);
		$data['items'] = $this->db->get()->result();
		$data['app_config'] = $this->db->get_where('app_config', ['id'=>1])->row();
		$data['dashboardContent'] = $this->load->view('dashboard/medicines/sales_print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
}