<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Doctors extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
	}
	 
	public function add()
	{
		$data = array();
		if($_POST){
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/doctors/';
		    $config['allowed_types'] = 'gif|jpg|jpeg|png|GIF|JPG|JPEG|PNG';
		    $config['max_size'] = '10000';
		    $config['image_width']= '4000';
		    $config['image_height']= '4000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);


		    $data['name']=  $this->input->post('name',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['serialcontactNo']=  $this->input->post('serialcontactNo',true);
        	$data['educationDegree']=  $this->input->post('educationDegree',true);
        	$data['specialist']=  $this->input->post('specialist',true);
        	$data['visitingHours']=  $this->input->post('visitingHours',true);
        	$data['address']=  $this->input->post('address',true);
        	$data['hospitalName']=  $this->input->post('hospitalName',true);
        	$data['appointment_fee']=  $this->input->post('appointment_fee',true);
 			
 			$this->upload->do_upload('photo');
	        $images = $this->upload->data();
	        $data['photo'] = $images['file_name'];

	        $config['image_library'] = 'gd2';
	        $config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
	        $config['new_image'] = 'uploads/doctors/'.'thumbs_'.$this->upload->file_name;
	        $config['maintain_ratio'] = true;
	        //$config['width'] = 325;
	        $config['height'] = 100;
	        $this->load->library('image_lib', $config);
	        $this->image_lib->resize();


			$this->db->insert('doctors', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('doctors/add');
		}else{
			$data['dashboardContent'] = $this->load->view('dashboard/doctors/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	
	public function viewlist()
	{
		$data = array();
		 
		$data['doctors'] = $this->db->get('doctors')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/doctors/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/doctors/';
		    $config['allowed_types'] = 'gif|jpg|jpeg|png|GIF|JPG|JPEG|PNG';
		    $config['max_size'] = '10000';
		    $config['image_width']= '4000';
		    $config['image_height']= '4000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);


			$id = $this->input->post('id');
			$data['name']=  $this->input->post('name',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['serialcontactNo']=  $this->input->post('serialcontactNo',true);
        	$data['educationDegree']=  $this->input->post('educationDegree',true);
        	$data['specialist']=  $this->input->post('specialist',true);
        	$data['visitingHours']=  $this->input->post('visitingHours',true);
  			$data['address']=  $this->input->post('address',true);
        	$data['hospitalName']=  $this->input->post('hospitalName',true);
        	$data['appointment_fee']=  $this->input->post('appointment_fee',true);

        	$xx = $this->db->get_where("doctors", ['id'=>$id])->row();

		    $image= $this->upload->do_upload('photo');
	        if($image != ""){
	        	$images = $this->upload->data();
	        	if($xx->photo){
	            	unlink("./uploads/doctors/".$xx->photo);
	            	unlink("./uploads/doctors/thumbs_".$xx->photo);
	            }
	        	$data['photo'] = $images['file_name'];

		        $config['image_library'] = 'gd2';
		        $config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
		        $config['new_image'] = 'uploads/doctors/'.'thumbs_'.$this->upload->file_name;
		        $config['maintain_ratio'] = true;
		        //$config['width'] = 325;
		        $config['height'] = 100;
		        $this->load->library('image_lib', $config);
		        $this->image_lib->resize();
	        }


			$this->db->update('doctors', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('doctors/viewlist');
		}else{
			$data['doctor'] = $this->db->get_where('doctors',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/doctors/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delete($id='')
	{
		$xx = $this->db->get_where("doctors", ['id'=>$id])->row();
		if($xx->photo){
        	unlink("./uploads/doctors/".$xx->photo);
        	unlink("./uploads/doctors/thumbs_".$xx->photo);
        }

		$this->db->delete('doctors', ['id'=>$id]);
		$success = 'Deleted doctors Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('doctors/viewlist');
	}


	public function reports($value='')
	{
		$data = array();
		$data['passengers'] = '';
		$data['doctors_id'] = '';
		if($_POST){ 
		    $doctors_id=  $this->input->post('doctors_id',true); 
		    $doctors = $this->db->get_where('doctors',['id'=>$doctors_id])->row();
		    $array_set = array();
		    $genders = $this->db->select('gender')->group_by('gender')->get('passenger')->result_array();
		    foreach ($genders as $key => $gender) {
		    	 
		    
			    if(!empty($doctors_id)){
			    	$this->db->where('doctors_id', $doctors_id);
			    	$data['doctors_id'] = $doctors_id;
			    }
			    $this->db->where('gender', $gender['gender']);
				$passengers = $this->db->select('*')->get('passenger')->result_array();
				$set = array_merge($gender, array('list'=>$passengers));
				array_push($array_set, $set);
			}

			$data['passengers'] = $array_set;
			$data['doctors_name'] = $doctors->name;
			$data['doctors'] = $this->db->get('doctors')->result();
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['dashboardContent'] = $this->load->view('dashboard/doctors/reports', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}else{
			//$data['arrayx'] = $this->db->select('gender')->group_by('gender')->get('passenger')->result();
			
			//$data['arrayx'] = array('Male'=>'Male', 'Female'=>'Female');
            $data['doctors_name'] = '';
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['doctors'] = $this->db->get('doctors')->result(); 
			$data['dashboardContent'] = $this->load->view('dashboard/doctors/reports', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

}