<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Appointment_fee extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
        date_default_timezone_set('Asia/Dhaka');
	}
	public function index($value='')
	{
		$data = array();
		$this->db->select('a.*, a.id AS aid, d.name AS drname, d.specialist, p.*');
		$this->db->from('appointment_fee a');
		$this->db->join('doctors d', 'a.doctor_id=d.id','left');
		$this->db->join('patients p', 'a.patient_id=p.id','left');
		$data['appointment'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/appointment_fee/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	 
	public function add()
	{

		$data = array();
		if($_POST){
		 
	
			$appointment = $this->db->select('appointment_id')->order_by('id','desc')->limit(1)->get('appointment_fee')->row('appointment_id');
	        if($appointment !=""){
	            $appointment_id = trim($appointment, 'A')+1;
	            $appointment_id = "A".$appointment_id;
	        }else{
	            $appointment_id = "A10001"; 
	        }

			$fee = array(
				"doctor_id" =>$this->input->post('doctor_id'),
				"appointment_id" =>$appointment_id,
				"patient_id" =>$this->input->post('patient_id'),
				"appointment_fee" =>$this->input->post('appointment_fee'),
				"discount" =>$this->input->post('discount'),
				"appointment_date" =>date('Y-m-d', strtotime($this->input->post('appointment_date'))),
				"net_total" =>$this->input->post('appointment_fee')-$this->input->post('discount'),
				"prepared_by" =>$this->session->userdata('fullname'),
			);

			$this->db->insert('appointment_fee', $fee);
			$appoint_id = $this->db->insert_id();

			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('appointment_fee/print/'.$appoint_id);
		}else{
			
			$appointment = $this->db->select('appointment_id')->order_by('id','desc')->limit(1)->get('appointment_fee')->row('appointment_id');
	        if($appointment !=""){
	            $appointment_id = trim($appointment, 'A')+1;
	            $appointment_id = "A".$appointment_id;
	        }else{
	            $appointment_id = "A10001"; 
	        }

	        //echo $idnumber;
	        
			$data['appointment_id'] = $appointment_id;
			$data['doctors'] = $this->db->get('doctors')->result();
			$data['patients'] = $this->db->get('patients')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/appointment_fee/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


 

	public function doctors_fee($doctor_id='')
	{
		
		$this->db->select('appointment_fee');
		$this->db->from('doctors');
		$this->db->where('id', $doctor_id); 
		$doctor = $this->db->get()->row();
		 
		echo $doctor->appointment_fee;
	}

	 

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$patient_id = $this->input->post('patient_id');
			$doctor_id = $this->input->post('doctor_id');
			 
		    $fee = array(
				"doctor_id" =>$doctor_id,
				"appointment_id" =>$this->input->post('appointment_id'),
				"patient_id" =>$patient_id,
				"appointment_fee" =>$this->input->post('appointment_fee'),
				"discount" =>$this->input->post('discount'),
				"appointment_date" =>date('Y-m-d', strtotime($this->input->post('appointment_date'))),
				"net_total" =>$this->input->post('appointment_fee')-$this->input->post('discount'),
				"prepared_by" =>$this->session->userdata('fullname'),
			);
			$this->db->update('appointment_fee', $fee, ['id'=>$id]);

			$this->db->update('patients', ['doctor_id'=>$doctor_id], ['id'=>$patient_id]);


			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('appointment_fee');
		}else{
			$data['doctors'] = $this->db->get('doctors')->result();
			$data['patients'] = $this->db->get('patients')->result();
			$data['appointment'] = $this->db->get_where('appointment_fee',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/appointment_fee/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delete($id='')
	{
		  
		$this->db->delete('appointment_fee', ['id'=>$id]);
		$success = 'Deleted patients Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('appointment_fee');
	}

	//  documents
  
    
	public function print($id='')
	{
		 
		$this->db->select('a.*, d.name AS drname, d.educationDegree, d.specialist, p.*');
		$this->db->from('appointment_fee a');
		$this->db->join('doctors d', 'a.doctor_id=d.id','left');
		$this->db->join('patients p', 'a.patient_id=p.id','left');
		$this->db->where('a.id', $id);
		$data['appointment'] = $this->db->get()->row();

		$data['current_date'] = date('Y-m-d');
		$data['app_config'] = $this->db->get_where('app_config', ['id'=>1])->row();
		$data['dashboardContent'] = $this->load->view('dashboard/appointment_fee/print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
 
}