<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Test extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('itemmodel','ITEMMODEL',TRUE);
		
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        }
		
	}

	

	public function add()
	{
		$data = array();
		//$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/test/add', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertitem()
	{
		$data = array();
		$data['testName'] = $this->input->post('name');
		$data['fee'] = $this->input->post('fee');

		$result = $this->db->insert('test', $data);
		
		if ($result) {
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('test/add');
		}
	}


	public function viewlist()
	{
		$data = array();
		$data['test'] = $this->db->get('test')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/test/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$data['testName'] = $this->input->post('name');
			$data['fee'] = $this->input->post('fee');
  			
			$this->db->update('test', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('test/viewlist');
		}else{
			$data['test'] = $this->db->get_where('test',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/test/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


	public function deleteitem($id)
	{
		$this->db->delete('test',['id'=>$id]);
		$success = 'Deleted Item Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('test/viewlist');
	}

	// patient Test bill

	public function bill_list($value='')
	{
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age, p.gender, p.phone, p.address');
		$this->db->from('test_bill i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		//$this->db->where('i.id', $id);
		$data['invoices'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/test/billlist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function bill_add($value='')
	{
		 
		$data = array();
		if($_POST){
		     
			$serial = $this->db->select('bill_id')->order_by('id','desc')->limit(1)->get('test_bill')->row('bill_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'T')+1;
	            $idnumber = "T".$idnumber;
	        }else{
	            $idnumber = "T10001"; 
	        }
                 
		    $data['bill_id']=  $idnumber;
		    $data['bill_date']=  date_formate_set_db($this->input->post('bill_date'));
        	$data['patient_id']=  $this->input->post('patient_id',true);
        	$data['sub_total']=  $this->input->post('subtotal');
        	$data['discount']=  $this->input->post('discount');
        	$data['net_total']=  $this->input->post('net_total');
        	$data['paid_amount']=  $this->input->post('paidamount');
        	$data['due_amount']=  $this->input->post('net_total')-$this->input->post('paidamount');
        	$data['prepared_by']=  $this->session->userdata('fullname');
        	
			$this->db->insert('test_bill', $data);
			$insert_bill_id = $this->db->insert_id();
			
			$test_id = $this->input->post('test_id');
			 
    		foreach ($test_id as $key => $id) { 
    		    $test['test_id']= $id;
    		    $test['invoice_id']= $insert_bill_id;
    		    $test['quantity']= $this->input->post('quantity')[$key];
    		    $test['price']= $this->input->post('price')[$key];
    		    $test['total_price']= $this->input->post('price')[$key]*$this->input->post('quantity')[$key];
    		    $test['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
    		    
    		    $this->db->insert('test_bill_item', $test);
    		     
    		}
			
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('test/bill_print/'.$insert_bill_id);
		}else{
			
			$serial = $this->db->select('bill_id')->order_by('id','desc')->limit(1)->get('test_bill')->row('bill_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'T')+1;
	            $idnumber = "T".$idnumber;
	        }else{
	            $idnumber = "T10001"; 
	        }

			$data['bill_id'] = $idnumber;
			$data['patients'] = $this->db->get('patients')->result();
			$data['test'] = $this->db->get('test')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/test/bill_add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}
	public function bill_edit($invoice_id='')
	{
		 
		$data = array();
		if($_POST){

		    $invoice_id = $this->input->post('id');
			
		    $data['bill_date']=  date_formate_set_db($this->input->post('bill_date'));
        	$data['patient_id']=  $this->input->post('patient_id',true);
        	$data['sub_total']=  $this->input->post('subtotal');
        	$data['discount']=  $this->input->post('discount');
        	$data['net_total']=  $this->input->post('net_total');
        	$data['paid_amount']=  $this->input->post('paidamount');
        	$data['due_amount']=  $this->input->post('net_total')-$this->input->post('paidamount');
        	$data['prepared_by']=  $this->session->userdata('fullname');
        	
			$this->db->update('test_bill', $data, ['id'=>$invoice_id]);

			$this->db->delete('test_bill_item', ['invoice_id'=>$invoice_id]);
			$test_id = $this->input->post('test_id');
    		foreach ($test_id as $key => $id) { 
    		    $test['test_id']= $id;
    		    $test['invoice_id']= $invoice_id;
    		    $test['quantity']= $this->input->post('quantity')[$key];
    		    $test['price']= $this->input->post('price')[$key];
    		    $test['total_price']= $this->input->post('price')[$key]*$this->input->post('quantity')[$key];
    		    $test['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
    		    
    		    $this->db->insert('test_bill_item', $test);
    		     
    		}
			
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('test/bill_print/'.$invoice_id);
		}else{
			
			$this->db->select('i.*, p.idnumber, p.name AS pname, p.age');
			$this->db->from('test_bill i');
			$this->db->join('patients p', 'i.patient_id=p.id','left');
			$this->db->where('i.id', $invoice_id);
			$data['test_bill'] = $this->db->get()->row();

			$this->db->select('t.testName, i.*');
			$this->db->from('test_bill_item i');
			$this->db->join('test t', 'i.test_id=t.id','left');
			$this->db->where('i.invoice_id', $invoice_id);
			$data['items'] = $this->db->get()->result();


			$data['patients'] = $this->db->get('patients')->result();
			$data['test'] = $this->db->get('test')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/test/bill_edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}
	public function bill_print($invoice_id='')
	{
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age');
		$this->db->from('test_bill i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		$this->db->where('i.id', $invoice_id);
		$data['test_bill'] = $this->db->get()->row();

		$this->db->select('t.testName, i.*');
		$this->db->from('test_bill_item i');
		$this->db->join('test t', 'i.test_id=t.id','left');
		$this->db->where('i.invoice_id', $invoice_id);
		$data['items'] = $this->db->get()->result();

		$data['app_config'] = $this->db->get_where('app_config', ['id'=>1])->row();
		$data['dashboardContent'] = $this->load->view('dashboard/test/bill_print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function bill_delete($value='')
	{
		# code...
	}

	

	 
}