<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Investigation extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('itemmodel','ITEMMODEL',TRUE);
		
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        }
		
	}

	

	public function add()
	{
		if($_POST){
			$data = array();
			$data['name'] = $this->input->post('name'); 

			$result = $this->db->insert('investigation', $data);
			
			if ($result) {
				$this->session->set_flashdata('success', 'Data successfully inserted!');
				redirect('investigation/add');
			}
		}else{
			$data = array();
			//$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
			$data['dashboardContent'] = $this->load->view('dashboard/investigation/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
		
	}

	 


	public function viewlist()
	{
		$data = array();
		$data['alldata'] = $this->db->get('investigation')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/investigation/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$data['name'] = $this->input->post('name'); 
  			
			$this->db->update('investigation', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('investigation/viewlist');
		}else{
			$data['edit'] = $this->db->get_where('investigation',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/investigation/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


	public function deleteitem($id)
	{
		$this->db->delete('investigation',['id'=>$id]);
		$success = 'Deleted Item Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('investigation/viewlist');
	}

	 
}