<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Feeding extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('itemmodel','ITEMMODEL',TRUE);
		
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        }
		
	}

	

	public function add()
	{
		$data = array();
		//$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/feeding/add', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertitem()
	{
		$data = array();
		$data['name'] = $this->input->post('name');
		$data['count'] = $this->input->post('count');

		$result = $this->db->insert('feeding', $data);
		
		if ($result) {
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('feeding/add');
		}
	}


	public function viewlist()
	{
		$data = array();
		$data['feeding'] = $this->db->get('feeding')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/feeding/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$data['name'] = $this->input->post('name');
			$data['count'] = $this->input->post('count');
  			
			$this->db->update('feeding', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('feeding/viewlist');
		}else{
			$data['feeding'] = $this->db->get_where('feeding',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/feeding/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


	public function deleteitem($id)
	{
		$this->db->delete('feeding',['id'=>$id]);
		$success = 'Deleted Item Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('feeding/viewlist');
	}

	 
}