<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Dashboardcontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('dashboardmodel','DASHBOARDMODEL',TRUE);
		
		$id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }/**/
	}
	public function index()
	{
		
		$data = array();

		$data['totaldr'] = $this->db->get('doctors')->result();
		$this->db->like('create_date', date('Y-m-d'));
		$data['totalpatient'] = $this->db->get('patients')->result();
		
		$this->db->where('date', date('Y-m-d'));
		$data['totalprescription'] = $this->db->get('drprescription')->result();
		
		$this->db->where('invoice_date', date('Y-m-d'));
		$data['totalinvoice'] = $this->db->get('invoice')->result();
		

	 	//$dt = new DateTime();
		$today = date('Y/m/d');
		$year = date('Y');
		$month = date('m');

		$first_date = $year."/".$month."/"."01";
		$last_date = $year."/".$month."/"."31";
			 
		 
		$data['dashboardContent'] = $this->load->view('dashboard/frontpage', $data, TRUE);;
		$this->load->view('dashboard/master_dashboard_panel',$data);

	}
	
	public function adduser()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/adduser', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertuser()
	{
		$data = array();
		$data['fullname'] = $this->input->post('fullname');
		$data['name'] = $this->input->post('name');
		$data['password'] = $this->DASHBOARDMODEL->hash($this->input->post('password'));
		$data['status'] = $this->input->post('status');
		$data['role'] = $this->input->post('role');

		if(empty($data['name']) || empty($data['password']) || empty($data['status']) || empty($data['role'])){
			$failed = "Please enter Required Fields";
			$this->session->set_flashdata('failed', $failed);
			redirect('dashboardcontroller/adduser');
		}

		$duplicate = $this->DASHBOARDMODEL->duplicateUserChecker($data['name']);

		if($duplicate){
			$failed = "Please enter Unique Username";
			$this->session->set_flashdata('failed', $failed);
			redirect('dashboardcontroller/adduser');
		}else{
			$result = $this->DASHBOARDMODEL->insertUserInfo($data);
		}

		$fullname = $this->input->post('fullname');
		$name = $this->input->post('name');
		$password = $this->input->post('password');
		$status = $this->input->post('status');
		$role = $this->input->post('role');
		
		if ($result) {
			$success = "
				Data successfully inserted!<br>
				Fullname : $fullname<br>
				Username : $name<br>
				Password : $password<br>
				Status : $status<br>
				Role : $role<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('dashboardcontroller/adduser');
		}
	}
	
	public function viewuserlist()
	{
		$data = array();
		$data['viewuserlist'] = $this->DASHBOARDMODEL->viewuserlist();
		$data['dashboardContent'] = $this->load->view('dashboard/viewuserlist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	
	public function activateuser($id)
	{
		$info_data['status'] = "active";
		$result = $this->DASHBOARDMODEL->activateuser($id, $info_data);
		redirect("dashboardcontroller/viewuserlist");
	}
	
	public function inactivateuser($id)
	{
		$info_data['status'] = "inactive";
		$result = $this->DASHBOARDMODEL->inactivateuser($id, $info_data);
		redirect("dashboardcontroller/viewuserlist");
	}
	
	public function changepassword($id)
	{
		$data = array();
		$data['password'] = $this->input->post('new_password');
		$new_password = $this->input->post('new_password_again');
		if (empty($data['password']) || empty($new_password)) {
			$success = "Please enter Password Twice!!";
			$this->session->set_flashdata('success', $success);
			redirect("dashboardcontroller/viewuserlist");
		} else {
			if($data['password'] == $new_password)
			{
				$data['password'] = $this->DASHBOARDMODEL->hash($data['password']);
				$result = $this->DASHBOARDMODEL->changepassword($id, $data);
				$success = "Password changed successfully!";
				$this->session->set_flashdata('success', $success);
				redirect("dashboardcontroller/viewuserlist");
			}else{
				$failed = "Password does not match!";
				$this->session->set_flashdata('failed', $failed);
				redirect("dashboardcontroller/viewuserlist");
			}
		}
		
		
		
		
	}

	public function addstoreinfo()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/addstoreinfo', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertstoreinfo()
	{
		$data = array();
		$data['company_info'] = $this->input->post('company_info');

		$result = $this->DASHBOARDMODEL->insertstoreinfo($data);

		if ($result) {
			$success = "
				Data successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('dashboardcontroller/addstoreinfo');
		}

	}

	public function viewstoreinfo()
	{
		if($_POST){
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/logo/';
		    $config['allowed_types'] = 'gif|jpg|jpeg|png|GIF|JPG|JPEG|PNG';
		    $config['max_size'] = '10000';
		    $config['image_width']= '4000';
		    $config['image_height']= '4000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);


		    $data['companyName'] = $this->input->post('companyName');
		    $data['address'] = $this->input->post('address');
		    $data['phone'] = $this->input->post('phone');
		    $data['email'] = $this->input->post('email');
		    $data['telephone'] = $this->input->post('telephone');
		    $data['print'] = $this->input->post('print');
		     
		    
		    $xx = $this->db->get_where("app_config", ['id'=>1])->row();

		    $image= $this->upload->do_upload('logo');

		    if($image != ""){
	        	$images = $this->upload->data();
	        	if($xx->logo){
	            	unlink("./uploads/logo/".$xx->logo);
	            	unlink("./uploads/logo/thumbs_".$xx->logo);
	            }
	        	$data['logo'] = $images['file_name'];

		        $config['image_library'] = 'gd2';
		        $config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
		        $config['new_image'] = 'uploads/logo/'.'thumbs_'.$this->upload->file_name;
		        $config['maintain_ratio'] = true;
		        //$config['width'] = 150;
		        $config['height'] = 100;
		        $this->load->library('image_lib', $config);
		        $this->image_lib->resize();
	        }

            //print_r($data);
            //die();
		    $this->db->update('app_config', $data, ['id'=> 1]);

		    $this->session->set_flashdata('success', 'Data successfully Update!<br>');
			redirect('dashboardcontroller/viewstoreinfo');
		}
		else{
		    $data = array();
    		$data['store'] = $this->db->get_where('app_config', ['id'=>1])->row();
    		$data['dashboardContent'] = $this->load->view('dashboard/addstoreinfo', $data, TRUE);
    		$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function deletestoreinfo($id)
	{
		$this->DASHBOARDMODEL->deletestoreinfo($id);
		$success = 'Deleted Store Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('dashboardcontroller/viewstoreinfo');
	}

	public function addvatrate()
	{
		$data = array();
		$data['dashboardContent'] = $this->load->view('dashboard/addvatrate', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertvat()
	{
		$data = array();
		$data['vat_rate'] = $this->input->post('vat_rate');

		$result = $this->DASHBOARDMODEL->insertvat($data);

		if ($result) {
			$success = "
				Data successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('dashboardcontroller/addvatrate');
		}
	}

	public function viewvatinfo()
	{
		$data = array();
		$data['viewvatinfo'] = $this->DASHBOARDMODEL->viewvatinfo();
		$data['dashboardContent'] = $this->load->view('dashboard/viewvatinfo', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deletevatinfo($id)
	{
		$this->DASHBOARDMODEL->deletevatinfo($id);
		$success = 'Deleted Store Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('dashboardcontroller/viewvatinfo');
	}

	public function addcurrencyinfo()
	{
		$data = array();
		$data['querycurrencytag'] = $this->DASHBOARDMODEL->querycurrencytag();
		$data['dashboardContent'] = $this->load->view('dashboard/addcurrencyinfo', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertcurrencyinfo()
	{
		$data = array();
		$data['currency_tag'] = $this->input->post('currency_tag');

		if(empty($data['currency_tag'])){
			$failed = "
				Please enter Currency Sign!<br>
				";
			$this->session->set_flashdata('failed', $failed);
			redirect('dashboardcontroller/addcurrencyinfo');
		}

		$result = $this->DASHBOARDMODEL->insertcurrencyinfo($data);

		if ($result) {
			$success = "
				Data successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('dashboardcontroller/addcurrencyinfo');
		}
	}

	 
}