<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Billingcontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		
		$this->load->model('invoicemodel','INVOICEMODEL',TRUE);
                
		$id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        }
		 
	}

	public function index()
	{
		
	}

	public function newprescription()
	{
		
			$data = array();
			//$dt = new DateTime();
			$one = 1;
			$data['current_date'] = date('Y-m-d');
			$data['randomSerialNUmber'] = $this->generateRandomString();
	 
			
			$this->db->select('p.*');
    		$this->db->from('patients p');
    		$this->db->join("appointment_fee i", "i.patient_id = p.id");
            $this->db->group_by('i.patient_id');
    	 	$data['patients'] = $this->db->get()->result();
			
			
			$data['test'] = $this->db->get('test')->result();
			$data['feeding'] = $this->db->get('feeding')->result();
			$data['medicines'] = $this->db->get('medicines')->result();

			$data['additional_advice'] = $this->db->get('additional_advice')->result();
			$data['history_of'] = $this->db->get('history_of')->result();
			$data['on_examination'] = $this->db->get('on_examination')->result();
			$data['chief_complaints'] = $this->db->get('chief_complaints')->result();
			$data['investigation'] = $this->db->get('investigation')->result();

			$data['dashboardContent'] = $this->load->view('dashboard/prescription/createprescription', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		
	}

	public function generateRandomString()
	{	
		$this->db->select('invoice_id');
		$this->db->from('invoice');
		$this->db->order_by("id", "DESC");
		$this->db->limit("1");
		$invoice_id = $this->db->get()->row('invoice_id');
		//echo $this->db->last_query;
		
		if($invoice_id){
			return $invoice_id+1;
		}else{
			return '100';
		}

		 
	}

	public function checkproductname()
	{
		$proname = $this->input->post('proname');
		$data = $this->INVOICEMODEL->checkproductname($proname);
		echo json_encode($data);
	}

	public function checksellingpricebyname()
	{
		$proname = $this->input->post('proname');
		$proid = $this->INVOICEMODEL->checkproductid($proname);
		$data = $this->INVOICEMODEL->checksellingpricebyname($proid->item_id);
		echo json_encode($data);
	}
	
	
	public function checkstockbyitemname()
	{
		$proname = $this->input->post('proname');
		$proid = $this->INVOICEMODEL->checkproductid($proname);
		$balancestock = $this->INVOICEMODEL->checkstockbyname($proid->item_id);
		
		
		echo json_encode($balancestock);
	}

	public function getproductname()
	{
		if (isset($_GET['term'])){
	      $q = strtolower($_GET['term']);
	      $this->INVOICEMODEL->getproductname($q);
	    }
	}

	public function creategrouparray($product_name,$quantity,$selling_price,$total_price,$purchasing_price)
	{
		
            foreach($product_name as $k => $name) {
                    $group[] = array('product_name' => $name, 'quantity' => $quantity[$k], 'selling_price' => $selling_price[$k], 'total_price' => $total_price[$k], 'purchasing_price' => $purchasing_price[$k]);
            }      
               return $group; 
        
	}
	
		
	public function insertprescription()
	{
		$data = array();
		$ymd = date('Ym');
		$serial = $this->db->select('pid')->order_by('id','desc')->limit(1)->get('drprescription')->row('pid');
        
        if(substr($serial,0,6)==$ymd){
            $pid = $serial+1;
        }else{
            $pid = $ymd.str_pad(1,3,"0",STR_PAD_LEFT); 
        }
        $gum_bleeding = $this->input->post('gum_bleeding');
        $bad_odour = $this->input->post('bad_odour');
        $cavity = $this->input->post('cavity');
        
        if(isset($gum_bleeding)){
            $data['gum_bleeding']= $gum_bleeding;
        };
        if(isset($bad_odour)){
            $data['bad_odour']= $bad_odour;
        };
        if(isset($cavity)){
            $data['cavity']= $cavity;
        };
        
        $patient_id = $this->input->post('patient_id');

		$date = date('Y-m-d', strtotime($this->input->post('date')));
		$data['patient_id'] = $patient_id;
		$data['date'] = $date;
		$data['pid']= $pid;
		$data['nextdate']= date('Y-m-d', strtotime($this->input->post('nextdate')));
		$data['ref']= $this->input->post('ref');
		 
 		$data['pain'] = $this->input->post('pain');
 		
 		$this->db->insert('drprescription', $data);
 		$prescription_id = $this->db->insert_id();

		$test_id = $this->input->post('test_id');
		foreach ($test_id as $key => $id) { 
		    $test['test_id']= $id;
		    $test['prescription_id']= $prescription_id;
		    $test['patient_id']= $patient_id;
		    $test['date']= $date;
		    $this->db->insert('patient_test', $test);
		}
  		
  		$medicine = $this->input->post('medicine');
		foreach ($medicine as $key => $medicine_id) { 
		    $medi['prescription_id']= $prescription_id;
		    $medi['medicine_id']= $medicine_id;
		    $medi['patient_id']= $patient_id;
		    $medi['feed_rules_id']= $this->input->post('feed_rules')[$key];
		    $medi['feeddays_id']= $this->input->post('feeddays')[$key];
		    $medi['date']= $date;
		    $this->db->insert('patient_medicine', $medi);
		}

		$chief_complaints = $this->input->post('chief_complaints');
		foreach ($chief_complaints as $key => $cc_id) { 
		    $cc['prescription_id']= $prescription_id;
		    $cc['patient_id']= $patient_id;
		    $cc['cc_id']= $cc_id;
		    $cc['date']= $date;
		    $this->db->insert('patient_cc', $cc);
		}

		$history_of = $this->input->post('history_of');
		foreach ($history_of as $key => $ho_id) { 
		    $ho['prescription_id']= $prescription_id;
		    $ho['patient_id']= $patient_id;
		    $ho['ho_id']= $ho_id;
		    $ho['date']= $date;
		    $this->db->insert('patient_ho', $ho);
		}

		$on_examination = $this->input->post('on_examination');
		foreach ($on_examination as $key => $oe_id) { 
		    $oe['prescription_id']= $prescription_id;
		    $oe['patient_id']= $patient_id;
		    $oe['oe_id']= $oe_id;
		    $oe['date']= $date;
		    $this->db->insert('patient_oe', $oe);
		}

		$investigation = $this->input->post('investigation');
		foreach ($investigation as $key => $investigation_id) { 
		    $invest['prescription_id']= $prescription_id;
		    $invest['patient_id']= $patient_id;
		    $invest['investigation_id']= $investigation_id;
		    $invest['date']= $date;
		    $this->db->insert('patient_investigation', $invest);
		}

		$additional_advice = $this->input->post('additional_advice');
		foreach ($additional_advice as $key => $advice_id) { 
		    $advice['prescription_id']= $prescription_id;
		    $advice['patient_id']= $patient_id;
		    $advice['advice_id']= $advice_id;
		    $advice['date']= $date;
		    $this->db->insert('patient_advice', $advice);
		}

		redirect("billingcontroller/print/".$prescription_id);
		

	}

	public function edit($prescription_id='')
	{
		if($_POST){
			$prescription_id = $this->input->post('id');
			$patient_id = $this->input->post('patient_id');
			$date = date('Y-m-d', strtotime($this->input->post('date')));

            $gum_bleeding = $this->input->post('gum_bleeding');
            $bad_odour = $this->input->post('bad_odour');
            $cavity = $this->input->post('cavity');
            
            if(isset($gum_bleeding)){
                $data['gum_bleeding']= $gum_bleeding;
            };
            if(isset($bad_odour)){
                $data['bad_odour']= $bad_odour;
            };
            if(isset($cavity)){
                $data['cavity']= $cavity;
            };

            $data['nextdate']= date('Y-m-d', strtotime($this->input->post('nextdate')));
			$data['ref']= $this->input->post('ref');

			$data['patient_id'] = $patient_id;
			$data['date'] = $date;
	 		$data['pain'] = $this->input->post('pain');
	 		$this->INVOICEMODEL->infoupdate($data, 'drprescription', 'id', $prescription_id);
	 		
	 		$test_id = $this->input->post('test_id');
	 		$this->INVOICEMODEL->prescriptioninfodelete('patient_test',$prescription_id);
			foreach ($test_id as $key => $id) { 
			    $test['test_id']= $id;
			    $test['prescription_id']= $prescription_id;
			    $test['patient_id']= $patient_id;
			    $test['date']= $date;
			    $this->db->insert('patient_test', $test);
			}

			$medicine = $this->input->post('medicine');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_medicine',$prescription_id);
			foreach ($medicine as $key => $medicine_id) { 
			    $medi['prescription_id']= $prescription_id;
			    $medi['medicine_id']= $medicine_id;
			    $medi['patient_id']= $patient_id;
			    $medi['feed_rules_id']= $this->input->post('feed_rules')[$key];
			    $medi['feeddays_id']= $this->input->post('feeddays')[$key];
			    $medi['date']= $date;
			    $this->db->insert('patient_medicine', $medi);
			}

			$chief_complaints = $this->input->post('chief_complaints');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_cc',$prescription_id);
			foreach ($chief_complaints as $key => $cc_id) { 
			    $cc['prescription_id']= $prescription_id;
			    $cc['patient_id']= $patient_id;
			    $cc['cc_id']= $cc_id;
			    $cc['date']= $date;
			    $this->db->insert('patient_cc', $cc);
			}

			$history_of = $this->input->post('history_of');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_ho',$prescription_id);
			foreach ($history_of as $key => $ho_id) { 
			    $ho['prescription_id']= $prescription_id;
			    $ho['patient_id']= $patient_id;
			    $ho['ho_id']= $ho_id;
			    $ho['date']= $date;
			    $this->db->insert('patient_ho', $ho);
			}

			$on_examination = $this->input->post('on_examination');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_oe',$prescription_id);
			foreach ($on_examination as $key => $oe_id) { 
			    $oe['prescription_id']= $prescription_id;
			    $oe['patient_id']= $patient_id;
			    $oe['oe_id']= $oe_id;
			    $oe['date']= $date;
			    $this->db->insert('patient_oe', $oe);
			}

			$investigation = $this->input->post('investigation');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_investigation',$prescription_id);
			foreach ($investigation as $key => $investigation_id) { 
			    $invest['prescription_id']= $prescription_id;
			    $invest['patient_id']= $patient_id;
			    $invest['investigation_id']= $investigation_id;
			    $invest['date']= $date;
			    $this->db->insert('patient_investigation', $invest);
			}

			$additional_advice = $this->input->post('additional_advice');
			$this->INVOICEMODEL->prescriptioninfodelete('patient_advice',$prescription_id);
			foreach ($additional_advice as $key => $advice_id) { 
			    $advice['prescription_id']= $prescription_id;
			    $advice['patient_id']= $patient_id;
			    $advice['advice_id']= $advice_id;
			    $advice['date']= $date;
			    $this->db->insert('patient_advice', $advice);
			}

	 		redirect('billingcontroller/edit/'.$prescription_id);

		}else{
			$data = array();
			$this->db->select('p.*');
			$this->db->from('patients p');
			$this->db->join("appointment_fee i", "i.patient_id = p.id");
	        $this->db->group_by('i.patient_id');
		 	$data['patients'] = $this->db->get()->result();
					
			$data['test'] = $this->db->get('test')->result();
			$data['feeding'] = $this->db->get('feeding')->result();
			$data['medicines'] = $this->db->get('medicines')->result();

			$this->db->select('pm.*, f.name AS fname, m.name as mname');
			$this->db->from('patient_medicine pm');
			$this->db->join('medicines m', 'pm.medicine_id = m.id','left');
			$this->db->join('feeding f', 'pm.feed_rules_id = f.id','left');
			$this->db->where('pm.prescription_id', $prescription_id);
			$data['patient_medicine'] = $this->db->get()->result();


			$data['additional_advice'] = $this->db->get('additional_advice')->result();
			$data['history_of'] = $this->db->get('history_of')->result();
			$data['on_examination'] = $this->db->get('on_examination')->result();
			$data['chief_complaints'] = $this->db->get('chief_complaints')->result();
			$data['investigation'] = $this->db->get('investigation')->result();

			$data['patient_oe'] = $this->INVOICEMODEL->prescriptioninfo('patient_oe', $prescription_id);
			$data['patient_cc'] = $this->INVOICEMODEL->prescriptioninfo('patient_cc', $prescription_id);
			$data['patient_investigation'] = $this->INVOICEMODEL->prescriptioninfo('patient_investigation', $prescription_id);
			$data['patient_ho'] = $this->INVOICEMODEL->prescriptioninfo('patient_ho', $prescription_id);
			$data['patient_advice'] = $this->INVOICEMODEL->prescriptioninfo('patient_advice', $prescription_id);
			$data['patient_test'] = $this->INVOICEMODEL->prescriptioninfo('patient_test', $prescription_id);


			$this->db->select('*');
			$this->db->from('drprescription'); 
			$this->db->where('id', $prescription_id);
			$data['edit'] = $this->db->get()->row();

			$data['dashboardContent'] = $this->load->view('dashboard/prescription/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}

	}
	
	public function print($prescription_id='')
	{	

		$this->db->select('pr.*, d.name AS drname, d.specialist,d.educationDegree, p.idnumber, p.name AS pname, p.gender, p.phone, p.age, p.address');
		$this->db->from('drprescription pr');
		$this->db->join('patients p', 'pr.patient_id = p.id','left');
		$this->db->join('doctors d', 'p.doctor_id=d.id','left');
		$this->db->where('pr.id', $prescription_id);
		$data['patient'] = $this->db->get()->row();
 		//medicines
		$this->db->select('pm.*, f.name AS fname, m.name as mname');
		$this->db->from('patient_medicine pm');
		$this->db->join('medicines m', 'pm.medicine_id = m.id','left');
		$this->db->join('feeding f', 'pm.feed_rules_id = f.id','left');

		$this->db->where('pm.prescription_id', $prescription_id);
		$data['patient_medicine'] = $this->db->get()->result();
		// oe
		$this->db->select('oe.name');
		$this->db->from('patient_oe p');
		$this->db->join('on_examination oe', 'p.oe_id = oe.id','left');
		$this->db->where('p.prescription_id', $prescription_id);
		$data['on_examination'] = $this->db->get()->result();

		// cc
		$this->db->select('cc.name');
		$this->db->from('patient_cc p');
		$this->db->join('chief_complaints cc', 'p.cc_id = cc.id','left');
		$this->db->where('p.prescription_id', $prescription_id);
		$data['chief_complaints'] = $this->db->get()->result();
		// investigation 

		$this->db->select('i.name');
		$this->db->from('patient_investigation p');
		$this->db->join('investigation i', 'p.investigation_id = i.id','left');
		$this->db->where('p.prescription_id', $prescription_id);
		$data['patient_investigation'] = $this->db->get()->result();
		// history_of 
		
		$this->db->select('ho.name');
		$this->db->from('patient_ho p');
		$this->db->join('history_of ho', 'p.ho_id = ho.id','left');
		$this->db->where('p.prescription_id', $prescription_id);
		$data['history_of'] = $this->db->get()->result();
		// additional_advice 
		
		$this->db->select('a.name');
		$this->db->from('patient_advice p');
		$this->db->join('additional_advice a', 'p.advice_id = a.id','left');
		$this->db->where('p.prescription_id', $prescription_id);
		$data['additional_advice'] = $this->db->get()->result();
		// test 
		$this->db->select('t.testName');
		$this->db->from('patient_test pt');
		$this->db->join('test t', 'pt.test_id = t.id','left');
		$this->db->where('pt.prescription_id', $prescription_id);
		$data['patient_test'] = $this->db->get()->result();

		$data['app_config'] = $this->db->get_where('app_config', ['id'=>1])->row();

		$data['dashboardContent'] = $this->load->view('dashboard/prescription/print', $data,TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function prescriptionlist()
	{
		$this->db->select('pr.id, pr.patient_id, pr.pid,pr.date, d.name AS drname, d.specialist,d.educationDegree, p.idnumber, p.name AS pname, p.gender, p.phone, p.age, p.address');
		$this->db->from('drprescription pr');
		$this->db->join('patients p', 'pr.patient_id = p.id','left');
		$this->db->join('doctors d', 'p.doctor_id=d.id','left');
		$this->db->order_by('pr.pid', 'desc');

		$data['prescription'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/prescription/prescriptionlist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deleteprescription($prescription_id='')
	{
		
		$result = $this->db->delete('drprescription', ['id'=>$prescription_id]);
		$this->db->delete('patient_medicine', ['prescription_id'=>$prescription_id]);
		$this->db->delete('patient_test', ['prescription_id'=>$prescription_id]);

		$this->db->delete('patient_oe', ['prescription_id'=>$prescription_id]);
		$this->db->delete('patient_advice', ['prescription_id'=>$prescription_id]);
		$this->db->delete('patient_cc', ['prescription_id'=>$prescription_id]);
		$this->db->delete('patient_ho', ['prescription_id'=>$prescription_id]);
		$this->db->delete('patient_investigatio', ['prescription_id'=>$prescription_id]);

		if($result){
			$success = "
				Prescription Deleted Successfully!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("billingcontroller/prescriptionlist");
		}

	}

	public function printviewinvoice($invoice_id,$command='')
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y-m-d');

		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);

		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		
		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);

		$data['storeInfo'] = $this->INVOICEMODEL->storeInfo();

		//$data['querycurrencytag'] = $this->INVOICEMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/prescription/printviewinvoice', $data,TRUE);
		//printviewinvoice
		if($command=='email')
		{
			$data['command']='email';
			$invoicedetail=$data['queryinvoicebyinvoiceid'];
			$email_address=$invoicedetail->email_address;
			$content=$this->load->view('dashboard/prescription/email_view_invoice', $data, TRUE);
			$this->load->library('email');
			$config['protocol'] = 'smtp';
		    $config['smtp_host'] = 'mail.grameensoft.com'; //change this
		    $config['smtp_port'] = '25';
		    $config['smtp_user'] = 'info@grameensoft.com'; //change this
		    $config['smtp_pass'] = '123#123#'; //change this
		    $config['mailtype'] = 'html';
		    $config['charset'] = 'iso-8859-1';
		    $config['wordwrap'] = TRUE;
		    $config['newline'] = "\r\n";
			$this->email->initialize($config);
			$this->email->clear();
			$this->email->to($email_address);
			$this->email->from('info@grameensoft.com','Zaman IT');
			$this->email->reply_to('zamanit009@gmail.com','Zaman IT');
		    $this->email->subject('Invoice from Zaman IT');
		    $this->email->message($content);
		    $this->email->send();
			echo "<script>alert('Email has been sent');</script>";
		}
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deliverychalan($invoice_id,$command='')
	{
		$data = array();
		//$dt = new DateTime();
		$data['current_date'] = date('Y-m-d');

		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);

		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		
		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);

		$data['storeInfo'] = $this->INVOICEMODEL->storeInfo();

		//$data['querycurrencytag'] = $this->INVOICEMODEL->querycurrencytag();

		$data['dashboardContent'] = $this->load->view('dashboard/prescription/deliverychalan', $data,TRUE);
		//printviewinvoice
		if($command=='email')
		{
			$data['command']='email';
			$invoicedetail=$data['queryinvoicebyinvoiceid'];
			$email_address=$invoicedetail->email_address;
			$content=$this->load->view('dashboard/prescription/email_view_invoice', $data, TRUE);
			$this->load->library('email');
			$config['protocol'] = 'smtp';
		    $config['smtp_host'] = 'mail.grameensoft.com'; //change this
		    $config['smtp_port'] = '25';
		    $config['smtp_user'] = 'info@grameensoft.com'; //change this
		    $config['smtp_pass'] = '123#123#'; //change this
		    $config['mailtype'] = 'html';
		    $config['charset'] = 'iso-8859-1';
		    $config['wordwrap'] = TRUE;
		    $config['newline'] = "\r\n";
			$this->email->initialize($config);
			$this->email->clear();
			$this->email->to($email_address);
			$this->email->from('info@grameensoft.com','Zaman IT');
			$this->email->reply_to('zamanit009@gmail.com','Zaman IT');
		    $this->email->subject('Invoice from Zaman IT');
		    $this->email->message($content);
		    $this->email->send();
			echo "<script>alert('Email has been sent');</script>";
		}
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	
	public function send_sms($invcid='')
	{
	    ob_start();
		$queryinvoicebyinvoiceid = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invcid);
		$queryinvoiceditembyinvoiceid = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invcid);
		$duepaymenthistorybyinvoiceid = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invcid);
		$total_due_paid = 0;
        foreach ($duepaymenthistorybyinvoiceid as $duepaymenthistory) {
        	$total_due_paid = $duepaymenthistory->first_payment + $total_due_paid;
        }
        $messages = 'নাম: '.$queryinvoicebyinvoiceid->customer_name."\n";
		$messages .= 'মেমো নং: '.$queryinvoicebyinvoiceid->invoice_id."\n";
		$messages .= 'মোট বিল: '.$queryinvoicebyinvoiceid->grand_total.' Tk'."\n";
		$messages .= 'জমা: '.($queryinvoicebyinvoiceid->paid_amount+$total_due_paid).' Tk'."\n";
		$messages .= 'বাকী: '.$queryinvoicebyinvoiceid->due_amount.' Tk';
		//echo $queryinvoicebyinvoiceid->customer_mobile;
		 
		$url = 'http://sms.dhakasoftit.com/smsapi?api_key=C20033165d46de6008ae78.56511566&type=text/unicode&contacts='.$queryinvoicebyinvoiceid->customer_mobile.'&senderid=CBM BRICKS&msg='.urlencode($messages);	
		 
        $gateway = preg_replace("/ /", "%20", $url);
        $result = file_get_contents($gateway);  
        if($result){

            echo $result;
        }else{
            echo $result;
        }
        ob_end_flush(); 

	}

	public function searchinvoice()
	{
		$data = array();
		$invoice_id = $this->input->post('invoice_id');
		
		$checkingexisting = $this->INVOICEMODEL->checkingexisting($invoice_id);

		if($checkingexisting){
			redirect("billingcontroller/printviewinvoice/$invoice_id");
		}else{
			$invalied_invoice = "Please enter Valid Invoice No!!";
			$this->session->set_flashdata('invalied_invoice', $invalied_invoice);
			redirect("dashboardcontroller");
		}
		
	}
	

	public function viewinvoice()
	{
		$data = array();
		$data['queryinvoice'] = $this->INVOICEMODEL->queryinvoice();

		$data['dashboardContent'] = $this->load->view('dashboard/prescription/viewinvoice', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function viewdueinvoice()
	{
		$data = array();
		$data['querydueinvoice'] = $this->INVOICEMODEL->querydueinvoice();
		


		$data['dashboardContent'] = $this->load->view('dashboard/prescription/viewdueinvoice', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function addpaymentbyviewdueinvoice($invoice_id)
	{
		$data = array();
		$data['queryinvoicebyinvoiceid'] = $this->INVOICEMODEL->queryinvoicebyinvoiceid($invoice_id);
		$data['queryinvoiceditembyinvoiceid'] = $this->INVOICEMODEL->queryinvoiceditembyinvoiceid($invoice_id);
		

		$data['duepaymenthistorybyinvoiceid'] = $this->INVOICEMODEL->duepaymenthistorybyinvoiceid($invoice_id);



		$data['dashboardContent'] = $this->load->view('dashboard/prescription/editinvoiceforaddpayment', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertpaymentofduebyinvoiceid()
	{
		$data = array();
		//$dt = new DateTime();
		$data['invoice_id'] = $this->input->post('invoice_id');
		$data['first_payment'] = $this->input->post('first_payment');
		$data['payment_date'] = date('Y-m-d');
		
		$invoice_id = $this->input->post('invoice_id');
		if(empty($data['first_payment'])){
			$failed = "
				Please insert valid amount!<br>
				";
			$this->session->set_flashdata('failed', $failed);
			redirect("billingcontroller/addpaymentbyviewdueinvoice/$invoice_id");
		}

		$querybalancebyinvoiceid = $this->INVOICEMODEL->querybalancebyinvoiceid($data['invoice_id']);


		$duedata['due_amount'] = $querybalancebyinvoiceid->due_amount - $data['first_payment'];
		
		
		$update = $this->INVOICEMODEL->updatedueamountbyinvoiceid($duedata,$invoice_id);

		$result = $this->INVOICEMODEL->insertpaymentofduebyinvoiceid($data);

		if ($result) {
			$success = "
				Payment successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("billingcontroller/addpaymentbyviewdueinvoice/$invoice_id");
		}
	}

	public function deleteinvoicebyinvoiceid($invoice_id=Null)
	{
		$invoice = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfrominvoice($invoice_id);
		$invoiced_item = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfrominvoiced_item($invoice_id);
		$dues = $this->INVOICEMODEL->deleteinvoicebyinvoiceidfromdues($invoice_id);

		//if ($invoice && $invoiced_item && $dues) 
		{
			$success = "
				Invoice Deleted Successfully!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("billingcontroller/viewinvoice");
		}
	}
}
?>