/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: amrmemo_dentaldemo
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `amrmemo_dentaldemo`
--


--
-- Table structure for table `additional_advice`
--

DROP TABLE IF EXISTS `additional_advice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `additional_advice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `additional_advice`
--

LOCK TABLES `additional_advice` WRITE;
/*!40000 ALTER TABLE `additional_advice` DISABLE KEYS */;
INSERT INTO `additional_advice` (`id`, `name`) VALUES (2,'Advice 2'),
(3,'Advice 3');
/*!40000 ALTER TABLE `additional_advice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_config`
--

DROP TABLE IF EXISTS `app_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyName` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `address` varchar(222) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `phone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `telephone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `logo` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `print` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_config`
--

LOCK TABLES `app_config` WRITE;
/*!40000 ALTER TABLE `app_config` DISABLE KEYS */;
INSERT INTO `app_config` (`id`, `companyName`, `address`, `phone`, `email`, `telephone`, `logo`, `print`) VALUES (1,'Dental Clinic','Dhaka 1211.','+8801234567891','dentaloffice@gmail.com','+880123456789','9b1f595816d87d9a97fe8b06561b2fc5.png','1');
/*!40000 ALTER TABLE `app_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment_fee`
--

DROP TABLE IF EXISTS `appointment_fee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `appointment_fee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `appointment_date` date NOT NULL,
  `appointment_fee` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment_fee`
--

LOCK TABLES `appointment_fee` WRITE;
/*!40000 ALTER TABLE `appointment_fee` DISABLE KEYS */;
INSERT INTO `appointment_fee` (`id`, `appointment_id`, `patient_id`, `doctor_id`, `appointment_date`, `appointment_fee`, `discount`, `net_total`, `due_amount`, `paid_amount`, `prepared_by`) VALUES (15,'A10001',26,0,'2024-02-06',0.00,0.00,0.00,NULL,NULL,'Dhaka Dental'),
(16,'A10002',27,11,'2024-02-06',1000.00,200.00,800.00,NULL,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `appointment_fee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chief_complaints`
--

DROP TABLE IF EXISTS `chief_complaints`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `chief_complaints` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chief_complaints`
--

LOCK TABLES `chief_complaints` WRITE;
/*!40000 ALTER TABLE `chief_complaints` DISABLE KEYS */;
INSERT INTO `chief_complaints` (`id`, `name`) VALUES (3,'COPD'),
(4,'HTN '),
(5,'DM'),
(6,'Anaemia');
/*!40000 ALTER TABLE `chief_complaints` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `doctors`
--

DROP TABLE IF EXISTS `doctors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `phone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `serialcontactNo` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `educationDegree` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `specialist` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `visitingHours` varchar(100) DEFAULT NULL,
  `address` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `hospitalName` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `photo` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `appointment_fee` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `doctors`
--

LOCK TABLES `doctors` WRITE;
/*!40000 ALTER TABLE `doctors` DISABLE KEYS */;
INSERT INTO `doctors` (`id`, `name`, `phone`, `serialcontactNo`, `educationDegree`, `specialist`, `visitingHours`, `address`, `hospitalName`, `photo`, `appointment_fee`) VALUES (11,'Mr X','012345678910','123456789101','MBBS','Medicine','10 AM to 8 PM','Dhaka, Bangladesh','DMC ','',1000);
/*!40000 ALTER TABLE `doctors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drprescription`
--

DROP TABLE IF EXISTS `drprescription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drprescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(20) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pain` varchar(10) DEFAULT NULL,
  `nextdate` text DEFAULT NULL,
  `gum_bleeding` varchar(50) DEFAULT NULL,
  `bad_odour` varchar(50) DEFAULT NULL,
  `cavity` varchar(50) DEFAULT NULL,
  `ref` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drprescription`
--

LOCK TABLES `drprescription` WRITE;
/*!40000 ALTER TABLE `drprescription` DISABLE KEYS */;
INSERT INTO `drprescription` (`id`, `pid`, `doctor_id`, `patient_id`, `date`, `pain`, `nextdate`, `gum_bleeding`, `bad_odour`, `cavity`, `ref`) VALUES (10,'202402001',0,27,'2024-02-06','1,4','2024-02-29','Gum Bleeding',NULL,'Cavity','');
/*!40000 ALTER TABLE `drprescription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dues`
--

DROP TABLE IF EXISTS `dues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `first_payment` decimal(15,2) NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dues`
--

LOCK TABLES `dues` WRITE;
/*!40000 ALTER TABLE `dues` DISABLE KEYS */;
/*!40000 ALTER TABLE `dues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feeding`
--

DROP TABLE IF EXISTS `feeding`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feeding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  `count` varchar(22) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feeding`
--

LOCK TABLES `feeding` WRITE;
/*!40000 ALTER TABLE `feeding` DISABLE KEYS */;
INSERT INTO `feeding` (`id`, `name`, `count`) VALUES (1,'1+1+1 Before Meal','3'),
(2,'1+0+1 After Meal','2'),
(3,'0+1+0 Before Meal','1'),
(4,'দুপুরের খাবারের পরে ',''),
(5,'খাবারের আগে ','');
/*!40000 ALTER TABLE `feeding` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `history_of`
--

DROP TABLE IF EXISTS `history_of`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `history_of` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `history_of`
--

LOCK TABLES `history_of` WRITE;
/*!40000 ALTER TABLE `history_of` DISABLE KEYS */;
INSERT INTO `history_of` (`id`, `name`) VALUES (1,'History Of 2'),
(2,'History '),
(3,'History  3'),
(4,'DM'),
(5,'Hepatitis'),
(6,'HTN'),
(7,'Clopid');
/*!40000 ALTER TABLE `history_of` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `investigation`
--

DROP TABLE IF EXISTS `investigation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `investigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `investigation`
--

LOCK TABLES `investigation` WRITE;
/*!40000 ALTER TABLE `investigation` DISABLE KEYS */;
INSERT INTO `investigation` (`id`, `name`) VALUES (2,'X-ray OPG'),
(3,'IOPA');
/*!40000 ALTER TABLE `investigation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoice`
--

DROP TABLE IF EXISTS `invoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `grand_total` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoice`
--

LOCK TABLES `invoice` WRITE;
/*!40000 ALTER TABLE `invoice` DISABLE KEYS */;
INSERT INTO `invoice` (`id`, `invoice_id`, `patient_id`, `invoice_date`, `sub_total`, `discount`, `grand_total`, `net_total`, `due_amount`, `paid_amount`, `note`, `prepared_by`) VALUES (2,'M10002',21,'2023-11-18',23.00,10.00,NULL,12.00,0.00,12.00,NULL,'Dhaka Dental'),
(3,'M10003',22,'2023-11-18',675.00,0.00,NULL,675.00,675.00,0.00,NULL,'Dhaka Dental'),
(4,'M10004',25,'2023-11-21',85.00,0.00,NULL,85.00,85.00,0.00,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `invoice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoiced_item`
--

DROP TABLE IF EXISTS `invoiced_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoiced_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `invoice_date` date NOT NULL,
  `medicine_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `unit` varchar(30) DEFAULT NULL,
  `price` float(10,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoiced_item`
--

LOCK TABLES `invoiced_item` WRITE;
/*!40000 ALTER TABLE `invoiced_item` DISABLE KEYS */;
INSERT INTO `invoiced_item` (`id`, `invoice_id`, `invoice_date`, `medicine_id`, `quantity`, `unit`, `price`, `total_price`) VALUES (10,'2','2023-11-18',1,1.00,NULL,2.00,2.00),
(11,'2','2023-11-18',2,1.00,NULL,8.00,8.00),
(12,'2','2023-11-18',3,1.00,NULL,3.00,3.00),
(13,'2','2023-11-18',5,1.00,NULL,8.00,8.00),
(14,'2','2023-11-18',6,1.00,NULL,2.00,2.00),
(15,'3','2023-11-18',8,10.00,NULL,35.00,350.00),
(16,'3','2023-11-18',9,10.00,NULL,20.00,200.00),
(17,'3','2023-11-18',7,5.00,NULL,7.00,35.00),
(18,'3','2023-11-18',5,10.00,NULL,8.00,80.00),
(19,'3','2023-11-18',1,5.00,NULL,2.00,10.00),
(20,'4','2023-11-21',1,20.00,NULL,2.00,40.00),
(21,'4','2023-11-21',3,15.00,NULL,3.00,45.00);
/*!40000 ALTER TABLE `invoiced_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medicines`
--

DROP TABLE IF EXISTS `medicines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `medicines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  `supplier` varchar(222) DEFAULT NULL,
  `category` varchar(222) DEFAULT NULL,
  `price` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medicines`
--

LOCK TABLES `medicines` WRITE;
/*!40000 ALTER TABLE `medicines` DISABLE KEYS */;
INSERT INTO `medicines` (`id`, `name`, `supplier`, `category`, `price`) VALUES (1,'Tab. Napa 500mg','Beximco Pharmaceuticals Ltd','Paracetamol',2),
(2,'Tab. Sergel 20mg','Healthcare Pharmaceuticals Ltd','Esomeprazole Magnesium Trihydrate',8),
(3,'Tab. Alatrol 10mg','Square Pharmaceuticals PLC','Cetirizine Dihydrochloride',3),
(4,'Tab. Monas 10mg','The ACME Laboratories Ltd.','Montelukast',17),
(5,'Tab. Fexofast 120mg','Drug International Ltd.','Fexofenadine Hydrochloride',8),
(6,'Sivit','Square Pharmaceuticals LTD.','Cetirizine Dihydrochloride',2),
(8,'CEF -3','SQUARE','CEFIXGIME',35),
(9,'VASCO','INCEPTA','ASCORVIC ACID',20);
/*!40000 ALTER TABLE `medicines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `on_examination`
--

DROP TABLE IF EXISTS `on_examination`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `on_examination` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `on_examination`
--

LOCK TABLES `on_examination` WRITE;
/*!40000 ALTER TABLE `on_examination` DISABLE KEYS */;
INSERT INTO `on_examination` (`id`, `name`) VALUES (1,'On Examination (O/E)'),
(2,'Pericoronitis');
/*!40000 ALTER TABLE `on_examination` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_advice`
--

DROP TABLE IF EXISTS `patient_advice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_advice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `advice_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_advice`
--

LOCK TABLES `patient_advice` WRITE;
/*!40000 ALTER TABLE `patient_advice` DISABLE KEYS */;
INSERT INTO `patient_advice` (`id`, `prescription_id`, `patient_id`, `advice_id`, `date`) VALUES (13,10,27,0,'2024-02-06');
/*!40000 ALTER TABLE `patient_advice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_cc`
--

DROP TABLE IF EXISTS `patient_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_cc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `cc_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=18 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_cc`
--

LOCK TABLES `patient_cc` WRITE;
/*!40000 ALTER TABLE `patient_cc` DISABLE KEYS */;
INSERT INTO `patient_cc` (`id`, `prescription_id`, `patient_id`, `cc_id`, `date`) VALUES (17,10,27,3,'2024-02-06');
/*!40000 ALTER TABLE `patient_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_ho`
--

DROP TABLE IF EXISTS `patient_ho`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_ho` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `ho_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_ho`
--

LOCK TABLES `patient_ho` WRITE;
/*!40000 ALTER TABLE `patient_ho` DISABLE KEYS */;
INSERT INTO `patient_ho` (`id`, `prescription_id`, `patient_id`, `ho_id`, `date`) VALUES (24,10,27,2,'2024-02-06');
/*!40000 ALTER TABLE `patient_ho` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_investigation`
--

DROP TABLE IF EXISTS `patient_investigation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_investigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `investigation_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_investigation`
--

LOCK TABLES `patient_investigation` WRITE;
/*!40000 ALTER TABLE `patient_investigation` DISABLE KEYS */;
INSERT INTO `patient_investigation` (`id`, `prescription_id`, `patient_id`, `investigation_id`, `date`) VALUES (1,1,16,1,'2023-11-09'),
(3,2,17,1,'2023-11-12'),
(4,5,20,2,'2023-11-16'),
(5,7,24,2,'2023-11-21'),
(9,8,24,2,'2023-11-21'),
(11,9,25,2,'2023-11-21'),
(12,10,27,2,'2024-02-06');
/*!40000 ALTER TABLE `patient_investigation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_medicine`
--

DROP TABLE IF EXISTS `patient_medicine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `medicine_id` int(11) NOT NULL,
  `feed_rules_id` int(11) NOT NULL,
  `feeddays_id` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_medicine`
--

LOCK TABLES `patient_medicine` WRITE;
/*!40000 ALTER TABLE `patient_medicine` DISABLE KEYS */;
INSERT INTO `patient_medicine` (`id`, `prescription_id`, `patient_id`, `medicine_id`, `feed_rules_id`, `feeddays_id`, `date`) VALUES (25,10,27,1,3,'7 Days','2024-02-06'),
(26,10,27,6,5,'2 Days','2024-02-06');
/*!40000 ALTER TABLE `patient_medicine` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_oe`
--

DROP TABLE IF EXISTS `patient_oe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_oe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `oe_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_oe`
--

LOCK TABLES `patient_oe` WRITE;
/*!40000 ALTER TABLE `patient_oe` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_oe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_test`
--

DROP TABLE IF EXISTS `patient_test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_test`
--

LOCK TABLES `patient_test` WRITE;
/*!40000 ALTER TABLE `patient_test` DISABLE KEYS */;
/*!40000 ALTER TABLE `patient_test` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patients`
--

DROP TABLE IF EXISTS `patients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idnumber` varchar(20) NOT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `gender` varchar(10) NOT NULL,
  `phone` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `age` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `prepared_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patients`
--

LOCK TABLES `patients` WRITE;
/*!40000 ALTER TABLE `patients` DISABLE KEYS */;
INSERT INTO `patients` (`id`, `idnumber`, `doctor_id`, `name`, `gender`, `phone`, `age`, `address`, `create_date`, `prepared_by`) VALUES (27,'P10001',11,'SAJIB MALLIK','Male','01917778898','33','Dhaka, Bangladesh','2024-02-06 10:07:54','Dhaka Dental');
/*!40000 ALTER TABLE `patients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patients_documents`
--

DROP TABLE IF EXISTS `patients_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patients_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `type` varchar(30) NOT NULL,
  `documents` varchar(50) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patients_documents`
--

LOCK TABLES `patients_documents` WRITE;
/*!40000 ALTER TABLE `patients_documents` DISABLE KEYS */;
INSERT INTO `patients_documents` (`id`, `patient_id`, `type`, `documents`, `create_date`) VALUES (1,4,'Report','5caa5d8ba206af762a4b887029cc3b40.pdf','2023-09-26 09:05:13'),
(2,4,'others','d300cffbf4c697405b67c05f54b8d437.jpg','2023-09-27 10:29:56'),
(3,4,'Report','f5967cf2ec097be07c76ce2755507a0a.jpg','2023-09-27 10:30:09'),
(4,9,'Report','2d016c2e8af1dccf8b06e4a843f83997.jfif','2023-10-11 07:00:08');
/*!40000 ALTER TABLE `patients_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('05d3d65f6c6954ee3adba63e272c4f5ab8bb590e','103.67.156.117',1700147858,'__ci_last_regenerate|i:1700147858;'),
('57535c23616c255fc343c58aca9761b33712894b','103.67.156.117',1700147976,'__ci_last_regenerate|i:1700147880;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('40955601065148e3facfde3eaa58e736fbe36bd6','103.190.75.134',1700148566,'__ci_last_regenerate|i:1700148566;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('086525659d825340333020f807324ec03b7a844d','103.190.75.134',1700149177,'__ci_last_regenerate|i:1700149177;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('c62fdf0b8a1d2bd0c4dd8d6c0e5d061abe1668b9','103.190.75.134',1700149524,'__ci_last_regenerate|i:1700149524;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('955def27bcfb949f22d7ff67ec0c037b5bdee439','103.190.75.134',1700149896,'__ci_last_regenerate|i:1700149896;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('333014f7a4724ab6e2612559aa1fbf2855840038','103.190.75.134',1700150203,'__ci_last_regenerate|i:1700150203;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('85ffa354991970a5663d38a3b535e309976de5ef','103.190.75.134',1700150510,'__ci_last_regenerate|i:1700150510;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('d968e3be4609a6ee7d8a0a8d63d327efff1e1d8c','103.190.75.134',1700150843,'__ci_last_regenerate|i:1700150843;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('88b816cf59161513d0e49ec1473c64a2a413c5ad','103.190.75.134',1700151205,'__ci_last_regenerate|i:1700151205;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('5807e708ff0bdc9e5df936b216932197c31f9909','103.190.75.134',1700151516,'__ci_last_regenerate|i:1700151516;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('3ced08520203c6cc99e6e2c4eb443977c940314a','103.190.75.134',1700151826,'__ci_last_regenerate|i:1700151826;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a1416e4190f33f21049d44690bd53e0f587eab75','103.190.75.134',1700152449,'__ci_last_regenerate|i:1700152449;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('51d15bfd2669942d82b7900aa2189f5757a9c401','103.190.75.134',1700152132,'__ci_last_regenerate|i:1700152132;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('26bfe648e87206844d2bc74800be997df819b5a2','103.190.75.134',1700152684,'__ci_last_regenerate|i:1700152449;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a9e389b57b17f34a3539f817541716307673f167','118.179.18.121',1700299579,'__ci_last_regenerate|i:1700299579;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('e493238364020685f6f869e56eb47c2d72cce968','118.179.18.121',1700300578,'__ci_last_regenerate|i:1700300578;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('27f5ee97ac56443f953bc362dda9edfe77f9236e','118.179.18.121',1700302867,'__ci_last_regenerate|i:1700302867;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('2cbd8c5640bee197f708d777ce162f847f3de0f5','118.179.18.121',1700302868,'__ci_last_regenerate|i:1700302867;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('3e660d596592cc36e89522af9908872db416704b','103.190.75.134',1700303901,'__ci_last_regenerate|i:1700303901;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('9e79fb9e73d70204273d5c6d55d53d6df3c16015','103.190.75.134',1700304296,'__ci_last_regenerate|i:1700304296;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('fae23a578d75f9185a364021bf70870918487b13','103.190.75.134',1700304598,'__ci_last_regenerate|i:1700304598;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";success|s:27:\"Data successfully inserted!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}'),
('ae406a61965c7a507412ed4dad75d222ac3755c0','103.190.75.134',1700304772,'__ci_last_regenerate|i:1700304598;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('284bf5ed1e4e23769298fa0a405801e38e59e0d3','144.217.135.248',1700318145,'__ci_last_regenerate|i:1700318145;'),
('340006b56e26ae794c3d0f6ca8a93e450b29e40a','52.167.144.145',1700337350,'__ci_last_regenerate|i:1700337350;'),
('2019c947bd43881e1e36a312d5d4ec6391bfb20a','118.179.18.121',1700371037,'__ci_last_regenerate|i:1700371036;'),
('1ccf92db89ba42ae240f3da3125bd855a57c9580','118.179.18.121',1700386180,'__ci_last_regenerate|i:1700386180;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('314dc4c0cde0da74d1bd189404c00b5b229ce9fd','118.179.18.121',1700386888,'__ci_last_regenerate|i:1700386888;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('b810a1438659d7880c71fc1e123c4cfd10950ee8','118.179.18.121',1700390377,'__ci_last_regenerate|i:1700390377;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('03603f5f07aae55c1f9897c18f27874c30b008c7','118.179.18.121',1700390647,'__ci_last_regenerate|i:1700390377;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('b82f606f91c61e3f9ab0bd739ba4e51f0b9cac71','40.77.167.230',1700409771,'__ci_last_regenerate|i:1700409771;'),
('2a27456ef8a149e4e392f937c2506229287899d9','103.67.157.250',1700545815,'__ci_last_regenerate|i:1700545693;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('725f3d40bd29715d0aa0b490c3d801c7ca7aab58','114.134.90.218',1700547120,'__ci_last_regenerate|i:1700547120;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('ec4b2c85ff8e5bda821c5f6d0653f1c3ada9bfd9','114.134.90.218',1700547438,'__ci_last_regenerate|i:1700547438;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('430b56e4f2f0b15dbf95a4db6317b0b80df95c25','114.134.90.218',1700547897,'__ci_last_regenerate|i:1700547897;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a68c4a07db16ea52a2696b52bcf7081be99544ca','114.134.90.218',1700548381,'__ci_last_regenerate|i:1700548381;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('7545fdcdbfb73fe92fb1c76a3659d94e39e95080','114.134.90.218',1700548758,'__ci_last_regenerate|i:1700548758;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('efc6d4b22481b8829a8b70ebca99ae235d5bbd62','114.134.90.218',1700549227,'__ci_last_regenerate|i:1700549227;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a08845f899529e7bb8904bd621e593bf97e729ed','54.36.149.101',1700548865,'__ci_last_regenerate|i:1700548865;'),
('95af17a457ddb316a510673cf5d3e7c3391e8ef3','114.134.90.218',1700550265,'__ci_last_regenerate|i:1700550265;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('b08872407191bd613df903fbd77f9d0ef1b04fe4','114.134.90.218',1700551454,'__ci_last_regenerate|i:1700551454;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a20921138e68296f945e2b2db9838631556d0b43','52.167.144.234',1700551226,'__ci_last_regenerate|i:1700551226;'),
('c62f004cb1af32afa91f3d2e56612b651704d714','114.134.90.218',1700551697,'__ci_last_regenerate|i:1700551454;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('990ffd8826876192a789c95162d5cff0db94ef3a','103.190.75.134',1700572304,'__ci_last_regenerate|i:1700572304;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"old\";}'),
('ad42eb315aff6e8fbdb0069d18857f93eb985635','103.190.75.134',1700572644,'__ci_last_regenerate|i:1700572644;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"old\";}'),
('524b584bd9de4fc9068dcc81d639061dec879ef8','103.190.75.134',1700572952,'__ci_last_regenerate|i:1700572952;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";success|s:27:\"Data successfully inserted!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}'),
('910906d2a18bcb269828a423dfd160994b237247','103.190.75.134',1700574434,'__ci_last_regenerate|i:1700574434;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('52ea9ae6809e0faca0d45d9de870277f7d210bc5','103.190.75.134',1700578379,'__ci_last_regenerate|i:1700578379;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('7dbb421555ef246f17197e993ddc4dd69ee9e3b2','103.190.75.134',1700578490,'__ci_last_regenerate|i:1700578379;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('38252b9fab8d152e97f4b80074e27c93d117a7f8','103.190.75.134',1700578957,'__ci_last_regenerate|i:1700578957;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('d2d009e6ebc8bdbbe2bf0b1752f760fce2c5cb2e','103.190.75.134',1700579585,'__ci_last_regenerate|i:1700579585;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('2c1a2e518935c99c11ba5a5dbda14dfd1a571eea','103.190.75.134',1700579921,'__ci_last_regenerate|i:1700579921;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('f39ed5e01ffa6f1559054eac1149554d5b84464e','103.190.75.134',1700580234,'__ci_last_regenerate|i:1700580234;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a5dcfd23979dfd2011f5629dbebd8ae74dde6652','103.190.75.134',1700580548,'__ci_last_regenerate|i:1700580548;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('caf2a9a82d96eae808e7650f52a6b6f212835b61','103.190.75.134',1700581109,'__ci_last_regenerate|i:1700581109;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('921015e84c6c85af2c9639af097e59e00b75f3b1','103.167.16.19',1700580674,'__ci_last_regenerate|i:1700580637;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('1ec37e491b4ce3c4d44f23f36cfa49b59d55b710','103.190.75.134',1700581514,'__ci_last_regenerate|i:1700581514;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('61db78d1f338f5732d01707e041131ff8e9f586c','103.190.75.134',1700582174,'__ci_last_regenerate|i:1700582174;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('88ea05072ea5a6215490430b4c5649aad03e4c4e','103.190.75.134',1700582568,'__ci_last_regenerate|i:1700582568;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('dd8a051c7ea7f9bf5d9c6aeabc04d2650a2bbdf6','103.190.75.134',1700583021,'__ci_last_regenerate|i:1700583021;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('5c8f5e58ef5559b36f04a3939d242d78df811eaf','103.190.75.134',1700583342,'__ci_last_regenerate|i:1700583342;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('9c0b0fee9c1125765bd4cc3306ce8df9d552eecb','103.190.75.134',1700583648,'__ci_last_regenerate|i:1700583648;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('d93815b0706964173939b64bd6f555d9c666c6e1','103.190.75.134',1700584054,'__ci_last_regenerate|i:1700584054;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('36ff67a2ebb3de47282cf8c851f93e0ffe009428','103.190.75.134',1700584054,'__ci_last_regenerate|i:1700584054;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('b74730d8a20ae6bc49d30379c265d861a6050c81','103.67.157.252',1700584165,'__ci_last_regenerate|i:1700584164;'),
('c793bbae18fd0316725118834f0d4a5d7b4dfcda','207.46.13.125',1700654138,'__ci_last_regenerate|i:1700654138;'),
('4184f3938435ab14c42d2adf4e6917c345823c4f','23.82.184.165',1700723546,'__ci_last_regenerate|i:1700723546;'),
('4j0b1nae0b7o44lvedno5bhpqrsvba0o','::1',1700731366,'__ci_last_regenerate|i:1700731366;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('ke6lm3q8rh5g9846gvlfqrmts0v2fafa','::1',1700731743,'__ci_last_regenerate|i:1700731743;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('sinheo6dfp0oki9h8dngqn17t984vdo6','::1',1700732474,'__ci_last_regenerate|i:1700732474;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('phahfi3ncvm684du7t5o81hgldhbsh88','::1',1700732474,'__ci_last_regenerate|i:1700732474;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('419d8c38c12bab5a79f433eaccfadd0dda775eea','114.134.90.218',1704018378,'__ci_last_regenerate|i:1704018378;'),
('ddfc122814a96e9e2f76eeac224e1a420835cd66','118.179.18.121',1704019734,'__ci_last_regenerate|i:1704019734;'),
('0d8d25b6d0548d90fe9a0fe31d87c8b2ae41db6a','114.134.90.218',1704021365,'__ci_last_regenerate|i:1704021365;'),
('dfc251b1c353f7f15fc24eac97a334ec90a358fe','118.179.18.121',1704023277,'__ci_last_regenerate|i:1704023277;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('c9edc5d8d4389c8115009a4a6713e21a3577ea18','114.134.90.218',1704021367,'__ci_last_regenerate|i:1704021365;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('ab8cc0079ea43a8650d52001a3ad6fd20514fa84','118.179.18.121',1704023277,'__ci_last_regenerate|i:1704023277;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('230786b7b0a73deec8d7878f621590734b8d4848','118.179.18.121',1704029601,'__ci_last_regenerate|i:1704029601;'),
('d1435a5bb08c7bec7c77e3d9ee25aaaa8a577d2e','118.179.18.121',1704029601,'__ci_last_regenerate|i:1704029601;'),
('bd55e7d1047acbd525ba3f610ad584f446069d2c','104.206.162.128',1704049269,'__ci_last_regenerate|i:1704049269;'),
('36f9151374b572b782f2f705734de5e2e6cfcf41','34.74.250.153',1704055161,'__ci_last_regenerate|i:1704055161;'),
('645bc643b16004bed4ff6f68082c88d6b14c21ab','35.237.3.142',1704068482,'__ci_last_regenerate|i:1704068482;'),
('e1e149b91bf356d3a4a7609aedea188fa8d347cd','118.179.18.121',1704078563,'__ci_last_regenerate|i:1704078555;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"old\";}'),
('fcc3e8949bda3b54bf348b9b40f8f886900a66ad','223.25.253.30',1704088153,'__ci_last_regenerate|i:1704088153;'),
('d485e7148953f5683fd3060b4cdb36f6e01ac54f','94.103.227.7',1704132980,'__ci_last_regenerate|i:1704132980;'),
('f78a14c25dc0b31ffbf7d824109a38b85ab18cc6','85.208.96.209',1704174755,'__ci_last_regenerate|i:1704174755;'),
('e5a8322f6c96a4524590a568a6873048230e2b44','94.103.227.7',1704207840,'__ci_last_regenerate|i:1704207840;'),
('761b5d42fa9fb706f959014339a9c9f6c8272db1','144.76.72.99',1704232393,'__ci_last_regenerate|i:1704232393;'),
('80306820b8b505eb14c5ec212119aa8da4fa6998','94.103.227.7',1704281022,'__ci_last_regenerate|i:1704281022;'),
('2d4e676bd8b62b6c695a0f4177ca52378e4da715','54.36.148.48',1704287232,'__ci_last_regenerate|i:1704287232;'),
('8e2c0b3a5483f0d4b16be8541a0380216a38b1fd','84.32.41.136',1704289621,'__ci_last_regenerate|i:1704289621;'),
('27403896f68e349cc747e93486e1883644af249a','54.36.149.78',1704320910,'__ci_last_regenerate|i:1704320910;'),
('517d13b786400871468ab03887beb0c39c47138b','179.43.167.150',1704324551,'__ci_last_regenerate|i:1704324551;'),
('f3aa3be5f13acc94b739d34ae937c00dfd8b87dc','67.22.62.62',1704371531,'__ci_last_regenerate|i:1704371531;'),
('5113c44a91217ed5b27a7cab3cd807f93d141ee6','223.25.253.28',1704382108,'__ci_last_regenerate|i:1704382005;'),
('a3593eb36150dfe3723da3f60c84fb565c648d30','178.62.82.141',1704784533,'__ci_last_regenerate|i:1704784533;'),
('1d3b7a858fb6921c5c3d13c2b23d4a9ba5f45ca9','118.179.18.121',1704807367,'__ci_last_regenerate|i:1704807303;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('592017ec8c58e78f4942df7efcb59ab5aa911a60','118.179.18.121',1704807379,'__ci_last_regenerate|i:1704807379;'),
('8d27934234888e6f3543a466e6fe2bf4b1b06c2e','118.179.18.121',1704807379,'__ci_last_regenerate|i:1704807379;'),
('8828520e6d46703a2a78aa3cf593b2f894fef850','118.179.18.121',1704807422,'__ci_last_regenerate|i:1704807422;'),
('185b8abd487fff0a2fc7fe18dcf2e204d1f3454b','118.179.18.121',1704807491,'__ci_last_regenerate|i:1704807438;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('560f47e7af628680c90dc4e8d5e80ea20365d446','51.222.253.20',1704828865,'__ci_last_regenerate|i:1704828865;'),
('de793f33c38b1557e0a7e966b8797f5ffec9a69f','106.0.61.249',1704829649,'__ci_last_regenerate|i:1704829644;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('e79f52e638560ebaf38895715e9ca0af0199f15d','43.250.82.229',1704829648,'__ci_last_regenerate|i:1704829648;'),
('5e1dd983aad2b388094c73e94010716955d102eb','106.0.61.249',1704830462,'__ci_last_regenerate|i:1704830462;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('5aaaa444ebe8c0770b9b0b888b1b1c194397c075','106.0.61.249',1704831214,'__ci_last_regenerate|i:1704831214;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('08d32d10968472fdaa8fcde3a9178620f62eb697','106.0.61.249',1704831286,'__ci_last_regenerate|i:1704831214;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('181efee639a553263d5655158cec832c5485fa28','198.251.73.118',1704862002,'__ci_last_regenerate|i:1704862002;'),
('58614c16085e98a8eab379096faf9d622c437f29','34.148.255.74',1705151180,'__ci_last_regenerate|i:1705151180;'),
('bb704068ddf39b4e319d464cde514bf10b0aea36','34.148.255.74',1705151180,'__ci_last_regenerate|i:1705151180;'),
('6db0011ba2ecbac2cd32092966213c05db028503','34.73.193.88',1705167681,'__ci_last_regenerate|i:1705167681;'),
('bbf00c841189daf242f1cd9d613810cdcd767215','34.73.193.88',1705167681,'__ci_last_regenerate|i:1705167681;'),
('e131309337daa1e1110bdaf017b3fc63a4aa46e4','35.196.241.87',1705216004,'__ci_last_regenerate|i:1705216004;'),
('c9299182ca083a975e68b1360d0da91c09e174d5','35.196.241.87',1705216010,'__ci_last_regenerate|i:1705216004;'),
('c26a83b36a0d729423f9a6d71b1f4af2e3e515da','40.77.167.13',1705235643,'__ci_last_regenerate|i:1705235643;'),
('e8853c8c0fbe619c1adddee40ec34c6be94983ef','74.208.2.218',1705343248,'__ci_last_regenerate|i:1705343248;'),
('e4504c94185cc0fc783b897b234b46acd7b4f171','188.166.117.217',1705423970,'__ci_last_regenerate|i:1705423970;'),
('cd19e5ef6915a06df75e155317672779642fdc7d','15.152.31.37',1705436346,'__ci_last_regenerate|i:1705436346;'),
('ce3a96d56c476e8c021790b9c132bc60f5ddfde2','74.208.2.213',1705515389,'__ci_last_regenerate|i:1705515389;'),
('57e7fa4ab5676c31d72bc8f99801868ac3bc0d16','206.189.126.64',1705527609,'__ci_last_regenerate|i:1705527609;'),
('62420892109c195174bb75530c309bac72d4c4c6','188.166.55.143',1705535211,'__ci_last_regenerate|i:1705535211;'),
('7437df2365353ee66f6b9513deb0ec02d3172247','149.56.150.28',1705554857,'__ci_last_regenerate|i:1705554857;'),
('5b9d22028e501a8d44bef9182a43b0788fef56da','118.179.18.121',1705571515,'__ci_last_regenerate|i:1705571476;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('9e61e98630ecaf2b7400d8c48d87c2498e75d56b','216.244.66.198',1705660269,'__ci_last_regenerate|i:1705660269;'),
('907695f6db38a9b4fce1a4a44bb817bbdea765c1','118.179.18.121',1705727598,'__ci_last_regenerate|i:1705727597;'),
('8809277f6a04c3bcdc8ad9b20f70a65a35b5574a','118.179.18.121',1705735938,'__ci_last_regenerate|i:1705735899;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('79621cba72a7a84b97d486355145fb162e50149b','118.179.18.121',1705838057,'__ci_last_regenerate|i:1705838057;'),
('6e7d9244d27eeff3f9e64f5cd53914228fc13a2f','106.0.61.249',1705856718,'__ci_last_regenerate|i:1705856666;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('ed75004119609196166a2a1f30e247cd2b0bc17d','106.0.61.249',1705865105,'__ci_last_regenerate|i:1705865090;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('9111c9f2c5a765deaf35d09bb944ee78c4cbe200','106.0.61.249',1705940340,'__ci_last_regenerate|i:1705940333;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('1c98a89faa6f43df3d025d056a648085dd593d2f','106.0.61.249',1705948185,'__ci_last_regenerate|i:1705948153;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('fc476a9671ca143dabb8012e52afafa807dd1b66','223.25.253.6',1706003264,'__ci_last_regenerate|i:1706003242;'),
('7932736760a4f8d2eb6598184542be9b392dd4b1','35.196.88.159',1706026116,'__ci_last_regenerate|i:1706026115;'),
('b0f07b7cd1926e6cfc79d408470a402098433af3','35.196.88.159',1706026460,'__ci_last_regenerate|i:1706026459;'),
('0d5f6aff92615dabb42f54bd2cfdb8e4e0f29300','34.23.243.206',1706030729,'__ci_last_regenerate|i:1706030729;'),
('158238d127a9667b2f9f06e749783d7c02ace6bd','34.23.243.206',1706030729,'__ci_last_regenerate|i:1706030729;'),
('b5906a7607520fe9f99dfc497647c0da279b961e','106.0.61.249',1706049629,'__ci_last_regenerate|i:1706049409;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('9f16d11e25e475fe611ed168ae4170aac6a1ce2d','50.21.188.68',1706119034,'__ci_last_regenerate|i:1706119034;'),
('3da4ddbbe0054276abbf2675fb4b07e695561298','34.73.192.186',1706168487,'__ci_last_regenerate|i:1706168487;'),
('b0f78dbcc7bb2e1bc5f9a056ce3a33bd55c2af8d','34.73.192.186',1706168487,'__ci_last_regenerate|i:1706168487;'),
('d0d8e7641bfa76f81705ea7c482884ab283f543b','54.36.148.200',1706205710,'__ci_last_regenerate|i:1706205710;'),
('f56bc75dd34e648b8f130a0183a6428e9cb0eb80','34.73.225.110',1706212993,'__ci_last_regenerate|i:1706212993;'),
('393228e84ab80b6cc5a1e3ba67d9583db91d79ee','34.73.225.110',1706212993,'__ci_last_regenerate|i:1706212993;'),
('63217d63e5e0707c9aa6d1b3b01c038478f13dae','34.73.225.110',1706217265,'__ci_last_regenerate|i:1706217265;'),
('2cf88ac3263659154f7bdc8bc2a89de091af2a07','34.73.225.110',1706217265,'__ci_last_regenerate|i:1706217265;'),
('39f1136c2f981a3b9235d4fb7576191315517ebe','35.227.123.202',1706247166,'__ci_last_regenerate|i:1706247166;'),
('1111106efebeef83a743c3845b70b588769ea468','35.227.123.202',1706247166,'__ci_last_regenerate|i:1706247166;'),
('faadaeb41ce7d01d70adedf8192833cfdfc500dd','54.36.148.213',1706283089,'__ci_last_regenerate|i:1706283089;'),
('089b4a89b94e558602d1f708f5db81e45fb41e52','114.134.90.218',1706610119,'__ci_last_regenerate|i:1706610119;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('0095f09f82197740e29b73e7694e7ec03795aa66','114.134.90.218',1706610517,'__ci_last_regenerate|i:1706610517;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('8bbb5ce5bf296937da8d9bcd9dc84e8ed76de41d','114.134.90.218',1706611721,'__ci_last_regenerate|i:1706611721;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('c98044025c66139e1cfb26b90de807a3f1585ae6','114.134.90.218',1706612093,'__ci_last_regenerate|i:1706612093;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('76767be667c7802c2091285677f55aff4ef038e5','114.134.90.218',1706612517,'__ci_last_regenerate|i:1706612517;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('e46cf19c44ad97794aa291b2df0be5cba648eee8','114.134.90.218',1706612905,'__ci_last_regenerate|i:1706612905;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('6bd70e9439f53c853e35c9b112220a7ca77a038d','114.134.90.218',1706613224,'__ci_last_regenerate|i:1706613224;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('808dbb2a4a82a00ed43d070dc29669e97fe765af','114.134.90.218',1706613483,'__ci_last_regenerate|i:1706613224;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('b03a70ec09ecf983584311a1e68c7c31407c0cb9','118.179.18.121',1706615229,'__ci_last_regenerate|i:1706615228;'),
('e40a8cd077a1c7c0b79c99ff6323e7729bb7dbff','66.249.70.128',1706684403,'__ci_last_regenerate|i:1706684403;'),
('ae17a00587c17cd7edeacdd985e9005816ceddf9','66.249.70.141',1706684410,'__ci_last_regenerate|i:1706684410;'),
('f3b63d5e29aaa1692ed1332fefd253385c6ba951','118.179.18.121',1706705891,'__ci_last_regenerate|i:1706705798;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('c4d81ab345585ce806586b5fc00d16a1b799f63d','54.36.148.179',1706823545,'__ci_last_regenerate|i:1706823545;'),
('0094e9f3326aed691262059007cb4e26c7d11df2','103.167.16.179',1706829518,'__ci_last_regenerate|i:1706829518;'),
('efab23f0072ddd101b3c498bcf5d20c76f785d2b','103.167.16.179',1706829532,'__ci_last_regenerate|i:1706829532;'),
('cc9c9508a030b244f4cf393eb8d7305a9aa1ef0f','54.36.148.153',1706907545,'__ci_last_regenerate|i:1706907545;'),
('5488c623884e82132814dec1fb5ea554fd47b629','101.44.249.89',1707038157,'__ci_last_regenerate|i:1707038157;'),
('f47e0c78728d638c35dde2df6098cd2f84d0e70c','118.179.18.121',1707213708,'__ci_last_regenerate|i:1707213708;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";success|s:38:\"Deleted patients Info Successfully !!!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}'),
('b107ec6a4156b9f551e958a92c8e486676d55d16','118.179.18.121',1707214011,'__ci_last_regenerate|i:1707214011;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('a80c678c78110dabdd691006cf7e444eeb24de49','85.186.138.170',1707213871,'__ci_last_regenerate|i:1707213871;'),
('3a42edf090e8de5380f1b0e21153eba96cc06f47','118.179.18.121',1707214256,'__ci_last_regenerate|i:1707214011;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('2a530021af6ce8e6d47028f265264bcf2e5902a4','118.179.18.121',1707214296,'__ci_last_regenerate|i:1707214296;'),
('fe449352c5db85b995e6874a2ef1b122ef92ee6a','114.134.90.218',1707288875,'__ci_last_regenerate|i:1707288832;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";success|s:30:\"Password changed successfully!\";__ci_vars|a:1:{s:7:\"success\";s:3:\"old\";}'),
('eef396b06d5b7f20949ac323068612069ad77a56','185.98.61.25',1707506033,'__ci_last_regenerate|i:1707506033;'),
('f5a17dd70f819d8625e6f747d957776fd4ecc63e','34.138.123.33',1707572782,'__ci_last_regenerate|i:1707572782;'),
('5db5b6e12d151cb82d3f9d4f30d13b61d82e198c','34.138.123.33',1707572782,'__ci_last_regenerate|i:1707572782;'),
('d5cdd053927b33e0ee68927fbfc7672378b38178','34.148.30.220',1707591013,'__ci_last_regenerate|i:1707591013;'),
('a3462bbec8a72b90fb6b9f3030fb9810fdf138a8','34.148.30.220',1707591013,'__ci_last_regenerate|i:1707591013;'),
('632982f72ce14115715f787792b41d7e31cc68c4','146.70.174.147',1707595728,'__ci_last_regenerate|i:1707595728;'),
('942f24dc2a17e0d5aff64b4f1faad4ed53e38e53','35.237.201.178',1707603881,'__ci_last_regenerate|i:1707603881;'),
('963299326389c38fe9477d675d8815a4a46b6a28','35.243.245.34',1707613760,'__ci_last_regenerate|i:1707613760;'),
('2a28ed459db7d4b0029ed733cda92a2a70150ac5','35.243.245.34',1707613760,'__ci_last_regenerate|i:1707613760;'),
('60666aaa2f2b7aa0c87c9447cef93890198a4638','34.73.206.133',1707698380,'__ci_last_regenerate|i:1707698380;'),
('7d5d79cbe0fa1f73ff1fd38ce8f139e484153a8a','34.73.206.133',1707698380,'__ci_last_regenerate|i:1707698380;'),
('8f8e832c2b581a1899a9cddaca99c87c92871c08','85.208.96.204',1707771504,'__ci_last_regenerate|i:1707771504;'),
('c8a4253114a6a729961daa1ed65714fe13984cbc','185.191.171.13',1707782543,'__ci_last_regenerate|i:1707782543;'),
('552e55c60a5b7d96ddfd5e29420091134a986a15','54.36.148.77',1707833121,'__ci_last_regenerate|i:1707833121;'),
('31ba990d7227edf7af2892f38a48d6b0dd766895','85.208.96.196',1708009109,'__ci_last_regenerate|i:1708009109;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('2703927dae3952f60b8d53f8eb06a2c90426ef67','185.191.171.8',1708009111,'__ci_last_regenerate|i:1708009111;'),
('c44eea2ad721f6da25d90a2a3eebf2ad8e325bf7','185.191.171.18',1708024339,'__ci_last_regenerate|i:1708024339;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('589a3fb46b1b1f7c4a87f76910bba9829ea3248c','185.191.171.15',1708024341,'__ci_last_regenerate|i:1708024340;'),
('e296c565aea21edd7d02197e916755ee18227ff4','52.78.108.114',1708041767,'__ci_last_regenerate|i:1708041767;'),
('162240366ab51c696ffa113d07fe59915d28a093','149.56.150.168',1708146982,'__ci_last_regenerate|i:1708146982;'),
('6933bbbc4816539e1688c24124b5ec91ef3308bc','35.84.193.96',1708147609,'__ci_last_regenerate|i:1708147609;'),
('4397e2833aa99a5900e82a544f4adb5528eb83c2','118.179.18.121',1708184548,'__ci_last_regenerate|i:1708184548;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:6:\"Dental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('1d1a41adc379b04c0ece8db201dbb135f2775d31','118.179.18.121',1708184549,'__ci_last_regenerate|i:1708184548;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:6:\"Dental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('67ebfbbef0d5c94a6fa846f57f253c967f660edd','118.179.18.121',1708184593,'__ci_last_regenerate|i:1708184593;'),
('a9050219e34b4a23c2605ff0ab7f8046890b5f86','118.179.18.121',1708251502,'__ci_last_regenerate|i:1708251500;'),
('a11df12b73ab7b036f797509fc69783edd3c99c1','40.77.167.23',1708265694,'__ci_last_regenerate|i:1708265694;'),
('46369a6cf4afde88694ce4d0d8abc9cba0250795','35.237.113.230',1708334766,'__ci_last_regenerate|i:1708334766;'),
('c145a81f37110fea4fa7edd0c17372997a9c27b5','35.237.113.230',1708334766,'__ci_last_regenerate|i:1708334766;'),
('3e01a559e4ac16ee10b7f80ba466bc865c4ab771','146.190.166.9',1708667884,'__ci_last_regenerate|i:1708667884;'),
('e0c75965ec34fc428c7ba3f21e0f20eb026b0c67','54.36.148.132',1708915997,'__ci_last_regenerate|i:1708915997;'),
('e2ad96c285af66ea54ed5522be2ab8235bb485f8','54.36.148.61',1709867134,'__ci_last_regenerate|i:1709867133;'),
('8d0af22e818aa1dc9df383e5b36fc27466e7fcf6','118.179.18.121',1710533826,'__ci_last_regenerate|i:1710533826;'),
('a744e8ff532df8c2a1e80ec371942def205f9455','103.167.16.177',1710534174,'__ci_last_regenerate|i:1710534174;'),
('d6353cc3621318e637cf1eae8ec50a72ba346c23','103.167.16.177',1710534266,'__ci_last_regenerate|i:1710534266;'),
('3bf4534360e71e9e705e6c848108b9da3c3f4761','103.167.16.177',1710534312,'__ci_last_regenerate|i:1710534312;'),
('dc39dabab73469a4c6231f21d89f656eae2d2bfd','85.208.96.210',1710779237,'__ci_last_regenerate|i:1710779237;'),
('7b78c8aef204b7308b738ce97595f55b12fdaf31','103.165.162.204',1717168230,'__ci_last_regenerate|i:1717168149;'),
('32182f347368d5656241f60f60652997633f5c79','103.133.78.51',1719432181,'__ci_last_regenerate|i:1719432181;'),
('a06a79c05a6e1493b11b96313b5658e3fffe27b1','103.133.78.51',1719432281,'__ci_last_regenerate|i:1719432197;'),
('bf9442a079b55f5c6df54805cd5a5880661811be','103.133.78.51',1719432313,'__ci_last_regenerate|i:1719432296;'),
('10d5ca9b44b224f266a58544b7a2007de708370a','103.133.78.51',1719596106,'__ci_last_regenerate|i:1719596106;'),
('8fa8a637ec91498be075565aaf47a25d53d4ebd2','52.167.144.22',1743684077,'__ci_last_regenerate|i:1743684077;'),
('g05nug92i9h20fvl8pjo1fpn04h3k4lh','207.46.13.92',1763358922,'__ci_last_regenerate|i:1763358922;'),
('92jb52eptujt3lo4dlp522ikv26d90gj','207.46.13.17',1763444890,'__ci_last_regenerate|i:1763444890;');
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test`
--

DROP TABLE IF EXISTS `test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testName` varchar(200) NOT NULL,
  `fee` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test`
--

LOCK TABLES `test` WRITE;
/*!40000 ALTER TABLE `test` DISABLE KEYS */;
INSERT INTO `test` (`id`, `testName`, `fee`) VALUES (1,'CBC',500),
(2,'Urin RME',400),
(3,'ECB',1500),
(4,'RCT',3500),
(5,'EXT',1500),
(6,'Scaking',1500),
(7,'X-ray',1200),
(8,'RCT',4000),
(9,'CROWN',4000),
(10,'EXT',1000);
/*!40000 ALTER TABLE `test` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_bill`
--

DROP TABLE IF EXISTS `test_bill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `bill_date` date NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `grand_total` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_bill`
--

LOCK TABLES `test_bill` WRITE;
/*!40000 ALTER TABLE `test_bill` DISABLE KEYS */;
INSERT INTO `test_bill` (`id`, `bill_id`, `patient_id`, `bill_date`, `sub_total`, `discount`, `grand_total`, `net_total`, `due_amount`, `paid_amount`, `note`, `prepared_by`) VALUES (3,'T10003',25,'2023-11-21',8500.00,500.00,NULL,8000.00,0.00,8000.00,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `test_bill` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_bill_item`
--

DROP TABLE IF EXISTS `test_bill_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_bill_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `invoice_date` date NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_bill_item`
--

LOCK TABLES `test_bill_item` WRITE;
/*!40000 ALTER TABLE `test_bill_item` DISABLE KEYS */;
INSERT INTO `test_bill_item` (`id`, `invoice_id`, `invoice_date`, `test_id`, `price`, `quantity`, `total_price`) VALUES (14,'3 ','1970-01-01',9,4000.00,1.00,4000.00),
(15,'3 ','1970-01-01',10,1000.00,1.00,1000.00),
(16,'3 ','1970-01-01',4,3500.00,1.00,3500.00);
/*!40000 ALTER TABLE `test_bill_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(100) DEFAULT NULL,
  `name` varchar(111) NOT NULL,
  `password` text NOT NULL,
  `role` enum('reception','doctor','super_admin','admin') NOT NULL,
  `status` enum('active','inactive') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `fullname`, `name`, `password`, `role`, `status`) VALUES (4,'Ashiqe','user123','63a5794dc2ec6ae1a50655bf5359c71b780de9a6b013505a9711e5a085f885dfc7e69086d80b3a48f0e98628444a2c70dd2d86242e7d6c05c7b5100ea631f031','reception','active'),
(5,'Ashiqe','doctor123','81f124a4a840d50c0ea9bd677741108990e31002d9b45039b474b8fc2b3dde035981988779904811b41a2dc06872d8a1e801a1c50049123b594178eb01b8dae9','doctor','active'),
(6,'Dhaka Dental','Dental','ba3253876aed6bc22d4a6ff53d8406c6ad864195ed144ab5c87621b6c233b548baeae6956df346ec8c17f5ea10f35ee3cbc514797ed7ddd3145464e2a0bab413','super_admin','active');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'amrmemo_dentaldemo'
--

--
-- Dumping routines for database 'amrmemo_dentaldemo'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-07 18:13:12
