/*M!999999\- enable the sandbox mode */ 
-- MariaDB dump 10.19  Distrib 10.11.15-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: amrmemo_dental
-- ------------------------------------------------------
-- Server version	10.11.15-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Current Database: `amrmemo_dental`
--


--
-- Table structure for table `additional_advice`
--

DROP TABLE IF EXISTS `additional_advice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `additional_advice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `additional_advice`
--

LOCK TABLES `additional_advice` WRITE;
/*!40000 ALTER TABLE `additional_advice` DISABLE KEYS */;
INSERT INTO `additional_advice` (`id`, `name`) VALUES (2,'Advice 2'),
(3,'Advice 3');
/*!40000 ALTER TABLE `additional_advice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `app_config`
--

DROP TABLE IF EXISTS `app_config`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `app_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyName` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `address` varchar(222) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `phone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `email` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `telephone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `logo` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `print` varchar(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_config`
--

LOCK TABLES `app_config` WRITE;
/*!40000 ALTER TABLE `app_config` DISABLE KEYS */;
INSERT INTO `app_config` (`id`, `companyName`, `address`, `phone`, `email`, `telephone`, `logo`, `print`) VALUES (1,'Dhaka Dental Clinic','71/2 Hussaini Dalan Road, Chankharpul, Dhaka 1211.','+8801713292958','dhakadentalclinicoffice@gmail.com','+8801845008572','24e70bf5aca74c26a611440280b8abfc.png','1');
/*!40000 ALTER TABLE `app_config` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `appointment_fee`
--

DROP TABLE IF EXISTS `appointment_fee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `appointment_fee` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `appointment_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `appointment_date` date NOT NULL,
  `appointment_fee` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `appointment_fee`
--

LOCK TABLES `appointment_fee` WRITE;
/*!40000 ALTER TABLE `appointment_fee` DISABLE KEYS */;
INSERT INTO `appointment_fee` (`id`, `appointment_id`, `patient_id`, `doctor_id`, `appointment_date`, `appointment_fee`, `discount`, `net_total`, `due_amount`, `paid_amount`, `prepared_by`) VALUES (22,'A10018',21,10,'2025-01-28',500.00,150.00,350.00,NULL,NULL,'Dhaka Dental'),
(23,'A10019',31,9,'2025-01-28',1000.00,1000.00,0.00,NULL,NULL,'Dhaka Dental'),
(24,'A10020',32,10,'2025-01-30',500.00,300.00,200.00,NULL,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `appointment_fee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `chief_complaints`
--

DROP TABLE IF EXISTS `chief_complaints`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `chief_complaints` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `chief_complaints`
--

LOCK TABLES `chief_complaints` WRITE;
/*!40000 ALTER TABLE `chief_complaints` DISABLE KEYS */;
INSERT INTO `chief_complaints` (`id`, `name`) VALUES (2,'Anaemia'),
(3,'COPD'),
(4,'HTN '),
(5,'DM'),
(6,'Stroke'),
(7,'HTN'),
(8,'DM Diabates'),
(9,'EPI Lapsy'),
(10,'C/A');
/*!40000 ALTER TABLE `chief_complaints` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `doctors`
--

DROP TABLE IF EXISTS `doctors`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `doctors` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `phone` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `serialcontactNo` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `educationDegree` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `specialist` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `visitingHours` varchar(100) DEFAULT NULL,
  `address` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `hospitalName` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `photo` varchar(50) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `appointment_fee` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `doctors`
--

LOCK TABLES `doctors` WRITE;
/*!40000 ALTER TABLE `doctors` DISABLE KEYS */;
INSERT INTO `doctors` (`id`, `name`, `phone`, `serialcontactNo`, `educationDegree`, `specialist`, `visitingHours`, `address`, `hospitalName`, `photo`, `appointment_fee`) VALUES (2,'PROF. DR. KHAN ABUL KALAM AZAD','12345678900','12345678900','MBBS (DMC), FCPS (Medicine), MD (Internal Med.), FACP (USA). Dhaka Medical College & Hospital.','Medicine','Sunday, Monday, Tuesday, Wednesday, Thursday, Saturday','Dhaka','MBBS','74226a7ea70a96d45af9c168964a587d.jpg',700),
(6,'Mr. Amirul Islam','01713292958','01845008572','Diploma in Dental','Dentist ','10 AM to 9 PM','Dhaka, bangladesh','Dhaka Medical College','a3610ff7237b272720d7570b92cc7159.png',600),
(9,'Dr. S M Shahed Ul Islam','01713292958','','BDS, PGT (Dhaka Dental College), Ex-Senior Doctor,','Oral and Dental Surgeon, Ramakrishna Mission Medical Service Center,  BMDC Reg. NO: 947','10 AM to 1 PM','','Dhaka Dental Clinic','e11b4877f1038e0e7adc95fb3657cea8.jpg',1000),
(10,'Dr. Taslima Akter (Happy)','01912345678','01912345678','BDS (DU), PGT (OMS)','Dhaka Medical College and Hospital, Oral and Dental Surgeon, BMDC, Reg: 11985','10 AM to 1 PM','Dhaka, Bangladesh','Dhaka Medical College and Hospital','',500);
/*!40000 ALTER TABLE `doctors` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drprescription`
--

DROP TABLE IF EXISTS `drprescription`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `drprescription` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` varchar(20) NOT NULL,
  `doctor_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `date` date NOT NULL,
  `pain` varchar(10) DEFAULT NULL,
  `nextdate` text DEFAULT NULL,
  `gum_bleeding` varchar(50) DEFAULT NULL,
  `bad_odour` varchar(50) DEFAULT NULL,
  `cavity` varchar(50) DEFAULT NULL,
  `ref` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drprescription`
--

LOCK TABLES `drprescription` WRITE;
/*!40000 ALTER TABLE `drprescription` DISABLE KEYS */;
INSERT INTO `drprescription` (`id`, `pid`, `doctor_id`, `patient_id`, `date`, `pain`, `nextdate`, `gum_bleeding`, `bad_odour`, `cavity`, `ref`) VALUES (4,'202311002',0,19,'2023-11-16','4,1',NULL,'','','',NULL),
(11,'202410001',0,27,'2024-10-28','','2024-10-28','Gum Bleeding','Bad Odour',NULL,'Alif'),
(12,'202412001',0,19,'2024-12-17','','2024-12-17',NULL,NULL,'Cavity',''),
(15,'202412004',0,21,'2024-12-28','5,3','2024-12-28','Gum Bleeding','Bad Odour','Cavity',''),
(23,'202501001',0,21,'2025-01-28','','2025-01-28','Gum Bleeding','Bad Odour','Cavity',''),
(24,'202501002',0,31,'2025-01-28','','2025-01-28','Gum Bleeding','Bad Odour','Cavity',''),
(25,'202501003',0,32,'2025-01-28','','2025-01-28','Gum Bleeding','Bad Odour',NULL,'');
/*!40000 ALTER TABLE `drprescription` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dues`
--

DROP TABLE IF EXISTS `dues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dues` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `first_payment` decimal(15,2) NOT NULL,
  `payment_date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dues`
--

LOCK TABLES `dues` WRITE;
/*!40000 ALTER TABLE `dues` DISABLE KEYS */;
/*!40000 ALTER TABLE `dues` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `feeding`
--

DROP TABLE IF EXISTS `feeding`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `feeding` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  `count` varchar(22) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `feeding`
--

LOCK TABLES `feeding` WRITE;
/*!40000 ALTER TABLE `feeding` DISABLE KEYS */;
INSERT INTO `feeding` (`id`, `name`, `count`) VALUES (1,'1+1+1 Before Meal','3'),
(2,'1+0+1 After Meal','2'),
(3,'0+1+0 Before Meal','1'),
(4,'দুপুরের খাবারের পরে ',''),
(5,'খাবারের আগে ','');
/*!40000 ALTER TABLE `feeding` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `history_of`
--

DROP TABLE IF EXISTS `history_of`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `history_of` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `history_of`
--

LOCK TABLES `history_of` WRITE;
/*!40000 ALTER TABLE `history_of` DISABLE KEYS */;
INSERT INTO `history_of` (`id`, `name`) VALUES (1,'History Of 2'),
(2,'History '),
(3,'History  3'),
(4,'DM'),
(5,'Hepatitis'),
(6,'HTN'),
(7,'Clopid'),
(8,'Ecosprin'),
(9,'Clopid'),
(10,'Clopid Plus'),
(11,'Metfo'),
(12,'Linatab');
/*!40000 ALTER TABLE `history_of` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `investigation`
--

DROP TABLE IF EXISTS `investigation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `investigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `investigation`
--

LOCK TABLES `investigation` WRITE;
/*!40000 ALTER TABLE `investigation` DISABLE KEYS */;
INSERT INTO `investigation` (`id`, `name`) VALUES (2,'X-ray OPG'),
(3,'IOPA'),
(4,'SGPT'),
(5,'Creatinine'),
(6,'RBS');
/*!40000 ALTER TABLE `investigation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoice`
--

DROP TABLE IF EXISTS `invoice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `invoice_date` date NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `grand_total` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoice`
--

LOCK TABLES `invoice` WRITE;
/*!40000 ALTER TABLE `invoice` DISABLE KEYS */;
INSERT INTO `invoice` (`id`, `invoice_id`, `patient_id`, `invoice_date`, `sub_total`, `discount`, `grand_total`, `net_total`, `due_amount`, `paid_amount`, `note`, `prepared_by`) VALUES (2,'M10002',21,'2023-11-18',23.00,10.00,NULL,12.00,0.00,12.00,NULL,'Dhaka Dental'),
(3,'M10003',22,'2023-11-18',675.00,0.00,NULL,675.00,675.00,0.00,NULL,'Dhaka Dental'),
(4,'M10004',25,'2023-11-21',85.00,0.00,NULL,85.00,85.00,0.00,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `invoice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `invoiced_item`
--

DROP TABLE IF EXISTS `invoiced_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoiced_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `invoice_date` date NOT NULL,
  `medicine_id` int(11) NOT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `unit` varchar(30) DEFAULT NULL,
  `price` float(10,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `invoiced_item`
--

LOCK TABLES `invoiced_item` WRITE;
/*!40000 ALTER TABLE `invoiced_item` DISABLE KEYS */;
INSERT INTO `invoiced_item` (`id`, `invoice_id`, `invoice_date`, `medicine_id`, `quantity`, `unit`, `price`, `total_price`) VALUES (10,'2','2023-11-18',1,1.00,NULL,2.00,2.00),
(11,'2','2023-11-18',2,1.00,NULL,8.00,8.00),
(12,'2','2023-11-18',3,1.00,NULL,3.00,3.00),
(13,'2','2023-11-18',5,1.00,NULL,8.00,8.00),
(14,'2','2023-11-18',6,1.00,NULL,2.00,2.00),
(15,'3','2023-11-18',8,10.00,NULL,35.00,350.00),
(16,'3','2023-11-18',9,10.00,NULL,20.00,200.00),
(17,'3','2023-11-18',7,5.00,NULL,7.00,35.00),
(18,'3','2023-11-18',5,10.00,NULL,8.00,80.00),
(19,'3','2023-11-18',1,5.00,NULL,2.00,10.00),
(20,'4','2023-11-21',1,20.00,NULL,2.00,40.00),
(21,'4','2023-11-21',3,15.00,NULL,3.00,45.00);
/*!40000 ALTER TABLE `invoiced_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `medicines`
--

DROP TABLE IF EXISTS `medicines`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `medicines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  `supplier` varchar(222) DEFAULT NULL,
  `category` varchar(222) DEFAULT NULL,
  `price` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `medicines`
--

LOCK TABLES `medicines` WRITE;
/*!40000 ALTER TABLE `medicines` DISABLE KEYS */;
INSERT INTO `medicines` (`id`, `name`, `supplier`, `category`, `price`) VALUES (1,'Tab. Napa 500mg','Beximco Pharmaceuticals Ltd','Paracetamol',2),
(2,'Tab. Sergel 20mg','Healthcare Pharmaceuticals Ltd','Esomeprazole Magnesium Trihydrate',8),
(3,'Tab. Alatrol 10mg','Square Pharmaceuticals PLC','Cetirizine Dihydrochloride',3),
(4,'Tab. Monas 10mg','The ACME Laboratories Ltd.','Montelukast',17),
(5,'Tab. Fexofast 120mg','Drug International Ltd.','Fexofenadine Hydrochloride',8),
(6,'Sivit','Square Pharmaceuticals LTD.','Cetirizine Dihydrochloride',2),
(8,'CEF -3','SQUARE','CEFIXGIME',35),
(9,'VASCO','INCEPTA','ASCORVIC ACID',20);
/*!40000 ALTER TABLE `medicines` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `on_examination`
--

DROP TABLE IF EXISTS `on_examination`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `on_examination` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(222) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `on_examination`
--

LOCK TABLES `on_examination` WRITE;
/*!40000 ALTER TABLE `on_examination` DISABLE KEYS */;
INSERT INTO `on_examination` (`id`, `name`) VALUES (1,'On Examination (O/E)'),
(2,'Pericoronitis'),
(3,'Carrise'),
(4,'Pulpitis'),
(5,'Swelling');
/*!40000 ALTER TABLE `on_examination` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_advice`
--

DROP TABLE IF EXISTS `patient_advice`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_advice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `advice_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_advice`
--

LOCK TABLES `patient_advice` WRITE;
/*!40000 ALTER TABLE `patient_advice` DISABLE KEYS */;
INSERT INTO `patient_advice` (`id`, `prescription_id`, `patient_id`, `advice_id`, `date`) VALUES (14,11,27,0,'2024-10-28'),
(15,12,19,0,'2024-12-17'),
(18,15,21,0,'2024-12-28'),
(26,23,21,0,'2025-01-28'),
(27,24,31,0,'2025-01-28'),
(28,25,32,0,'2025-01-28');
/*!40000 ALTER TABLE `patient_advice` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_cc`
--

DROP TABLE IF EXISTS `patient_cc`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_cc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `cc_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_cc`
--

LOCK TABLES `patient_cc` WRITE;
/*!40000 ALTER TABLE `patient_cc` DISABLE KEYS */;
INSERT INTO `patient_cc` (`id`, `prescription_id`, `patient_id`, `cc_id`, `date`) VALUES (18,15,21,4,'2024-12-28'),
(31,23,21,5,'2025-01-28'),
(32,24,31,2,'2025-01-28'),
(33,24,31,5,'2025-01-28'),
(34,25,32,4,'2025-01-28'),
(35,25,32,5,'2025-01-28');
/*!40000 ALTER TABLE `patient_cc` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_ho`
--

DROP TABLE IF EXISTS `patient_ho`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_ho` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `ho_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_ho`
--

LOCK TABLES `patient_ho` WRITE;
/*!40000 ALTER TABLE `patient_ho` DISABLE KEYS */;
INSERT INTO `patient_ho` (`id`, `prescription_id`, `patient_id`, `ho_id`, `date`) VALUES (2,4,19,2,'2023-11-16'),
(25,15,21,4,'2024-12-28'),
(26,15,21,7,'2024-12-28'),
(27,15,21,8,'2024-12-28'),
(40,23,21,2,'2025-01-28'),
(41,23,21,5,'2025-01-28'),
(42,23,21,7,'2025-01-28'),
(43,24,31,4,'2025-01-28'),
(44,24,31,5,'2025-01-28'),
(45,25,32,8,'2025-01-28');
/*!40000 ALTER TABLE `patient_ho` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_investigation`
--

DROP TABLE IF EXISTS `patient_investigation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_investigation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `investigation_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_investigation`
--

LOCK TABLES `patient_investigation` WRITE;
/*!40000 ALTER TABLE `patient_investigation` DISABLE KEYS */;
INSERT INTO `patient_investigation` (`id`, `prescription_id`, `patient_id`, `investigation_id`, `date`) VALUES (1,1,16,1,'2023-11-09'),
(3,2,17,1,'2023-11-12'),
(4,5,20,2,'2023-11-16'),
(5,7,24,2,'2023-11-21'),
(9,8,24,2,'2023-11-21'),
(11,9,25,2,'2023-11-21'),
(12,11,27,2,'2024-10-28'),
(13,12,19,2,'2024-12-17'),
(14,13,22,2,'2024-12-17'),
(15,14,29,4,'2024-12-26'),
(16,15,21,4,'2024-12-28'),
(17,15,21,5,'2024-12-28'),
(18,16,22,2,'2025-01-11'),
(19,17,19,2,'2025-01-18'),
(20,18,30,2,'2025-01-18'),
(21,19,22,2,'2025-01-19'),
(22,19,22,4,'2025-01-19'),
(23,19,22,5,'2025-01-19'),
(24,20,24,2,'2025-01-20'),
(25,21,24,2,'2025-01-23'),
(26,22,25,2,'2025-01-24'),
(27,22,25,3,'2025-01-24'),
(28,22,25,4,'2025-01-24'),
(29,22,25,5,'2025-01-24'),
(30,22,25,6,'2025-01-24'),
(31,23,21,2,'2025-01-28'),
(32,23,21,3,'2025-01-28'),
(33,23,21,4,'2025-01-28'),
(34,24,31,2,'2025-01-28'),
(35,24,31,3,'2025-01-28'),
(36,25,32,2,'2025-01-28');
/*!40000 ALTER TABLE `patient_investigation` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_medicine`
--

DROP TABLE IF EXISTS `patient_medicine`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_medicine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `medicine_id` int(11) NOT NULL,
  `feed_rules_id` int(11) NOT NULL,
  `feeddays_id` varchar(200) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_medicine`
--

LOCK TABLES `patient_medicine` WRITE;
/*!40000 ALTER TABLE `patient_medicine` DISABLE KEYS */;
INSERT INTO `patient_medicine` (`id`, `prescription_id`, `patient_id`, `medicine_id`, `feed_rules_id`, `feeddays_id`, `date`) VALUES (8,4,19,1,3,'7 Days','2023-11-16'),
(9,4,19,0,0,'7 Days','2023-11-16'),
(10,4,19,7,0,'7 Days','2023-11-16'),
(26,11,27,1,2,'3 Days','2024-10-28'),
(27,11,27,2,3,'7 Days','2024-10-28'),
(31,15,21,1,1,'7 Days','2024-12-28'),
(44,23,21,2,3,'7 Days','2025-01-28'),
(45,23,21,2,3,'7 Days','2025-01-28'),
(46,23,21,2,3,'7 Days','2025-01-28'),
(47,24,31,1,1,'7 Days','2025-01-28'),
(48,24,31,1,1,'7 Days','2025-01-28'),
(49,25,32,1,2,'3 Days','2025-01-28'),
(50,25,32,2,2,'3 Days','2025-01-28'),
(51,25,32,4,2,'3 Days','2025-01-28');
/*!40000 ALTER TABLE `patient_medicine` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_oe`
--

DROP TABLE IF EXISTS `patient_oe`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_oe` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `oe_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_oe`
--

LOCK TABLES `patient_oe` WRITE;
/*!40000 ALTER TABLE `patient_oe` DISABLE KEYS */;
INSERT INTO `patient_oe` (`id`, `prescription_id`, `patient_id`, `oe_id`, `date`) VALUES (12,11,27,1,'2024-10-28'),
(14,15,21,2,'2024-12-28'),
(25,23,21,2,'2025-01-28'),
(26,23,21,3,'2025-01-28'),
(27,23,21,4,'2025-01-28'),
(28,24,31,1,'2025-01-28'),
(29,24,31,2,'2025-01-28'),
(30,25,32,4,'2025-01-28'),
(31,25,32,5,'2025-01-28');
/*!40000 ALTER TABLE `patient_oe` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patient_test`
--

DROP TABLE IF EXISTS `patient_test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patient_test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prescription_id` int(11) NOT NULL,
  `patient_id` int(11) NOT NULL,
  `test_id` int(11) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patient_test`
--

LOCK TABLES `patient_test` WRITE;
/*!40000 ALTER TABLE `patient_test` DISABLE KEYS */;
INSERT INTO `patient_test` (`id`, `prescription_id`, `patient_id`, `test_id`, `date`) VALUES (26,12,19,8,'2024-12-17'),
(30,15,21,3,'2024-12-28'),
(31,15,21,4,'2024-12-28'),
(32,15,21,5,'2024-12-28'),
(33,15,21,6,'2024-12-28'),
(52,23,21,4,'2025-01-28'),
(53,24,31,3,'2025-01-28'),
(54,24,31,5,'2025-01-28'),
(55,24,31,6,'2025-01-28'),
(56,25,32,4,'2025-01-28'),
(57,25,32,5,'2025-01-28'),
(58,25,32,6,'2025-01-28'),
(59,25,32,9,'2025-01-28');
/*!40000 ALTER TABLE `patient_test` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patients`
--

DROP TABLE IF EXISTS `patients`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `idnumber` varchar(20) NOT NULL,
  `doctor_id` int(11) DEFAULT NULL,
  `name` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `gender` varchar(10) NOT NULL,
  `phone` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `age` varchar(5) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `prepared_by` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patients`
--

LOCK TABLES `patients` WRITE;
/*!40000 ALTER TABLE `patients` DISABLE KEYS */;
INSERT INTO `patients` (`id`, `idnumber`, `doctor_id`, `name`, `gender`, `phone`, `age`, `address`, `create_date`, `prepared_by`) VALUES (19,'P10002',9,'Mr Lablu','Male','01917778898111','35','Dhaka Bangladesh','2023-11-16 15:29:26','Dhaka Dental'),
(21,'P10004',10,'AFRINA','Female','017136562','26','MADARIPUR.ULLAPARA.SIRAJGANJ','2025-01-27 20:17:21','Dhaka Dental'),
(31,'P10005',9,'Tamim','Male','01713292958','25','','2025-01-28 11:28:54','Dhaka Dental'),
(32,'P10006',10,'vanna','Male','01472727371','32','xzc','2025-01-28 12:46:25','Dhaka Dental');
/*!40000 ALTER TABLE `patients` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patients_documents`
--

DROP TABLE IF EXISTS `patients_documents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `patients_documents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `patient_id` int(11) NOT NULL,
  `type` varchar(30) NOT NULL,
  `documents` varchar(50) NOT NULL,
  `create_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patients_documents`
--

LOCK TABLES `patients_documents` WRITE;
/*!40000 ALTER TABLE `patients_documents` DISABLE KEYS */;
INSERT INTO `patients_documents` (`id`, `patient_id`, `type`, `documents`, `create_date`) VALUES (1,4,'Report','5caa5d8ba206af762a4b887029cc3b40.pdf','2023-09-26 09:05:13'),
(2,4,'others','d300cffbf4c697405b67c05f54b8d437.jpg','2023-09-27 10:29:56'),
(3,4,'Report','f5967cf2ec097be07c76ce2755507a0a.jpg','2023-09-27 10:30:09'),
(4,9,'Report','2d016c2e8af1dccf8b06e4a843f83997.jfif','2023-10-11 07:00:08');
/*!40000 ALTER TABLE `patients_documents` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(40) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `timestamp` int(10) unsigned NOT NULL DEFAULT 0,
  `data` blob NOT NULL,
  KEY `ci_sessions_timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
INSERT INTO `sessions` (`id`, `ip_address`, `timestamp`, `data`) VALUES ('s1eskk3u2865b5ln9k37m43s2ak6ohf7','106.0.61.17',1755950139,'__ci_last_regenerate|i:1755950132;fullname|s:12:\"Dhaka Dental\";abhinvoiser_1_1_user_id|s:1:\"6\";abhinvoiser_1_1_user_name|s:11:\"DhakaDental\";abhinvoiser_1_1_role|s:11:\"super_admin\";'),
('d0c7o8p3apolbtmvll1rh646sc7981gq','5.39.109.176',1756231273,'__ci_last_regenerate|i:1756231273;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('8o3i9mjei96odqf6tn6epqecef901upj','94.23.188.205',1756308810,'__ci_last_regenerate|i:1756308810;'),
('7qedmhcrqhc59ms3lm2b3fhdgpikucb3','66.249.79.226',1756810890,'__ci_last_regenerate|i:1756810890;'),
('3jq46ao8kokqjvarr45i8c5g6efac91q','66.249.79.226',1756810891,'__ci_last_regenerate|i:1756810891;'),
('qfau1brh0ilcdnmu589pvdgguu8ri505','5.39.109.191',1757102937,'__ci_last_regenerate|i:1757102937;'),
('vugtn3jr9olt7qr2sp30hi4kq3k5j14v','40.77.167.45',1757493377,'__ci_last_regenerate|i:1757493377;'),
('uv3vn893je3fai1pbfso97hvco89ogld','54.37.118.79',1757874405,'__ci_last_regenerate|i:1757874405;'),
('q3qhbjlr8jb2fiv8pkr2dlss8sde53ru','92.222.108.123',1757878988,'__ci_last_regenerate|i:1757878988;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('al1drjp00af32mnkr76ibkldih5bfloe','207.46.13.107',1758078149,'__ci_last_regenerate|i:1758078148;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"old\";}'),
('dacic3brtj5sratpv2e1pr45camafo8k','92.222.104.205',1758601713,'__ci_last_regenerate|i:1758601713;'),
('ugg2s7gjbn1243cgeqiv7935hk5oqehm','216.244.66.198',1759015240,'__ci_last_regenerate|i:1759015240;'),
('edudsgbhbbuf0mej3rtugfm158bqkcuf','54.39.89.149',1759332604,'__ci_last_regenerate|i:1759332604;'),
('n3t8jqudlvkmpve5pd0bcsd01m8s159i','92.222.104.207',1759413275,'__ci_last_regenerate|i:1759413275;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('6asu81fgnbesttr86jns6kp5kdjdv2g5','103.37.184.190',1759835717,'__ci_last_regenerate|i:1759835716;'),
('5sc7njgjhuj6iskabhccjekgaekadmlb','51.68.247.214',1760044608,'__ci_last_regenerate|i:1760044608;'),
('tbgu6rub6pt7jtob66b1a530oq17j1io','37.59.204.148',1760771630,'__ci_last_regenerate|i:1760771630;'),
('jln52mvadiku3h6vq9u2fgrk88u5tuv9','51.75.236.135',1760885275,'__ci_last_regenerate|i:1760885275;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('r7lpnf010lalkg344l3t9upjf2rrasts','37.59.204.131',1761474879,'__ci_last_regenerate|i:1761474879;'),
('jo7dmpoatka4p8cqa2nkd5slebkp3btp','5.39.1.251',1761483343,'__ci_last_regenerate|i:1761483343;'),
('9efo1k401df3fe2p5g53a2clq5vuv8ga','5.39.109.169',1761492144,'__ci_last_regenerate|i:1761492144;'),
('as39nsav49gal9ou722g027ohi9kt69q','103.80.2.157',1761847192,'__ci_last_regenerate|i:1761847192;'),
('j5v9u12rshmgrhakojbapa532489pr3c','51.75.236.159',1762195458,'__ci_last_regenerate|i:1762195458;'),
('e2k6qfq3qbgcbsgeuvqmq908absbjndv','5.39.1.230',1762339763,'__ci_last_regenerate|i:1762339763;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('cu56invcnl9rgjvo1gjjb2df185c70me','54.37.118.67',1762889582,'__ci_last_regenerate|i:1762889582;'),
('ijbdnfl407mctbka0ttq1g77so3u9hgs','54.37.118.76',1763580005,'__ci_last_regenerate|i:1763580005;'),
('15sae9qs05l79kpl463ch9tbi10dh3s5','54.37.118.72',1763809030,'__ci_last_regenerate|i:1763809030;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('skc7b0m8dp95ug7m0sqmifeg1k8m69bf','54.37.118.68',1763826530,'__ci_last_regenerate|i:1763826530;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('6vgonle5jn96hmc52qus7fmehckd36da','54.37.118.79',1763879273,'__ci_last_regenerate|i:1763879273;exception|s:28:\"User Email/Password Invalid!\";__ci_vars|a:1:{s:9:\"exception\";s:3:\"new\";}'),
('l5duga1kllcsrkc4ilmc5j827fu32apk','37.59.204.154',1764289029,'__ci_last_regenerate|i:1764289028;'),
('vqhuuknqi5oicj4rjkms7luo1btm24dd','94.23.188.211',1764340956,'__ci_last_regenerate|i:1764340956;'),
('9sn5ivrd50q33ra3647do2vhtaeif1gp','176.31.139.19',1765026199,'__ci_last_regenerate|i:1765026199;');
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test`
--

DROP TABLE IF EXISTS `test`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `testName` varchar(200) NOT NULL,
  `fee` float DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test`
--

LOCK TABLES `test` WRITE;
/*!40000 ALTER TABLE `test` DISABLE KEYS */;
INSERT INTO `test` (`id`, `testName`, `fee`) VALUES (1,'CBC',500),
(2,'Urin RME',400),
(3,'ECB',1500),
(4,'RCT',3500),
(5,'EXT',1500),
(6,'Scaling',1500),
(7,'X-ray',1200),
(8,'RCT',4000),
(9,'CROWN',4000),
(10,'EXT',1000);
/*!40000 ALTER TABLE `test` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_bill`
--

DROP TABLE IF EXISTS `test_bill`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_bill` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bill_id` varchar(20) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `patient_id` int(11) DEFAULT NULL,
  `bill_date` date NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `discount` decimal(15,2) DEFAULT NULL,
  `grand_total` decimal(15,2) DEFAULT NULL,
  `net_total` decimal(15,2) DEFAULT NULL,
  `due_amount` decimal(15,2) DEFAULT NULL,
  `paid_amount` decimal(15,2) DEFAULT NULL,
  `note` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci DEFAULT NULL,
  `prepared_by` varchar(30) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_bill`
--

LOCK TABLES `test_bill` WRITE;
/*!40000 ALTER TABLE `test_bill` DISABLE KEYS */;
INSERT INTO `test_bill` (`id`, `bill_id`, `patient_id`, `bill_date`, `sub_total`, `discount`, `grand_total`, `net_total`, `due_amount`, `paid_amount`, `note`, `prepared_by`) VALUES (2,'T10002',20,'2023-11-18',5100.00,100.00,NULL,5000.00,5000.00,0.00,NULL,'Dhaka Dental'),
(3,'T10003',25,'2023-11-21',8500.00,500.00,NULL,8000.00,0.00,8000.00,NULL,'Dhaka Dental'),
(4,'T10004',25,'2024-01-09',3900.00,300.00,NULL,3600.00,1600.00,2000.00,NULL,'Dhaka Dental'),
(5,'T10005',32,'2025-01-28',11400.00,1000.00,NULL,10400.00,5400.00,5000.00,NULL,'Dhaka Dental');
/*!40000 ALTER TABLE `test_bill` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `test_bill_item`
--

DROP TABLE IF EXISTS `test_bill_item`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `test_bill_item` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` varchar(20) NOT NULL,
  `invoice_date` date NOT NULL,
  `test_id` int(11) NOT NULL,
  `price` decimal(10,2) DEFAULT NULL,
  `quantity` decimal(15,2) NOT NULL,
  `total_price` decimal(15,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `test_bill_item`
--

LOCK TABLES `test_bill_item` WRITE;
/*!40000 ALTER TABLE `test_bill_item` DISABLE KEYS */;
INSERT INTO `test_bill_item` (`id`, `invoice_id`, `invoice_date`, `test_id`, `price`, `quantity`, `total_price`) VALUES (8,'2','1970-01-01',2,400.00,1.00,400.00),
(9,'2','1970-01-01',4,3500.00,1.00,3500.00),
(10,'2','1970-01-01',7,1200.00,1.00,1200.00),
(14,'3 ','1970-01-01',9,4000.00,1.00,4000.00),
(15,'3 ','1970-01-01',10,1000.00,1.00,1000.00),
(16,'3 ','1970-01-01',4,3500.00,1.00,3500.00),
(17,'4','1970-01-01',2,400.00,1.00,400.00),
(18,'4','1970-01-01',4,3500.00,1.00,3500.00),
(19,'5','1970-01-01',4,3500.00,1.00,3500.00),
(20,'5','1970-01-01',5,1500.00,1.00,1500.00),
(21,'5','1970-01-01',6,1500.00,1.00,1500.00),
(22,'5','1970-01-01',9,4000.00,1.00,4000.00),
(23,'5','1970-01-01',2,400.00,1.00,400.00),
(24,'5','1970-01-01',1,500.00,1.00,500.00);
/*!40000 ALTER TABLE `test_bill_item` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user`
--

DROP TABLE IF EXISTS `user`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(100) DEFAULT NULL,
  `name` varchar(111) NOT NULL,
  `password` text NOT NULL,
  `role` enum('reception','doctor','super_admin','admin') NOT NULL,
  `status` enum('active','inactive') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user`
--

LOCK TABLES `user` WRITE;
/*!40000 ALTER TABLE `user` DISABLE KEYS */;
INSERT INTO `user` (`id`, `fullname`, `name`, `password`, `role`, `status`) VALUES (4,'Ashiqe','user123','63a5794dc2ec6ae1a50655bf5359c71b780de9a6b013505a9711e5a085f885dfc7e69086d80b3a48f0e98628444a2c70dd2d86242e7d6c05c7b5100ea631f031','reception','active'),
(5,'Ashiqe','doctor123','81f124a4a840d50c0ea9bd677741108990e31002d9b45039b474b8fc2b3dde035981988779904811b41a2dc06872d8a1e801a1c50049123b594178eb01b8dae9','doctor','active'),
(6,'Dhaka Dental','DhakaDental','895b593a93c3d706f38b3dec7cac9d35f68006949331a24580ad8c687317f4f5f36e5938b8750a320b757a8a111edc77bfd78c0859135c7c820bb0418843ae1b','super_admin','active');
/*!40000 ALTER TABLE `user` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping events for database 'amrmemo_dental'
--

--
-- Dumping routines for database 'amrmemo_dental'
--
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-12-07 18:13:12
