<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Passenger extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
	}
	 
	public function add()
	{
		$data = array();
		if($_POST){ 
		    $data['name']=  $this->input->post('name',true);
		    $data['agent_id']=  $this->input->post('agent_id',true);
		    $data['passport']=  $this->input->post('passport',true);
		    $data['gender']=  $this->input->post('gender',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['email']=  $this->input->post('email',true);
        	$data['address']=  $this->input->post('address',true);

			$this->db->insert('passenger', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('passenger/add');
		}else{
			$data['agents'] = $this->db->get('agents')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	
	public function viewlist()
	{
		$data = array();
		 
		$data['passengers'] = $this->db->select('p.*, a.name as ag_name')
		->join('agents a', 'a.id=p.agent_id', 'left')
		->get('passenger p')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/passenger/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			 
		    $data['name']=  $this->input->post('name',true);
		    $data['agent_id']=  $this->input->post('agent_id',true);
		    $data['gender']=  $this->input->post('gender',true);
		    $data['passport']=  $this->input->post('passport',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['email']=  $this->input->post('email',true);
        	$data['address']=  $this->input->post('address',true);
			$this->db->update('passenger', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('passenger/viewlist');
		}else{
			$data['agents'] = $this->db->get('agents')->result();
			$data['passenger'] = $this->db->get_where('passenger',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delete($id='')
	{
		  
		$this->db->delete('passenger', ['id'=>$id]);
		$success = 'Deleted passenger Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('passenger/viewlist');
	}

	//  documents

	public function documents($passenger_id='')
	{
		$data = array();
		if($_POST){
			 
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/passenger/';
		    $config['allowed_types'] = '*';
		    $config['max_size'] = '60000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);

		    $data['passenger_id']=  $this->input->post('passenger_id',true);
        	$data['type']=  $this->input->post('type',true); 

		    $this->upload->do_upload('document_file');
	        $images = $this->upload->data();
	        $data['documents'] = $images['file_name'];


			$this->db->insert('passenger_documents', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('passenger/viewlist');
		}else{
			$data['passenger_id'] = $passenger_id;
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/documents_add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function view_documents($passenger_id='')
	{
		$data = array();
		 
		$data['documents'] = $this->db->get_where('passenger_documents', ['passenger_id'=>$passenger_id])->result();
		$data['dashboardContent'] = $this->load->view('dashboard/passenger/view_documents', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
		 
	}

	public function delete_document($document_id='', $passenger_id='')
	{
		$xx = $this->db->get_where("passenger_documents", ['id'=>$document_id])->row();
		if($xx->documents){
        	unlink("./uploads/passenger/".$xx->documents); 
        }

		$this->db->delete('passenger_documents', ['id'=>$document_id]);
		$success = 'Deleted documents Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('passenger/view_documents/'.$passenger_id);
	}


	public function add_expanse()
	{
		$data = array();
		if($_POST){
		    $data['passenger_id'] =  $this->input->post('passenger_id',true);
		    $data['types']=  $this->input->post('types',true);
		    $data['heads']=  $this->input->post('heads',true);
		    $data['amounts']=  $this->input->post('amounts',true);
        	$data['pay_date']=  date_formate_set_db($this->input->post('pay_date',true)); 

			$this->db->insert('passenger_balance', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('passenger/add_expanse');
		}else{
		    $data['agents'] = $this->db->get('agents')->result();
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/add_expanse', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function edit_expanse($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id',true);
		    $data['passenger_id'] =  $this->input->post('passenger_id',true);
		    $data['types']=  $this->input->post('types',true);
		    $data['heads']=  $this->input->post('heads',true);
		    $data['amounts']=  $this->input->post('amounts',true);
        	$data['pay_date']=  date_formate_set_db($this->input->post('pay_date',true)); 

			$this->db->update('passenger_balance', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('passenger/expanselist');
		}else{
		    $data['agents'] = $this->db->get('agents')->result();
			$data['passenger'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['expanse'] = $this->db->select('pb.*, p.gender, p.agent_id')
			->from('passenger_balance pb')
			->join('passenger p', 'p.id=pb.passenger_id', 'left')
			->where('pb.id', $id)
			->get()->row();
			//$data['expanse'] = $this->db->get_where('passenger_balance',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/edit_expanse', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function expanselist($value='')
	{
		$data = array();
		if($_POST){
		    $types=  $this->input->post('types',true);
		    $stdate=  date_formate_set_db($this->input->post('stdate',true));
		    $enddate=  date_formate_set_db($this->input->post('enddate',true));
		    
		    if(!empty($types)){
		    	$this->db->where('pb.types', $types);
		    }
		    if(!empty($stdate)){
		    	$this->db->where('pb.pay_date >=', $stdate);
		    }
		    if(!empty($enddate)){
		    	$this->db->where('pb.pay_date <=', $enddate);
		    }

			$data['passengers'] = $this->db->select('pb.*, p.name, p.passport')
			->join('passenger p', 'p.id=pb.passenger_id', 'left')
			->order_by('pb.pay_date', 'ASC')
			->get('passenger_balance pb')->result();


			$data['dashboardContent'] = $this->load->view('dashboard/passenger/expanselist', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}else{
			$data['passengers'] = $this->db->select('pb.*, p.name, p.passport')
			->join('passenger p', 'p.id=pb.passenger_id', 'left')
			->order_by('pb.pay_date', 'ASC')
			->get('passenger_balance pb')->result();


			$data['dashboardContent'] = $this->load->view('dashboard/passenger/expanselist', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function expanse_delete($id='')
	{
		  
		$this->db->delete('passenger_balance', ['id'=>$id]);
		$success = 'Deleted Expanse/Deposit Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('passenger/expanselist');
	}

	public function expanse_report($value='')
	{
		$data = array();
		$data['passenger_id'] = '';
		$data['passenger_id'] = '';
		$data['agent_id'] = '';
		$data['gender'] = '';
		if($_POST){
		    //$passenger_id=  $this->input->post('passenger_id',true);
		    //$stdate=  date_formate_set_db($this->input->post('stdate',true));
		    //$enddate=  date_formate_set_db($this->input->post('enddate',true));
		    $agent_id=  $this->input->post('agent_id',true);
		    $gender=  $this->input->post('gender',true);
		    
		    if(!empty($agent_id)){
		    	$this->db->where('p.agent_id', $agent_id);
		    	$data['agent_id'] = $agent_id;
		    }
		    if(!empty($gender)){
		    	$this->db->where('p.gender', $gender);
		    	$data['gender'] = $gender;
		    }
		    /*if(!empty($passenger_id)){
		    	$this->db->where('pb.passenger_id', $passenger_id);
		    	$data['passenger_id'] = $passenger_id;
		    }
		    if(!empty($stdate)){
		    	$this->db->where('pb.pay_date >=', $stdate);
		    }
		    if(!empty($enddate)){
		    	$this->db->where('pb.pay_date <=', $enddate);
		    }*/

			$data['passengers'] = $this->db->select('pb.*, p.name, p.passport')
			->join('passenger p', 'p.id=pb.passenger_id', 'left')
			->order_by('pb.pay_date', 'ASC')
			->get('passenger_balance pb')->result();
			
			$data['passenger_list'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['agents'] = $this->db->get('agents')->result();
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/expanse_report', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}else{
			$data['passengers'] = $this->db->select('pb.*, p.name, p.passport')
			->join('passenger p', 'p.id=pb.passenger_id', 'left')
			->order_by('pb.pay_date', 'ASC')
			->get('passenger_balance pb')->result();
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['agents'] = $this->db->get('agents')->result();
			$data['passenger_list'] = $this->db->order_by('name', 'ASC')->get('passenger')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/passenger/expanse_report', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}
	
	public function ajax_passengers($agent_id='', $gender='')
	{
		if($agent_id){
			$this->db->where('agent_id', $agent_id);
		}
		if($gender){
			$this->db->where('gender', $gender);
		}
		$passenger = $this->db->order_by('name', 'ASC')->get('passenger')->result();
		$option = '<option value="">Select One</option>';
		foreach ($passenger as $key => $value) {
			$option .= '<option value="'.$value->id.'">'.$value->name. ' ('.$value->passport.')'.'</option>';
		}
		echo $option;
	}
}