<?php
/**
* 
*/
class Inventorymodel extends CI_Model
{
	
	public function __construct() {
        parent::__construct();
    }

    public function queryitemlist()
    {
    	$this->db->select('*');
		$this->db->from('item');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function querysupplierlist()
    {
    	$this->db->select('*');
		$this->db->from('supplier');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
    }

    public function insertinventory($data)
    {
    	$this->db->insert('inventory',$data);

		return true;
    }

    public function queryforinventorybalancebyid($id)
    {
    	$this->db->select('*');
		$this->db->from('inventory');
        $this->db->where('item_id', $id);
        $this->db->order_by("inventory_id", "desc");
        $this->db->limit(1);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }

    public function queryforitemsupplierbyid($id)
    {
        $this->db->select('supplier.supplier_id,supplier.supplier_name');
        $this->db->from('item');
        $this->db->where('item.item_id', $id);
        $this->db->join('supplier', 'item.supplier_id = supplier.supplier_id', 'left');
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

    public function queryforinventoryitemsupplierlistbyitemid($item_id)
    {
        $this->db->select('inventory.inventory_id, item.item_name, supplier.supplier_name , inventory.purchasing_price , inventory.selling_price , inventory.first_supplied_date , inventory.first_supplied_stock , inventory.balance_stock');
        $this->db->from('inventory');
        $this->db->where('inventory.item_id', $item_id);
        $this->db->where('inventory.sold_quantity <=', 0);
        $this->db->join('item', 'inventory.item_id = item.item_id', 'left');
        $this->db->join('supplier', 'inventory.supplier_id = supplier.supplier_id', 'left');
        $query_results =$this->db->get();
        $results= $query_results->result_array();
        return $results;
    }

    public function deleteinventory($inventory_id)
    {
        $this->db->where('inventory_id', $inventory_id);
        $this->db->delete('inventory'); 
    }
}