<?php if(Session::has('doneMessage')): ?>
    <div class="padding p-b-0">
        <div class="row">
            <div class="col-lg-12">
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo Session::get('doneMessage'); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php if(Session::has('errorMessage')): ?>
    <div class="padding p-b-0">
        <div class="row">
            <div class="col-lg-12">
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo Session::get('errorMessage'); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php if(@$FormSectionID >0): ?>
    <?php
    // Get banners list array by settings ID (You can get settings ID from Webmaster >> Banners settings)
    $WebmasterSection = Helper::WebmasterSection($FormSectionID);
    $fatherSections = Helper::SectionCategories($FormSectionID);
    ?>
    <?php if(!empty($WebmasterSection)): ?>
        <div class="form-block">
            <h4 class="pt-3 text-muted">
                <?php echo e(__('backend.submit')); ?> <?php echo $WebmasterSection->{"title_".@Helper::currentLanguage()->code}; ?>

            </h4>
            <div class="bottom-article">
                <?php echo e(Form::open(['route'=>['formSubmit'],'method'=>'POST', 'files' => true ])); ?>

                <div class="form-group row">
                    <?php if($WebmasterSection->date_status): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="form_date" class="form-control-label"><?php echo __('backend.topicDate'); ?></label>
                            <div class="form-group">
                                <div class='input-group date'>
                                    <?php echo Form::text('date',Helper::formatDate(date("Y-m-d")), array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'form_date','required'=>'')); ?>

                                    <span class="input-group-addon">
                  <span class="fa fa-calendar"></span>
              </span>
                                </div>
                            </div>

                        </div>
                    <?php else: ?>
                        <?php echo Form::hidden('date',date("Y-m-d"), array('placeholder' => '','class' => 'form-control form_date','id'=>'form_date')); ?>

                    <?php endif; ?>

                    <?php if($WebmasterSection->expire_date_status): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="form_expire_date" class="form-control-label"><?php echo __('backend.expireDate'); ?>

                            </label>
                            <?php echo Form::text('expire_date','', array('placeholder' => '','autocomplete' => 'off','class' => 'form-control form_date','id'=>'form_expire_date')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($WebmasterSection->sections_status!=0): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="section_id"
                                   class="form-control-label"><?php echo __('backend.categories'); ?> </label>
                            <select name="section_id" id="section_id" class="form-control c-select" required>
                                <option value=""> - - <?php echo __('backend.select'); ?> - -</option>
                                <?php
                                $title_var = "title_" . @Helper::currentLanguage()->code;
                                $title_var2 = "title_" . config('smartend.default_language');
                                $t_arrow = "&raquo;";
                                ?>
                                <?php $__currentLoopData = $fatherSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fatherSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                    if ($fatherSection->$title_var != "") {
                                        $ftitle = $fatherSection->$title_var;
                                    } else {
                                        $ftitle = $fatherSection->$title_var2;
                                    }
                                    ?>
                                    <option value="<?php echo e($fatherSection->id); ?>"><?php echo $ftitle; ?></option>
                                    <?php $__currentLoopData = $fatherSection->fatherSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subFatherSection): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                        if ($subFatherSection->$title_var != "") {
                                            $title = $subFatherSection->$title_var;
                                        } else {
                                            $title = $subFatherSection->$title_var2;
                                        }
                                        ?>
                                        <option
                                            value="<?php echo e($subFatherSection->id); ?>"><?php echo $ftitle; ?> <?php echo $t_arrow; ?> <?php echo $title; ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    <?php else: ?>
                        <?php echo Form::hidden('section_id','0'); ?>

                    <?php endif; ?>

                    <?php if($WebmasterSection->title_status): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="form_title"
                                   class="form-control-label"><?php echo __('backend.topicName'); ?>

                            </label>
                            <?php echo Form::text('title','', array('placeholder' => '','autocomplete' => 'off','id' => 'form_title','class' => 'form-control','required'=>'')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($WebmasterSection->longtext_status): ?>
                        <div class="col-sm-12">
                            <label class="form-control-label" for="form_details"><?php echo __('backend.bannerDetails'); ?>

                            </label>
                            <?php echo Form::textarea('details','', array('placeholder' => '','autocomplete' => 'off','id'=>'form_details','class' => 'form-control','rows'=>'8')); ?>

                        </div>
                    <?php endif; ?>

                    <?php if($WebmasterSection->photo_status): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="form_photo_file"
                                   class="form-control-label"><?php echo __('backend.topicPhoto'); ?></label>
                            <?php echo Form::file('photo_file', array('class' => 'form-control','autocomplete' => 'off','id' => 'form_photo_file','accept'=>'image/*')); ?>

                            <small>
                                <?php echo __('backend.imagesTypes'); ?>

                            </small>
                        </div>
                    <?php endif; ?>

                    <?php if($WebmasterSection->attach_file_status): ?>
                        <div class="col-lg-4 col-md-12">
                            <label for="form_attach_file"
                                   class="form-control-label"><?php echo __('backend.topicAttach'); ?></label>
                            <?php echo Form::file('attach_file', array('class' => 'form-control','autocomplete' => 'off','id'=>'form_attach_file')); ?>

                            <small>
                                <?php echo __('backend.attachTypes'); ?>

                            </small>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(count($WebmasterSection->customFields) >0): ?>
                        <?php
                        $cf_title_var = "title_" . @Helper::currentLanguage()->code;
                        $cf_title_var2 = "title_" . config('smartend.default_language');
                        ?>
                        <?php $__currentLoopData = $WebmasterSection->customFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customField): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                            // check permission
                            $add_permission_groups = [];
                            if ($customField->add_permission_groups != "") {
                                $add_permission_groups = explode(",", $customField->add_permission_groups);
                            }
                            // have permission & continue
                            if ($customField->$cf_title_var != "") {
                                $cf_title = $customField->$cf_title_var;
                            } else {
                                $cf_title = $customField->$cf_title_var2;
                            }

                            // check field language status
                            $cf_lang_identifier = "";
                            $cf_land_active = false;
                            $cf_land_dir = @Helper::currentLanguage()->direction;
                            if ($customField->lang_code != "all") {
                                $ct_language = @Helper::LangFromCode($customField->lang_code);
                                $cf_lang_identifier = @Helper::languageName($ct_language);
                                $cf_land_dir = $ct_language->direction;
                                if ($ct_language->box_status) {
                                    $cf_land_active = true;
                                }
                            }
                            if ($customField->lang_code == "all") {
                                $cf_land_active = true;
                            }
                            // required Status
                            $cf_required = '';
                            $cf_required_star = '';
                            if ($customField->required) {
                                $cf_required = 'required';
                                $cf_required_star = '<span class="text-danger">*</span>';
                            }
                            if (@old('customField_' . $customField->id) != "") {
                                $customField->default_value = @old('customField_' . $customField->id);
                            }

                            ?>

                            <?php if($cf_land_active): ?>
                                <?php if($customField->type ==12): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?> <i class="fa fa-vimeo"></i>
                                        </label>
                                        <?php echo Form::text('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>'ltr')); ?>

                                    </div>
                                <?php elseif($customField->type ==11): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?> <i class="fa fa-youtube"></i>
                                        </label>
                                        <?php echo Form::text('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>'ltr')); ?>

                                    </div>
                                <?php elseif($customField->type ==10): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <?php echo Form::file('customField_'.$customField->id, array('class' => 'form-control','autocomplete' => 'off','id'=>'customField_'.$customField->id,$cf_required=>'','accept'=>'*')); ?>

                                    </div>
                                <?php elseif($customField->type ==9): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <?php echo Form::file('customField_'.$customField->id, array('class' => 'form-control','autocomplete' => 'off','id'=>'customField_'.$customField->id,$cf_required=>'','accept'=>'*')); ?>

                                    </div>
                                <?php elseif($customField->type ==8): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <?php echo Form::file('customField_'.$customField->id, array('class' => 'form-control','autocomplete' => 'off','id'=>'customField_'.$customField->id,$cf_required=>'','accept'=>'image/*')); ?>

                                    </div>
                                <?php elseif($customField->type ==13): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <?php
                                        $cf_details_var = "details_" . @Helper::currentLanguage()->code;
                                        $cf_details_var2 = "details_" . config('smartend.default_language');
                                        if ($customField->$cf_details_var != "") {
                                            $cf_details = $customField->$cf_details_var;
                                        } else {
                                            $cf_details = $customField->$cf_details_var2;
                                        }
                                        $cf_details_lines = preg_split('/\r\n|[\r\n]/', $cf_details);
                                        $line_num = 1;
                                        ?>
                                        <?php $__currentLoopData = $cf_details_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cf_details_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="m-t-sm">
                                                <div class="form-check">
                                                    <input class="form-check-input" type="radio" value="<?php echo e($line_num); ?>"
                                                           name="<?php echo e('customField_'.$customField->id); ?>" <?php echo e($cf_required); ?>

                                                           id="<?php echo e('customField_'.$customField->id); ?>_<?php echo e($line_num); ?>" <?php echo e(($customField->default_value == $line_num) ? "checked":""); ?>>
                                                    <label class="form-check-label"
                                                           for="<?php echo e('customField_'.$customField->id); ?>_<?php echo e($line_num); ?>">
                                                        <?php echo e($cf_details_line); ?>

                                                    </label>
                                                </div>
                                            </div>
                                            <?php
                                            $line_num++;
                                            ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                <?php elseif($customField->type ==14): ?>
                                    
                                    <div class="col-sm-12">
                                        <div class="form-check form-switch">
                                            <input class="form-check-input" type="checkbox"
                                                   name="<?php echo e('customField_'.$customField->id); ?>"
                                                   id="<?php echo e('customField_'.$customField->id); ?>" <?php echo e($cf_required); ?> value="1">
                                            <label class="form-check-label"
                                                   for="<?php echo e('customField_'.$customField->id); ?>"><?php echo $cf_title; ?>

                                                <?php echo $cf_lang_identifier; ?></label>
                                        </div>
                                    </div>
                                <?php elseif($customField->type ==7): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <select name="<?php echo e('customField_'.$customField->id); ?>[]"
                                                id="<?php echo e('customField_'.$customField->id); ?>"
                                                class="form-control select2-multiple" multiple <?php echo e($cf_required); ?>>
                                            <?php
                                            $cf_details_var = "details_" . @Helper::currentLanguage()->code;
                                            $cf_details_var2 = "details_" . config('smartend.default_language');
                                            if ($customField->$cf_details_var != "") {
                                                $cf_details = $customField->$cf_details_var;
                                            } else {
                                                $cf_details = $customField->$cf_details_var2;
                                            }
                                            $cf_details_lines = preg_split('/\r\n|[\r\n]/', $cf_details);
                                            $line_num = 1;
                                            ?>
                                            <?php $__currentLoopData = $cf_details_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cf_details_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($line_num); ?>" <?php echo e(($customField->default_value == $line_num) ? "selected='selected'":""); ?>><?php echo e($cf_details_line); ?></option>
                                                <?php
                                                $line_num++;
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php elseif($customField->type ==6): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?></label>
                                        <select name="<?php echo e('customField_'.$customField->id); ?>"
                                                id="<?php echo e('customField_'.$customField->id); ?>"
                                                class="form-control select2" <?php echo e($cf_required); ?>>
                                            <option value="">- - <?php echo $cf_title; ?> - -</option>
                                            <?php
                                            $cf_details_var = "details_" . @Helper::currentLanguage()->code;
                                            $cf_details_var2 = "details_" . config('smartend.default_language');
                                            if ($customField->$cf_details_var != "") {
                                                $cf_details = $customField->$cf_details_var;
                                            } else {
                                                $cf_details = $customField->$cf_details_var2;
                                            }
                                            $cf_details_lines = preg_split('/\r\n|[\r\n]/', $cf_details);
                                            $line_num = 1;
                                            ?>
                                            <?php $__currentLoopData = $cf_details_lines; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cf_details_line): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option
                                                    value="<?php echo e($line_num); ?>" <?php echo e(($customField->default_value == $line_num) ? "selected='selected'":""); ?>><?php echo e($cf_details_line); ?></option>
                                                <?php
                                                $line_num++;
                                                ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                <?php elseif($customField->type ==5): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::text('customField_'.$customField->id,"", array('placeholder' => '','autocomplete' => 'off','class' => 'form-control form_datetime','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>$cf_land_dir)); ?>

                                    </div>
                                <?php elseif($customField->type ==4): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::text('customField_'.$customField->id,Helper::formatDate($customField->default_value), array('placeholder' => '','autocomplete' => 'off','class' => 'form-control form_date','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>$cf_land_dir)); ?>


                                    </div>
                                <?php elseif($customField->type ==3): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::email('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>$cf_land_dir)); ?>

                                    </div>
                                <?php elseif($customField->type ==2): ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::number('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'customField_'.$customField->id,$cf_required=>'','min'=>0, 'dir'=>$cf_land_dir)); ?>

                                    </div>
                                <?php elseif($customField->type ==1): ?>
                                    
                                    <div class="col-sm-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::textarea('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','id' => 'customField_'.$customField->id,'class' => 'form-control',$cf_required=>'', 'dir'=>$cf_land_dir,'rows'=>'5')); ?>

                                    </div>
                                <?php else: ?>
                                    
                                    <div class="col-lg-4 col-md-12">
                                        <label for="<?php echo e('customField_'.$customField->id); ?>"
                                               class="form-control-label"><?php echo $cf_title; ?> <?php echo $cf_required_star; ?>

                                            <?php echo $cf_lang_identifier; ?>

                                        </label>
                                        <?php echo Form::text('customField_'.$customField->id,$customField->default_value, array('placeholder' => '','autocomplete' => 'off','class' => 'form-control','id'=>'customField_'.$customField->id,$cf_required=>'', 'dir'=>$cf_land_dir)); ?>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>
                    


                    <div class="col-lg-4 col-md-12">
                        <?php if(config('smartend.nocaptcha_status')): ?>
                            <div class="form-group">
                                <?php echo NoCaptcha::renderJs(@Helper::currentLanguage()->code); ?>

                                <?php echo NoCaptcha::display(); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <input type="hidden" name="TopicID" value="<?php echo e(@$Topic->id); ?>">
                <input type="hidden" name="WebmasterSectionId" value="<?php echo e(encrypt($WebmasterSection->id)); ?>">
                <button type="submit"
                        class="btn btn-lg submit-btn btn-theme"><i
                        class="fa-solid fa-paper-plane"></i> <?php echo e(__('backend.submit')); ?></button>
                <?php echo e(Form::close()); ?>

            </div>
        </div>

        <?php $__env->startPush('before-styles'); ?>
            <link rel="stylesheet"
                  href="<?php echo e(URL::asset('assets/frontend/vendor/datetime-picker/css/bootstrap-datetimepicker.min.css')); ?>?v=<?php echo e(Helper::system_version()); ?>"/>
            <link rel="stylesheet"
                  href="<?php echo e(URL::asset('assets/frontend/vendor/select2/css/select2.min.css')); ?>?v=<?php echo e(Helper::system_version()); ?>"/>
        <?php $__env->stopPush(); ?>
        <?php $__env->startPush('after-scripts'); ?>
            <script
                src="<?php echo e(URL::asset('assets/frontend/vendor/datetime-picker/js/bootstrap-datetimepicker.min.js')); ?>?v=<?php echo e(Helper::system_version()); ?>"></script>
            <script
                src="<?php echo e(URL::asset('assets/frontend/vendor/datetime-picker/js/locales/bootstrap-datetimepicker.'.@Helper::currentLanguage()->code.'.js')); ?>?v=<?php echo e(Helper::system_version()); ?>"></script>
            <script
                src="<?php echo e(URL::asset('assets/frontend/vendor/select2/js/select2.min.js')); ?>?v=<?php echo e(Helper::system_version()); ?>"></script>
            <script type="text/javascript">
                $(function () {
                    $(".select2").select2();
                    $(".select2-multiple").select2({
                        tags: true
                    });
                    $(".form_datetime").datetimepicker({
                        language: '<?php echo e(@Helper::currentLanguage()->code); ?>',
                        rtl: <?php echo e((@Helper::currentLanguage()->direction=="rtl")?"true":"false"); ?>,
                        autoclose: true,
                        todayHighlight: false,
                        showMeridian: true,
                        pickerPosition: 'bottom-<?php echo e(@Helper::currentLanguage()->right); ?>',
                    });
                    $(".form_date").datetimepicker({
                        format: 'yyyy-mm-dd',
                        language: '<?php echo e(@Helper::currentLanguage()->code); ?>',
                        rtl: <?php echo e((@Helper::currentLanguage()->direction=="rtl")?"true":"false"); ?>,
                        autoclose: true,
                        todayHighlight: false,
                        pickerPosition: 'bottom-right',
                        viewSelect: 2,
                        startView: 2,
                        maxView: 0,
                    }).on('changeDate', function (ev) {
                        $('.form_date').datetimepicker('hide');
                    });
                });
            </script>
        <?php $__env->stopPush(); ?>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/form.blade.php ENDPATH**/ ?>