<?php $__env->startSection('title', __('backend.calendar')); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make('dashboard.events.edit', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('dashboard.events.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Clear ALL modal -->
    <div id="m-deleteAll" class="modal fade" data-backdrop="true">
        <div class="modal-dialog" id="animate">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><?php echo e(__('backend.confirmation')); ?></h5>
                </div>
                <div class="modal-body text-center p-lg">
                    <p>
                        <?php echo e(__('backend.eventClear')); ?>

                    </p>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn dark-white p-x-md"
                            data-dismiss="modal" data-toggle="modal"
                            data-target="#mmn-edit" ui-toggle-class="bounce"
                            ui-target="#animate"><?php echo e(__('backend.no')); ?></button>
                    <a href="<?php echo e(route("calendarUpdateAll")); ?>"
                       class="btn danger p-x-md"><?php echo e(__('backend.yes')); ?></a>
                </div>
            </div><!-- /.modal-content -->
        </div>
    </div>
    <!-- / .modal -->

    <div class="padding">
        <div class="row m-b">
            <div class="col-sm-4 m-b-sm">
                <button type="button" class="btn btn-sm primary" id="btnNew" data-toggle="modal"
                        data-target="#mmn-new"
                        ui-toggle-class="bounce"
                        ui-target="#animate"><i class="material-icons">
                        &#xe02e;</i> <?php echo e(__('backend.newEvent')); ?></button>
                <button type="button" id="btnEdit" data-toggle="modal" class="displayNone"
                        data-target="#mmn-edit"
                        ui-toggle-class="bounce"
                        ui-target="#animate"><?php echo e(__('backend.edit')); ?></button>

            </div>
            <div class="col-sm-8 text-sm-right">
                <div class="btn-group m-l-xs">
                    <button class="btn btn-sm white" id="todayview"><?php echo e(__('backend.eventToday')); ?></button>
                    <button class="btn btn-sm white" id="dayview"><?php echo e(__('backend.eventDay')); ?></button>
                    <button class="btn btn-sm white" id="weekview"><?php echo e(__('backend.eventWeek')); ?></button>
                    <button class="btn btn-sm white" id="monthview"><?php echo e(__('backend.eventMonth')); ?></button>
                </div>
            </div>
        </div>
        <div class="fullcalendar" id="fullcalendar">
        </div>
        <br>
        <small class="pull-right"><?php echo e(__('backend.eventTotal')); ?> : ( <?php echo e(count($Events)); ?> )</small>

        <small><a data-dismiss="modal" data-toggle="modal"
                  data-target="#m-deleteAll" ui-toggle-class="bounce"
                  ui-target="#animate"><?php echo e(__('backend.eventClear')); ?></a></small>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush("before-styles"); ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/dashboard/js/fullcalendar/dist/fullcalendar.theme.css')); ?>?v=<?php echo e(Helper::system_version()); ?>" type="text/css"/>
<?php $__env->stopPush(); ?>
<?php $__env->startPush("after-scripts"); ?>

    <script
        src="<?php echo e(asset('assets/dashboard/js/fullcalendar/dist/index.global.min.js')); ?>?v=<?php echo e(Helper::system_version()); ?>"
        defer></script>
    <script
        src="<?php echo e(asset('assets/dashboard/js/fullcalendar/dist/locales/')); ?>/<?php echo e(@Helper::currentLanguage()->code); ?>.global.min.js?v=<?php echo e(Helper::system_version()); ?>"
        defer></script>
    <script type="text/javascript">
        function pad(s) {
            return (s < 10) ? '0' + s : s;
        }

        document.addEventListener('DOMContentLoaded', function () {
            var calendarEl = document.getElementById('fullcalendar');

            var calendar = new FullCalendar.Calendar(calendarEl, {
                headerToolbar: {
                    left: '<?php echo e(( @Helper::currentLanguage()->direction=="rtl")?"next":"prev"); ?>',
                    center: 'title',
                    right: '<?php echo e(( @Helper::currentLanguage()->direction=="rtl")?"prev":"next"); ?>'
                },
                locale: '<?php echo e(@Helper::currentLanguage()->code); ?>',
                initialDate: '<?php echo e(date("Y-m-d")); ?>',
                editable: true,
                selectable: true,
                businessHours: true,
                firstDay: <?php echo e(config('smartend.first_day_of_week')); ?>,
                dayMaxEvents: true, // allow "more" link when too many events
                events: [
                        <?php $__currentLoopData = $Events; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Event): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($Event->type ==3): ?>
                    {
                        id: <?php echo $Event->id; ?>,
                        title: '<?php echo $Event->title; ?>',
                        url: '<?php echo e(route("calendarEdit",["id"=>$Event->id])); ?>',
                        start: '<?php echo e(date('Y-m-d', strtotime($Event->start_date))); ?>',
                        end: '<?php echo e(date('Y-m-d', strtotime($Event->end_date))); ?>',
                        className: ['info']
                    },
                        <?php elseif($Event->type ==2): ?>
                    {
                        id: <?php echo $Event->id; ?>,
                        title: '<?php echo $Event->title; ?>',
                        url: '<?php echo e(route("calendarEdit",["id"=>$Event->id])); ?>',
                        start: '<?php echo e(date('Y-m-d H:i:s', strtotime($Event->start_date))); ?>',
                        end: '<?php echo e(date('Y-m-d H:i:s', strtotime($Event->end_date))); ?>',
                        className: ['danger']
                    },
                        <?php elseif($Event->type ==1): ?>
                    {
                        id: <?php echo $Event->id; ?>,
                        title: '<?php echo $Event->title; ?>',
                        url: '<?php echo e(route("calendarEdit",["id"=>$Event->id])); ?>',
                        start: '<?php echo e(date('Y-m-d H:i:s', strtotime($Event->start_date))); ?>',
                        className: ['green']
                    },
                        <?php else: ?>
                    {
                        id: <?php echo $Event->id; ?>,
                        title: '<?php echo $Event->title; ?>',
                        url: '<?php echo e(route("calendarEdit",["id"=>$Event->id])); ?>',
                        start: '<?php echo e(date('Y-m-d', strtotime($Event->start_date))); ?>',
                        className: ['white']
                    },
                    <?php endif; ?>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ],
                dateClick: function (info) {
                    var date = info.dateStr;
                    var thisdate = new Date(date).getFullYear() + '-' + ('0' + (new Date(date).getMonth() + 1)).slice(-2) + '-' + ('0' + (new Date(date).getDate())).slice(-2);
                    $('#mmn-new #date').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>'));
                    $('#mmn-new #date_start').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>'));
                    $('#mmn-new #date_end').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>'));
                    $('#mmn-new #date_at').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>') + ' <?php echo e(date("h:i A")); ?>');
                    $('#mmn-new #time_start').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>') + ' <?php echo e(date("h:i A")); ?>');
                    $('#mmn-new #time_end').val(js_fd(thisdate, '<?php echo e(Helper::jsDateFormat()); ?>') + ' <?php echo e(date("h:i A")); ?>');
                    $('#mmn-new').modal();
                },

                eventResize: function (info) {
                    var event = info.event;
                    if (!confirm('is this okay?')) {
                        info.revert();
                    } else {
                        $(document).ready(function () {
                            var d = event.start;
                            var start_date = [d.getFullYear(), pad(d.getMonth() + 1), pad(d.getDate())].join('-');
                            var d2 = event.end;
                            var end_date = [d2.getFullYear(), pad(d2.getMonth() + 1), pad(d2.getDate())].join('-');
                            $.ajax({
                                url: '<?php echo e(asset(config('smartend.backend_path')."/calendar/")); ?>/' + event.id + '/extend',
                                type: 'post',
                                data: {
                                    'started_on': start_date,
                                    'ended_on': end_date,
                                    '_token': '<?php echo e(csrf_token()); ?>'
                                },
                                success: function (data) {

                                }
                            });
                        });
                    }
                },
                eventDrop: function (info) {
                    var event = info.event;
                    if (!confirm('is this okay?')) {
                        info.revert();
                    } else {
                        $(document).ready(function () {
                            var d = event.start;
                            var start_date = [d.getFullYear(), pad(d.getMonth() + 1), pad(d.getDate())].join('-');
                            $.ajax({
                                url: '<?php echo e(asset(config('smartend.backend_path')."/calendar/")); ?>/' + event.id + '/extend',
                                type: 'post',
                                data: {'started_on': start_date, '_token': '<?php echo e(csrf_token()); ?>'},
                                success: function (data) {

                                }
                            });
                        });
                    }
                }
            });

            calendar.render();
            $(document).on('click', '#dayview', function() {
                calendar.changeView('timeGridDay')
            });

            $(document).on('click', '#weekview', function() {
                calendar.changeView( 'timeGridWeek')
            });

            $(document).on('click', '#monthview', function() {
                calendar.changeView( 'dayGridMonth')
            });

            $(document).on('click', '#todayview', function() {
                calendar.today()
            });

        });

        $(document).ready(function () {
            $("#type0l").click(function () {
                $('#date').show();
                $('#date_at').hide();
                $('#from_to_time').hide();
                $('#from_to_date').hide();
            });
            $("#type1l").click(function () {
                $('#date').hide();
                $('#date_at').show();
                $('#from_to_time').hide();
                $('#from_to_date').hide();
            });
            $("#type2l").click(function () {
                $('#date').hide();
                $('#date_at').hide();
                $('#from_to_time').show();
                $('#from_to_date').hide();
            });
            $("#type3l").click(function () {
                $('#date').hide();
                $('#date_at').hide();
                $('#from_to_time').hide();
                $('#from_to_date').show();
            });
            <?php if($EStatus=="edit"): ?>
            $("#btnEdit").click();
            <?php endif; ?>

            <?php if($EStatus=="new"): ?>
            $(document).ready(function () {
                $("#btnNew").click();
            });
            <?php endif; ?>
            $("#etype0l").click(function () {
                $('#e_date').show();
                $('#e_date_at').hide();
                $('#e_from_to_time').hide();
                $('#e_from_to_date').hide();
            });
            $("#etype1l").click(function () {
                $('#e_date').hide();
                $('#e_date_at').show();
                $('#e_from_to_time').hide();
                $('#e_from_to_date').hide();
            });
            $("#etype2l").click(function () {
                $('#e_date').hide();
                $('#e_date_at').hide();
                $('#e_from_to_time').show();
                $('#e_from_to_date').hide();
            });
            $("#etype3l").click(function () {
                $('#e_date').hide();
                $('#e_date_at').hide();
                $('#e_from_to_time').hide();
                $('#e_from_to_date').show();
            });
        });

        function js_fd(date, format) {

            var arr = date.split("-");
            var dd = arr[2];
            var mm = arr[1];
            var yyyy = arr[0];

            var final_date = format;
            final_date = final_date.replace("MM", mm);
            final_date = final_date.replace("DD", dd);
            final_date = final_date.replace("YYYY", yyyy);
            return final_date;
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('dashboard.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/marketandcommuni/public_html/core/resources/views/dashboard/events/list.blade.php ENDPATH**/ ?>