<?php if(!empty($Topic)): ?>
    <article>
        <div class="card post-card pa-0 mb-4">
            <?php if($Topic->webmasterSection->type==2 && $Topic->video_file!=""): ?>
                
                <a href="<?php echo e($topic_link_url); ?>">
                    <div class="video-container position-relative">
                        <?php if($Topic->photo_file != ""): ?>
                            <img class="card-img-top"
                                 src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"  width="100%" height="100%"
                                 alt="<?php echo e($title); ?>" loading="lazy"/>
                        <?php else: ?>
                            <?php
                            $img_url = "";
                            ?>
                            <?php if($Topic->video_type ==1): ?>
                                <?php
                                $Youtube_id = Helper::Get_youtube_video_id($Topic->video_file);
                                $img_url = "http://img.youtube.com/vi/" . $Youtube_id . "/0.jpg";
                                ?>
                                <img class="card-img-top" src="<?php echo e($img_url); ?>"  width="100%" height="100%"
                                     alt="<?php echo e($title); ?>" loading="lazy"/>
                            <?php else: ?>
                                <div
                                    class="bg-secondary w-100 rounded-top h-200px"></div>
                            <?php endif; ?>
                        <?php endif; ?>
                        <h2 class="position-absolute top-50 start-50 translate-middle">
                                                                    <span
                                                                        class="badge  rounded opacity-75  bg-white text-primary"><i
                                                                            class="fa-solid fa-play"></i></span>
                        </h2>
                    </div>
                </a>
            <?php elseif($Topic->webmasterSection->type==3 && $Topic->audio_file!=""): ?>
                
                <div class="audio-container position-relative">
                    <?php if($Topic->photo_file !=""): ?>
                        <img class="card-img-top" loading="lazy"  width="100%" height="100%"
                             src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"
                             alt="<?php echo e($title); ?>"/>
                    <?php endif; ?>
                    <div class="audio-player">
                        <audio crossorigin preload="none">
                            <source
                                src="<?php echo e(URL::to('uploads/topics/'.$Topic->audio_file)); ?>"
                                type="audio/mpeg">
                        </audio>
                    </div>
                </div>
            <?php elseif(count($Topic->photos)>0): ?>
                
                <a href="<?php echo e($topic_link_url); ?>">
                    <div class="image-container position-relative">
                        <?php if($Topic->photo_file !=""): ?>
                            <img class="card-img-top" loading="lazy"  width="100%" height="100%"
                                 src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"
                                 alt="<?php echo e($title); ?>"/>

                        <?php else: ?>
                            <?php $__currentLoopData = $Topic->photos->random(1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $photo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <img class="card-img-top" loading="lazy"
                                     src="<?php echo e(URL::to('uploads/topics/'.$photo->file)); ?>"  width="100%" height="100%"
                                     alt="<?php echo e($title); ?>"/>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                        <?php if($Topic->photos->count() >1): ?>
                            <span class="extra-images-count"><span
                                    class="badge  rounded-pill text-primary bg-light"><i class="fa-solid fa-images"></i> <?php echo e($Topic->photos->count()); ?></span>
                            </span>
                        <?php endif; ?>
                    </div>
                </a>
            <?php else: ?>
                
                <a href="<?php echo e($topic_link_url); ?>">
                    <div class="image-container position-relative">
                        <?php if($Topic->photo_file !=""): ?>
                            <img class="card-img-top" loading="lazy"  width="100%" height="100%"
                                 src="<?php echo e(URL::to('uploads/topics/'.$Topic->photo_file)); ?>"
                                 alt="<?php echo e($title); ?>"/>
                        <?php endif; ?>
                    </div>
                </a>
            <?php endif; ?>
            <div class="mt-3">
                <a href="<?php echo e($topic_link_url); ?>">
                    <h3 class="card-title">
                        <?php if($Topic->icon !=""): ?>
                            <i class="fa <?php echo $Topic->icon; ?> "></i>&nbsp;
                        <?php endif; ?>
                        <?php echo e($title); ?>

                    </h3>
                </a>
                
                <?php echo $__env->make("frontEnd.topic.fields",["cols"=>12,"Fields"=>@$Topic->webmasterSection->customFields->where("in_listing",true)], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <?php if(strip_tags($Topic->$details) !=""): ?>
                    <p class="card-text mb-0 mt-2">
                        <?php echo mb_substr(strip_tags($Topic->$details),0, 180)."..."; ?> <a
                            href="<?php echo e($topic_link_url); ?>" class="read-more-link"><?php echo e(__("frontend.moreDetails")); ?></a>
                    </p>
                <?php endif; ?>
            </div>
        </div>
    </article>
<?php endif; ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/topic/card.blade.php ENDPATH**/ ?>