<?php if(config('smartend.google_maps_key') !=""): ?>
    <?php if(count($Topic->maps) >0): ?>
        <div class="row mb-4">
            <div class="col-lg-12">
                <h3 class="mb-3"><?php echo e(__('frontend.locationMap')); ?></h3>
                <div id="google-map" class="mb-3"></div>
            </div>
        </div>
        <?php $__currentLoopData = $Topic->maps->slice(0,1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $map): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
            $MapCenter = $map->longitude . "," . $map->latitude;
            ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php
        $map_title_var = "title_" . @Helper::currentLanguage()->code;
        $map_details_var = "details_" . @Helper::currentLanguage()->code;
        ?>
        <?php $__env->startPush('after-scripts'); ?>
            <script type="text/javascript"
                    src="//maps.google.com/maps/api/js?key=<?php echo e(config('smartend.google_maps_key')); ?>&language=<?php echo e(@Helper::currentLanguage()->code); ?>&callback=Function.prototype"></script>

            <script type="text/javascript">
                // var iconURLPrefix = 'http://maps.google.com/mapfiles/ms/icons/';
                var iconURLPrefix = "<?php echo e(asset('assets/dashboard/images/')."/"); ?>";
                var icons = [
                    iconURLPrefix + 'marker_0.png',
                    iconURLPrefix + 'marker_1.png',
                    iconURLPrefix + 'marker_2.png',
                    iconURLPrefix + 'marker_3.png',
                    iconURLPrefix + 'marker_4.png',
                    iconURLPrefix + 'marker_5.png',
                    iconURLPrefix + 'marker_6.png'
                ]

                var locations = [
                        <?php $__currentLoopData = $Topic->maps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $map): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    ['<?php echo "<strong>" . $map->$map_title_var . "</strong>" . "<br>" . $map->$map_details_var; ?>', <?php echo $map->longitude; ?>, <?php echo $map->latitude; ?>, <?php echo $map->id; ?>, <?php echo $map->icon; ?>],
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                ];

                var map = new google.maps.Map(document.getElementById('google-map'), {
                    zoom: 6,
                    draggable: false,
                    scrollwheel: false,
                    center: new google.maps.LatLng(<?php echo $MapCenter; ?>),
                    mapTypeId: google.maps.MapTypeId.ROADMAP
                });

                var infowindow = new google.maps.InfoWindow();

                var marker, i;

                for (i = 0; i < locations.length; i++) {
                    marker = new google.maps.Marker({
                        position: new google.maps.LatLng(locations[i][1], locations[i][2]),
                        icon: icons[locations[i][4]],
                        map: map
                    });

                    google.maps.event.addListener(marker, 'click', (function (marker, i) {
                        return function () {
                            infowindow.setContent(locations[i][0]);
                            infowindow.open(map, marker);
                        }
                    })(marker, i));
                }
            </script>
        <?php $__env->stopPush(); ?>
    <?php endif; ?>
<?php endif; ?>
<?php /**PATH /home/marketandcommuni/public_html/core/resources/views/frontEnd/topic/maps.blade.php ENDPATH**/ ?>