<!DOCTYPE html>
<html lang="{{ @Helper::currentLanguage()->code }}" dir="{{ @Helper::currentLanguage()->direction }}">

<head>
    <!-- ======= Meta & CSS ======= -->
    @stack('before-styles')
    @include('frontEnd.layouts.head')
    @include('frontEnd.layouts.colors')
    @yield('headInclude')
    @stack('after-styles')
<style>
.fixed-top-margin {
  margin-top: 338px !important;
}
.whc-row{
  box-shadow: rgba(0, 0, 0, 0.35) 0px 0 30px;
  padding: 35px;
  border-radius: 30px;
  margin-top: 100px;
  background-color: #fff;
}
#topbar {
  height: 40px;
  transition: .5s;
  z-index: 998;
  text-wrap: nowrap;
  width: 981px !important;
}
body {
 background-repeat: no-repeat;
 background-size: 100% 100%;
 background-color: #cccccc;
}
</style>
</head>

<body class="dir-{{ @Helper::currentLanguage()->direction }} lang-{{ @Helper::currentLanguage()->code }}" style="background-image: url('{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_body_bg")) }}');">
 <!-- ======= Top Bar ======= -->
<div class="container">
@include('frontEnd.layouts.topbar')
</div>


<!-- ======= Main contents ======= -->
<div class="container {{ (Helper::GeneralSiteSettings("style_header")) }}">
 <div class="whc-row">
 @include('frontEnd.layouts.header')
 <div class="row">
 <div class="col-md-9">
    @yield('content')
</div>
<div class="col-md-3">
  @include('frontEnd.layouts.right_sidebar')
</div>
</div>
</div>
</div>
<!-- ======= Footer ======= -->
@include('frontEnd.layouts.footer')
@if(Helper::GeneralSiteSettings("style_preload"))
<div id="preloader"></div>
@endif
<!-- ======= JS Including ======= -->
@stack('before-scripts')
@include('frontEnd.layouts.foot')
@yield('footInclude')
@stack('after-scripts')
</body>
</html>
