<meta charset="utf-8">
<title>{{(@$PageTitle !="")? @$PageTitle:Helper::GeneralSiteSettings("site_title_" . @Helper::currentLanguage()->code)}}</title>
<meta name="description" content="{{(@$PageDescription !="")? @$PageDescription:Helper::GeneralSiteSettings("site_desc_" . @Helper::currentLanguage()->code)}}"/>
<meta name="keywords" content="{{(@$PageKeywords !="")? @$PageKeywords:Helper::GeneralSiteSettings("site_keywords_" . @Helper::currentLanguage()->code)}}"/>
<meta name="author" content="{{ URL::to('') }}"/>

<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
<link href="{{ URL::asset('assets/frontend/vendor/fontawesome/css/all.min.css') }}?v={{ Helper::system_version() }}"  rel="stylesheet" media/>
<link href="{{ URL::asset('assets/frontend/vendor/fontawesome/css/font-awesome.min.css') }}?v={{ Helper::system_version() }}" rel="stylesheet" media/>
<link href="{{ URL::asset('assets/frontend/vendor/animate.css/animate.min.css') }}?v={{ Helper::system_version() }}" rel="stylesheet">
<link href="{{ URL::asset('assets/frontend/vendor/bootstrap/css/bootstrap.min.css') }}?v={{ Helper::system_version() }}" rel="stylesheet"/>
<link href="{{ URL::asset('assets/frontend/vendor/bootstrap-icons/bootstrap-icons.css') }}?v={{ Helper::system_version() }}" media rel="stylesheet"/>

<link rel="stylesheet" href="{{ URL::asset('assets/frontend/vendor/glightbox/css/glightbox.min.css') }}?v={{ Helper::system_version() }}">
<link rel="stylesheet" href="{{ URL::asset('assets/frontend/vendor/swiper/swiper-bundle.min.css') }}?v={{ Helper::system_version() }}">

<link rel="stylesheet" href="{{ URL::asset('assets/frontend/vendor/owl-carousel/assets/owl.carousel.min.css') }}?v={{ Helper::system_version() }}">
<link rel="stylesheet" href="{{ URL::asset('assets/frontend/vendor/owl-carousel/assets/owl.theme.default.min.css') }}?v={{ Helper::system_version() }}">

<link href="{{ URL::asset('assets/frontend/css/style.css') }}?v={{ Helper::system_version() }}" rel="stylesheet"/>


@if( @Helper::currentLanguage()->direction=="rtl")
<link href="{{ URL::asset('assets/frontend/css/rtl.css') }}?v={{ Helper::system_version() }}" rel="stylesheet"/>
@endif

<link href="{{ URL::asset('assets/frontend/css/whc.css') }}?v={{ Helper::system_version() }}" rel="stylesheet"/>

<!-- Favicon and Touch Icons -->
@if(Helper::GeneralSiteSettings("style_fav") !="")
    <link href="{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_fav")) }}" rel="shortcut icon"
          type="image/png">
@else
    <link href="{{ URL::asset('uploads/settings/nofav.png') }}" rel="shortcut icon" type="image/png">
@endif
@if(Helper::GeneralSiteSettings("style_apple") !="")
    <link href="{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_apple")) }}" rel="apple-touch-icon">
    <link href="{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_apple")) }}" rel="apple-touch-icon"
          sizes="72x72">
    <link href="{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_apple")) }}" rel="apple-touch-icon"
          sizes="114x114">
    <link href="{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_apple")) }}" rel="apple-touch-icon"
          sizes="144x144">
@else
    <link href="{{ URL::asset('uploads/settings/nofav.png') }}" rel="apple-touch-icon">
    <link href="{{ URL::asset('uploads/settings/nofav.png') }}" rel="apple-touch-icon" sizes="72x72">
    <link href="{{ URL::asset('uploads/settings/nofav.png') }}" rel="apple-touch-icon" sizes="114x114">
    <link href="{{ URL::asset('uploads/settings/nofav.png') }}" rel="apple-touch-icon" sizes="144x144">
@endif

<meta property='og:title'
      content='{{@$PageTitle}} {{(@$PageTitle =="")? Helper::GeneralSiteSettings("site_title_" . @Helper::currentLanguage()->code):""}}'/>
@if(@$Topic->photo_file !="")
    <meta property='og:image' content='{{ URL::asset('uploads/topics/'.@$Topic->photo_file) }}'/>
@elseif(Helper::GeneralSiteSettings("style_apple") !="")
    <meta property='og:image'
          content='{{ URL::asset('uploads/settings/'.Helper::GeneralSiteSettings("style_apple")) }}'/>
@else
    <meta property='og:image'
          content='{{ URL::asset('uploads/settings/nofav.png') }}'/>
@endif
<meta property="og:site_name" content="{{ Helper::GeneralSiteSettings("site_title_" . @Helper::currentLanguage()->code) }}">
<meta property="og:description" content="{{@$PageDescription}}"/>
<meta property="og:url" content="{{ url()->full()  }}"/>
<meta property="og:type" content="website"/>

<link rel="canonical" href="{{ url()->current() }}">
<style>
@media (min-width: 1200px) {
  .container, .container-lg, .container-md, .container-sm, .container-xl, #topbar, #header {
      max-width: 1035px !important;
      margin: 0 auto !important;
      padding: 4px !important;
  }
}
#header {
  height: 60px !important;
}
#header .logo img {
  margin-left: 36px;
}
#hero {
  width: 982px !important;
  margin: -152px -5px auto !important;
  height: 220px;
}
#hero .container{
  width: 940px;
}
#hero h2{
  margin-bottom: 7px !important;
}

.navbar a{
  padding: 5px 0px 0px 10px;
}
.navbar a, .navbar a:focus {
  font-size: 13px !important;
}
.navbar ul {
  margin: -5px 0 0 -9px !important;
}
.navbar .nav-link .fa{
  font-size: 22px !important;
  font: normal !important;
}
.navbar > ul > li {
  white-space: nowrap;
  padding: 6px 14px 5px 12px;
  border: 1px solid #e5dcdc;
}

.fixed-top {
  position: absolute !important;
  top: 0;
  right: 0;
  left: 0;
  z-index: 1030;
}
@media (max-height: 500px) {
  #hero, #hero .carousel-item {
    height: 45vh !important;
  }
}
.carousel-inner {
  position: relative;
  width: 100%;
  overflow: hidden;
  height: 220px !important;
}
.carousel-inner .carousel-item{
  height: 220px !important;
}
#header .logo img {
  width: auto;
  height: 100px !important;
  max-width: 100%;
  max-height: 550px;
  margin-top: -10px;
  margin-bottom: 10px;
}
#footer {
  color: #000;
  background-position: center center;
  background-color: #EBEBEB;
}
#footer a, .services .icon-box:hover h4, .services .icon-box:hover p, .whatsapp_float:active, .whatsapp_float:hover, .whatsapp_float:visited {
  color: #0d0d0d;
}

.footer-wrapper {
  background: #EBEBEB !important;
  height: 100px;
  margin: 0 auto;
}
@media only screen and (min-width: 960px) {
  .footer-wrapper {
    width: 1020px;
  }
}
#footer-menu {
  float: left;
  width: 50%;
  margin: 14px 0 0 20px !important;
}
#footer-menu ul {
  float: left;
  width: 100%;
  margin-bottom: 0;
  list-style: none;
}
#footer-menu ul li:first-child {
  border-left: solid 1px #eee;
}
#footer-menu ul li {
  float: left;
  border-right: 1px dotted #d8d8d8;
  display: inline-block;
  padding: 5px 10px;
}
#footer-menu ul li a {
  padding: 5px;
  color: #000;
  display: block;
  text-decoration: none;
}
.whc{
    width: 1390px !important;
}
.container-fluid .whc img{
    height: 160px !important;
    margin-top: -64px !important;
    margin-left: -12px !important;
}
</style>

@if(Helper::GeneralSiteSettings("css")!="")
    <style type="text/css">
        {!! Helper::GeneralSiteSettings("css") !!}
    </style>
@endif
{{-- Google Tags and google analytics --}}
@if(@$WebmasterSettings->google_tags_status && @$WebmasterSettings->google_tags_id !="")
    <!-- Google Tag Manager -->
    <script>(function(w,d,s,l,i){w[l]=w[l]||[];w[l].push({'gtm.start':
            new Date().getTime(),event:'gtm.js'});var f=d.getElementsByTagName(s)[0],
            j=d.createElement(s),dl=l!='dataLayer'?'&l='+l:'';j.async=true;j.src=
            'https://www.googletagmanager.com/gtm.js?id='+i+dl;f.parentNode.insertBefore(j,f);
        })(window,document,'script','dataLayer','{!! @$WebmasterSettings->google_tags_id !!}');</script>
    <!-- End Google Tag Manager -->
@endif
