<?php
namespace Database\Seeders;
use App\Models\WebmasterSectionField;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Seeder;
use App\Models\WebmasterSection;

class WebmasterSectionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Site pages
        $section = new WebmasterSection();
        $section->row_no = 1;

        $section->title_ar = "صفحات الموقع";
        $section->title_en = "Site pages";
        $section->title_ch = "网站页面";
        $section->title_hi = "साइट पेज";
        $section->title_es = "Sitio Páginas";
        $section->title_ru = "Страницы сайта";
        $section->title_pt = "Site Páginas";
        $section->title_fr = "Site Pages";
        $section->title_de = "Seiten";
        $section->title_th = "หน้าเว็บไซต์";
        $section->title_br = "páginas do site";

        $section->seo_title_ar = "صفحات الموقع";
        $section->seo_title_en = "Site pages";
        $section->seo_title_ch = "网站页面";
        $section->seo_title_hi = "साइट पेज";
        $section->seo_title_es = "Sitio Páginas";
        $section->seo_title_ru =  "Страницы сайта";
        $section->seo_title_pt = "Site Páginas";
        $section->seo_title_fr = "Site Pages";
        $section->seo_title_de = "Seiten";
        $section->seo_title_th = "หน้าเว็บไซต์";
        $section->seo_title_br = "páginas do site";

        $section->seo_url_slug_ar = "صفحات-الموقع";
        $section->seo_url_slug_en = "site-pages";
        $section->seo_url_slug_ch = "网站页面";
        $section->seo_url_slug_hi = "साइट-पेज";
        $section->seo_url_slug_es = "sitio-páginas";
        $section->seo_url_slug_ru =  "страницы-сайта";
        $section->seo_url_slug_pt = "site-páginas";
        $section->seo_url_slug_fr = "site-pages";
        $section->seo_url_slug_de = "seiten";
        $section->seo_url_slug_th = "หน้าเว็บไซต์";
        $section->seo_url_slug_br = "páginas-do-site";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 1;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 1;
        $section->order_status = 0;
        $section->related_status = 0;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Services
        $section = new WebmasterSection();
        $section->row_no = 2;

        $section->title_ar = "الخدمات";
        $section->title_en = "Services";
        $section->title_ch = "服务";
        $section->title_hi = "सेवाएं";
        $section->title_es = "Servicios";
        $section->title_ru = "Услуги";
        $section->title_pt = "Serviços";
        $section->title_fr = "services";
        $section->title_de = "Dienstleistungen";
        $section->title_th = "บริการ";
        $section->title_br = "Serviços";

        $section->seo_title_ar = "الخدمات";
        $section->seo_title_en = "Services";
        $section->seo_title_ch = "服务";
        $section->seo_title_hi = "सेवाएं";
        $section->seo_title_es = "Servicios";
        $section->seo_title_ru = "Услуги";
        $section->seo_title_pt = "Serviços";
        $section->seo_title_fr = "services";
        $section->seo_title_de = "Dienstleistungen";
        $section->seo_title_th = "บริการ";
        $section->seo_title_br ="Serviços";

        $section->seo_url_slug_ar = "الخدمات";
        $section->seo_url_slug_en = "services";
        $section->seo_url_slug_ch = "服务";
        $section->seo_url_slug_hi = "सेवाएं";
        $section->seo_url_slug_es = "servicios";
        $section->seo_url_slug_ru = "услуги";
        $section->seo_url_slug_pt = "serviços";
        $section->seo_url_slug_fr = "services";
        $section->seo_url_slug_de = "dienstleistungen";
        $section->seo_url_slug_th = "บริการ";
        $section->seo_url_slug_br ="serviços";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 1;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 1;
        $section->maps_status = 0;
        $section->order_status = 1;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // News
        $section = new WebmasterSection();
        $section->row_no = 4;

        $section->title_ar = "الأخبار";
        $section->title_en = "News";
        $section->title_ch = "新闻";
        $section->title_hi = "समाचार";
        $section->title_es = "Noticias";
        $section->title_ru = "Новости";
        $section->title_pt = "Notícia";
        $section->title_fr = "Nouvelles";
        $section->title_de = "Nieuws";
        $section->title_th = "ข่าว";
        $section->title_br = "Notícias";
        $section->photo ="nav-bg.png";

        $section->seo_title_ar = "الأخبار";
        $section->seo_title_en = "News";
        $section->seo_title_ch = "新闻";
        $section->seo_title_hi = "समाचार";
        $section->seo_title_es = "Noticias";
        $section->seo_title_ru = "Новости";
        $section->seo_title_pt = "Notícia";
        $section->seo_title_fr = "Nouvelles";
        $section->seo_title_de = "Nieuws";
        $section->seo_title_th = "ข่าว";
        $section->seo_title_br = "Notícias";

        $section->seo_url_slug_ar = "الأخبار";
        $section->seo_url_slug_en = "news";
        $section->seo_url_slug_ch = "新闻";
        $section->seo_url_slug_hi = "समाचार";
        $section->seo_url_slug_es = "noticias";
        $section->seo_url_slug_ru = "новости";
        $section->seo_url_slug_pt = "notícia";
        $section->seo_url_slug_fr = "nouvelles";
        $section->seo_url_slug_de = "nieuws";
        $section->seo_url_slug_th = "ข่าว";
        $section->seo_url_slug_br = "notícias";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 1;
        $section->date_status = 1;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 0;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Photos
        $section = new WebmasterSection();
        $section->row_no = 5;

        $section->title_ar = "الصور";
        $section->title_en = "Photos";
        $section->title_ch = "照片";
        $section->title_hi = "तस्वीरें";
        $section->title_es = "Fotos";
        $section->title_ru = "Фото";
        $section->title_pt = "Fotos";
        $section->title_fr = "Photos";
        $section->title_de = "Fotos";
        $section->title_th = "照片";
        $section->title_br = "Fotos";

        $section->seo_title_ar = "الصور";
        $section->seo_title_en = "Photos";
        $section->seo_title_ch = "照片";
        $section->seo_title_hi = "तस्वीरें";
        $section->seo_title_es = "Fotos";
        $section->seo_title_ru = "Фото";
        $section->seo_title_pt = "Fotos";
        $section->seo_title_fr = "Photos";
        $section->seo_title_de = "Fotos";
        $section->seo_title_th = "照片";
        $section->seo_title_br = "Fotos";

        $section->seo_url_slug_ar = "الصور";
        $section->seo_url_slug_en = "photos";
        $section->seo_url_slug_ch = "照片";
        $section->seo_url_slug_hi = "तस्वीरें";
        $section->seo_url_slug_es = "fotos";
        $section->seo_url_slug_ru = "фото";
        $section->seo_url_slug_pt = "fotos";
        $section->seo_url_slug_fr = "photos";
        $section->seo_url_slug_de = "fotos";
        $section->seo_url_slug_th = "照片";
        $section->seo_url_slug_br = "fotos";
        $section->photo ="nav-bg.png";

        $section->type = 1;
        $section->sections_status = 0;
        $section->comments_status = 1;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 0;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Videos
        $section = new WebmasterSection();
        $section->row_no = 6;

        $section->title_ar = "الفيديو";
        $section->title_en = "Videos";
        $section->title_ch = "视频";
        $section->title_hi = "वीडियो";
        $section->title_es = "Videos";
        $section->title_ru = "Видео";
        $section->title_pt = "Vídeos";
        $section->title_fr = "Vidéos";
        $section->title_de = "Videos";
        $section->title_th = "วิดีโอ";
        $section->title_br = "Vídeos";

        $section->seo_title_ar = "الفيديو";
        $section->seo_title_en = "Videos";
        $section->seo_title_ch = "视频";
        $section->seo_title_hi = "वीडियो";
        $section->seo_title_es = "Videos";
        $section->seo_title_ru = "Видео";
        $section->seo_title_pt = "Vídeos";
        $section->seo_title_fr = "Vidéos";
        $section->seo_title_de = "Videos";
        $section->seo_title_th = "วิดีโอ";
        $section->seo_title_br = "Vídeos";

        $section->seo_url_slug_ar = "الفيديو";
        $section->seo_url_slug_en = "videos";
        $section->seo_url_slug_ch = "视频";
        $section->seo_url_slug_hi = "वीडियो";
        $section->seo_url_slug_es = "videos";
        $section->seo_url_slug_ru = "видео";
        $section->seo_url_slug_pt = "vídeos";
        $section->seo_url_slug_fr = "vidéos";
        $section->seo_url_slug_de = "videos";
        $section->seo_url_slug_th = "วิดีโอ";
        $section->seo_url_slug_br = "vídeos";
        $section->photo ="nav-bg.png";

        $section->type = 2;
        $section->sections_status = 1;
        $section->comments_status = 1;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Sounds
        $section = new WebmasterSection();
        $section->row_no = 7;

        $section->title_ar = "الصوتيات";
        $section->title_en = "Audio";
        $section->title_ch = "声音的";
        $section->title_hi = "ऑडियो";
        $section->title_es = "Audio";
        $section->title_ru = "Аудио";
        $section->title_pt = "Áudio";
        $section->title_fr = "l'audio";
        $section->title_de = "Audio";
        $section->title_th = "เครื่องเสียง";
        $section->title_br = "áudio";

        $section->seo_title_ar = "الصوتيات";
        $section->seo_title_en = "Audio";
        $section->seo_title_ch = "Audio";
        $section->seo_title_hi = "ऑडियो";
        $section->seo_title_es = "Audio";
        $section->seo_title_ru = "Аудио";
        $section->seo_title_pt = "Áudio";
        $section->seo_title_fr = "l'audio";
        $section->seo_title_de = "Audio";
        $section->seo_title_th = "เครื่องเสียง";
        $section->seo_title_br = "áudio";

        $section->seo_url_slug_ar = "الصوتيات";
        $section->seo_url_slug_en = "audio";
        $section->seo_url_slug_ch = "audio";
        $section->seo_url_slug_hi = "ऑडियो";
        $section->seo_url_slug_es = "audio";
        $section->seo_url_slug_ru = "аудио";
        $section->seo_url_slug_pt = "áudio";
        $section->seo_url_slug_fr = "l'audio";
        $section->seo_url_slug_de = "audio";
        $section->seo_url_slug_th = "เครื่องเสียง";
        $section->seo_url_slug_br = "áudio";
        $section->photo ="nav-bg.png";

        $section->type = 3;
        $section->sections_status = 1;
        $section->comments_status = 1;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Blog
        $section = new WebmasterSection();
        $section->row_no = 8;

        $section->title_ar = "المدونة";
        $section->title_en = "Blog";
        $section->title_ch = "博客";
        $section->title_hi = "ब्लॉग";
        $section->title_es = "Blog";
        $section->title_ru = "Блог";
        $section->title_pt = "Blog";
        $section->title_fr = "Blog";
        $section->title_de = "Blog";
        $section->title_th = "บล็อก";
        $section->title_br = "blog";

        $section->seo_title_ar = "المدونة";
        $section->seo_title_en = "Blog";
        $section->seo_title_ch = "博客";
        $section->seo_title_hi = "ब्लॉग";
        $section->seo_title_es = "Blog";
        $section->seo_title_ru = "Блог";
        $section->seo_title_pt = "Blog";
        $section->seo_title_fr = "Blog";
        $section->seo_title_de = "Blog";
        $section->seo_title_th = "บล็อก";
        $section->seo_title_br = "blog";

        $section->seo_url_slug_ar = "المدونة";
        $section->seo_url_slug_en = "blog";
        $section->seo_url_slug_ch = "博客";
        $section->seo_url_slug_hi = "ब्लॉग";
        $section->seo_url_slug_es = "blog";
        $section->seo_url_slug_ru = "блог";
        $section->seo_url_slug_pt = "blog";
        $section->seo_url_slug_fr = "blog";
        $section->seo_url_slug_de = "blog";
        $section->seo_url_slug_th = "บล็อก";
        $section->seo_url_slug_br = "blog";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 1;
        $section->comments_status = 1;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 0;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Products
        $section = new WebmasterSection();
        $section->row_no = 3;

        $section->title_ar = "المنتجات";
        $section->title_en = "Products";
        $section->title_ch = "产品";
        $section->title_hi = "उत्पादों";
        $section->title_es = "Productos";
        $section->title_ru = "Товары";
        $section->title_pt = "Produtos";
        $section->title_fr = "Produits";
        $section->title_de = "Produkte";
        $section->title_th = "สินค้า";
        $section->title_br = "Produtos";

        $section->seo_title_ar = "المنتجات";
        $section->seo_title_en = "Products";
        $section->seo_title_ch = "产品";
        $section->seo_title_hi = "उत्पादों";
        $section->seo_title_es = "Productos";
        $section->seo_title_ru = "Товары";
        $section->seo_title_pt = "Produtos";
        $section->seo_title_fr = "Produits";
        $section->seo_title_de = "Produkte";
        $section->seo_title_th = "สินค้า";
        $section->seo_title_br = "Produtos";

        $section->seo_url_slug_ar = "المنتجات";
        $section->seo_url_slug_en = "products";
        $section->seo_url_slug_ch = "产品";
        $section->seo_url_slug_hi = "उत्पादों";
        $section->seo_url_slug_es = "productos";
        $section->seo_url_slug_ru = "товары";
        $section->seo_url_slug_pt = "produtos";
        $section->seo_url_slug_fr = "produits";
        $section->seo_url_slug_de = "produkte";
        $section->seo_url_slug_th = "สินค้า";
        $section->seo_url_slug_br = "produtos";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 2;
        $section->comments_status = 1;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 0;
        $section->multi_images_status = 1;
        $section->section_icon_status = 1;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 1;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 6;
        $WebmasterSectionField->title_ar = "الماركة";
        $WebmasterSectionField->title_en = "Brand";
        $WebmasterSectionField->title_ch = "Brand";
        $WebmasterSectionField->title_hi = "Brand";
        $WebmasterSectionField->title_es = "Brand";
        $WebmasterSectionField->title_ru = "Brand";
        $WebmasterSectionField->title_pt = "Brand";
        $WebmasterSectionField->title_fr = "Brand";
        $WebmasterSectionField->title_de = "Brand";
        $WebmasterSectionField->title_th = "Brand";
        $WebmasterSectionField->title_br = "Brand";
        $WebmasterSectionField->details_ar = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_en = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_ch = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_hi = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_es = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_ru = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_pt = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_fr = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_de = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_th = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->details_br = "Apple\nAmazon\nSamsung\nGoogle\nMicrosoft\nIntel\nRolex";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 1;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 0;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "السعر";
        $WebmasterSectionField->title_en = "Price";
        $WebmasterSectionField->title_ch = "Price";
        $WebmasterSectionField->title_hi = "Price";
        $WebmasterSectionField->title_es = "Price";
        $WebmasterSectionField->title_ru = "Price";
        $WebmasterSectionField->title_pt = "Price";
        $WebmasterSectionField->title_fr = "Price";
        $WebmasterSectionField->title_de = "Price";
        $WebmasterSectionField->title_th = "Price";
        $WebmasterSectionField->title_br = "Price";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 2;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 0;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 0;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        // Partners
        $section = new WebmasterSection();
        $section->row_no = 9;

        $section->title_ar = "العملاء";
        $section->title_en = "Partners";
        $section->title_ch = "伙伴";
        $section->title_hi = "भागीदारों";
        $section->title_es = "Socias";
        $section->title_ru = "Партнеры";
        $section->title_pt = "Sócias";
        $section->title_fr = "partenaires";
        $section->title_de = "Partners";
        $section->title_th = "พันธมิตร";
        $section->title_br = "Parceiras";

        $section->seo_title_ar = "العملاء";
        $section->seo_title_en = "Partners";
        $section->seo_title_ch = "伙伴";
        $section->seo_title_hi = "भागीदारों";
        $section->seo_title_es = "Socias";
        $section->seo_title_ru = "Партнеры";
        $section->seo_title_pt = "Sócias";
        $section->seo_title_fr = "partenaires";
        $section->seo_title_de = "Partners";
        $section->seo_title_th = "พันธมิตร";
        $section->seo_title_br = "Parceiras";

        $section->seo_url_slug_ar = "العملاء";
        $section->seo_url_slug_en = "partners";
        $section->seo_url_slug_ch = "伙伴";
        $section->seo_url_slug_hi = "भागीदारों";
        $section->seo_url_slug_es = "socias";
        $section->seo_url_slug_ru = "партнеры";
        $section->seo_url_slug_pt = "sócias";
        $section->seo_url_slug_fr = "partenaires";
        $section->seo_url_slug_de = "partners";
        $section->seo_url_slug_th = "พันธมิตร";
        $section->seo_url_slug_br = "parceiras";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 0;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "رابط";
        $WebmasterSectionField->title_en = "URL";
        $WebmasterSectionField->title_ch = "URL";
        $WebmasterSectionField->title_hi = "URL";
        $WebmasterSectionField->title_es = "URL";
        $WebmasterSectionField->title_ru = "URL";
        $WebmasterSectionField->title_pt = "URL";
        $WebmasterSectionField->title_fr = "URL";
        $WebmasterSectionField->title_de = "URL";
        $WebmasterSectionField->title_th = "URL";
        $WebmasterSectionField->title_br = "URL";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 1;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 0;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 0;
        $WebmasterSectionField->in_listing = 0;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        // FAQ
        $section = new WebmasterSection();
        $section->row_no = 10;

        $section->title_ar = "الإسئلة الشائعة";
        $section->title_en = "FAQ";
        $section->title_ch = "常问问题";
        $section->title_hi = "सामान्य प्रश्न";
        $section->title_es = "FAQ";
        $section->title_ru = "FAQ";
        $section->title_pt = "FAQ";
        $section->title_fr = "FAQ";
        $section->title_de = "FAQ";
        $section->title_th = "คำถามที่พบบ่อย";
        $section->title_br = "FAQ";

        $section->seo_title_ar = "الإسئلة الشائعة";
        $section->seo_title_en = "FAQ";
        $section->seo_title_ch = "常问问题";
        $section->seo_title_hi = "सामान्य प्रश्न";
        $section->seo_title_es = "FAQ";
        $section->seo_title_ru = "FAQ";
        $section->seo_title_pt = "FAQ";
        $section->seo_title_fr = "FAQ";
        $section->seo_title_de = "FAQ";
        $section->seo_title_th = "คำถามที่พบบ่อย";
        $section->seo_title_br = "FAQ";

        $section->seo_url_slug_ar = "الإسئلة-الشائعة";
        $section->seo_url_slug_en = "faq";
        $section->seo_url_slug_ch = "常问问题";
        $section->seo_url_slug_hi = "सामान्य-प्रश्न";
        $section->seo_url_slug_es = "faq";
        $section->seo_url_slug_ru = "faq";
        $section->seo_url_slug_pt = "faq";
        $section->seo_url_slug_fr = "faq";
        $section->seo_url_slug_de = "faq";
        $section->seo_url_slug_th = "คำถามที่พบบ่อย";
        $section->seo_url_slug_br = "faq";
        $section->photo ="nav-bg.png";

        $section->type = 8;
        $section->sections_status = 1;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Testimonials
        $section = new WebmasterSection();
        $section->row_no = 11;

        $section->title_ar = "أراء العملاء";
        $section->title_en = "Testimonials";
        $section->title_ch = "感言";
        $section->title_hi = "प्रशंसापत्र";
        $section->title_es = "Testimonios";
        $section->title_ru = "Testimonials";
        $section->title_pt = "Testimonials";
        $section->title_fr = "Témoignages";
        $section->title_de = "Referenzen";
        $section->title_th = "ข้อความรับรอง";
        $section->title_br = "Testimonials";

        $section->seo_title_ar = "أراء العملاء";
        $section->seo_title_en = "Testimonials";
        $section->seo_title_ch = "感言";
        $section->seo_title_hi = "प्रशंसापत्र";
        $section->seo_title_es = "Testimonios";
        $section->seo_title_ru = "Testimonials";
        $section->seo_title_pt = "Testimonials";
        $section->seo_title_fr = "Témoignages";
        $section->seo_title_de = "Referenzen";
        $section->seo_title_th = "ข้อความรับรอง";
        $section->seo_title_br = "Testimonials";

        $section->seo_url_slug_ar = "أراء-العملاء";
        $section->seo_url_slug_en = "testimonials";
        $section->seo_url_slug_ch = "感言";
        $section->seo_url_slug_hi = "प्रशंसापत्र";
        $section->seo_url_slug_es = "testimonios";
        $section->seo_url_slug_ru = "testimonials";
        $section->seo_url_slug_pt = "testimonials";
        $section->seo_url_slug_fr = "témoignages";
        $section->seo_url_slug_de = "referenzen";
        $section->seo_url_slug_th = "ข้อความรับรอง";
        $section->seo_url_slug_br = "testimonials";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        // Staff
        $section = new WebmasterSection();
        $section->row_no = 12;

        $section->title_ar = "فريق العمل";
        $section->title_en = "Our Staff";
        $section->title_ch = "职员";
        $section->title_hi = "कर्मचारी";
        $section->title_es = "Personal";
        $section->title_ru = "Our Staff";
        $section->title_pt = "Funcionárias";
        $section->title_fr = "Personnelle";
        $section->title_de = "Mitarbeiterin";
        $section->title_th = "พนักงาน";
        $section->title_br = "Our Staff";

        $section->seo_title_ar = "فريق العمل";
        $section->seo_title_en = "Our Staff";
        $section->seo_title_ch = "职员";
        $section->seo_title_hi = "कर्मचारी";
        $section->seo_title_es = "Personal";
        $section->seo_title_ru = "Our Staff";
        $section->seo_title_pt = "Funcionárias";
        $section->seo_title_fr = "Personnelle";
        $section->seo_title_de = "Mitarbeiterin";
        $section->seo_title_th = "พนักงาน";
        $section->seo_title_br = "Our Staff";

        $section->seo_url_slug_ar = "فريق-العمل";
        $section->seo_url_slug_en = "our-staff";
        $section->seo_url_slug_ch = "职员";
        $section->seo_url_slug_hi = "कर्मचारी";
        $section->seo_url_slug_es = "personal";
        $section->seo_url_slug_ru = "our-staff";
        $section->seo_url_slug_pt = "funcionárias";
        $section->seo_url_slug_fr = "personnelle";
        $section->seo_url_slug_de = "mitarbeiterin";
        $section->seo_url_slug_th = "พนักงาน";
        $section->seo_url_slug_br = "our-staff";
        $section->photo ="nav-bg.png";

        $section->type = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 1;
        $section->editor_status = 1;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();


        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "المسمي الوظيفي";
        $WebmasterSectionField->title_en = "Job title";
        $WebmasterSectionField->title_ch = "Job title";
        $WebmasterSectionField->title_hi = "Job title";
        $WebmasterSectionField->title_es = "Job title";
        $WebmasterSectionField->title_ru = "Job title";
        $WebmasterSectionField->title_pt = "Job title";
        $WebmasterSectionField->title_fr = "Job title";
        $WebmasterSectionField->title_de = "Job title";
        $WebmasterSectionField->title_th = "Job title";
        $WebmasterSectionField->title_br = "Job title";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 1;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        // Branches
        $section = new WebmasterSection();
        $section->row_no = 13;

        $section->title_ar = "الفروع";
        $section->title_en = "Branches";
        $section->title_ch = "分支机构";
        $section->title_hi = "शाखाओं";
        $section->title_es = "Sucursales";
        $section->title_ru = "Ветви";
        $section->title_pt = "Galhos";
        $section->title_fr = "Branches";
        $section->title_de = "Geäst";
        $section->title_th = "สาขา";
        $section->title_br = "Galhos";

        $section->seo_title_ar = "الفروع";
        $section->seo_title_en = "Branches";
        $section->seo_title_ch = "分支机构";
        $section->seo_title_hi = "शाखाओं";
        $section->seo_title_es = "Sucursales";
        $section->seo_title_ru = "Ветви";
        $section->seo_title_pt = "Galhos";
        $section->seo_title_fr = "Branches";
        $section->seo_title_de = "Geäst";
        $section->seo_title_th = "สาขา";
        $section->seo_title_br = "Galhos";

        $section->seo_url_slug_ar = "الفروع";
        $section->seo_url_slug_en = "branches";
        $section->seo_url_slug_ch = "分支机构";
        $section->seo_url_slug_hi = "शाखाओं";
        $section->seo_url_slug_es = "sucursales";
        $section->seo_url_slug_ru = "ветви";
        $section->seo_url_slug_pt = "galhos";
        $section->seo_url_slug_fr = "branches";
        $section->seo_url_slug_de = "geäst";
        $section->seo_url_slug_th = "สาขา";
        $section->seo_url_slug_br = "galhos";
        $section->photo ="nav-bg.png";

        $section->type = 5;
        $section->title_status = 0;
        $section->photo_status = 0;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 1;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();


        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "الفرع";
        $WebmasterSectionField->title_en = "Branch";
        $WebmasterSectionField->title_ch = "Branch";
        $WebmasterSectionField->title_hi = "Branch";
        $WebmasterSectionField->title_es = "Branch";
        $WebmasterSectionField->title_ru = "Branch";
        $WebmasterSectionField->title_pt = "Branch";
        $WebmasterSectionField->title_fr = "Branch";
        $WebmasterSectionField->title_de = "Branch";
        $WebmasterSectionField->title_th = "Branch";
        $WebmasterSectionField->title_br = "Branch";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 1;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 1;
        $WebmasterSectionField->title_ar = "العنوان";
        $WebmasterSectionField->title_en = "Address";
        $WebmasterSectionField->title_ch = "Address";
        $WebmasterSectionField->title_hi = "Address";
        $WebmasterSectionField->title_es = "Address";
        $WebmasterSectionField->title_ru = "Address";
        $WebmasterSectionField->title_pt = "Address";
        $WebmasterSectionField->title_fr = "Address";
        $WebmasterSectionField->title_de = "Address";
        $WebmasterSectionField->title_th = "Address";
        $WebmasterSectionField->title_br = "Address";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 2;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 6;
        $WebmasterSectionField->title_ar = "الخدمة";
        $WebmasterSectionField->title_en = "Service";
        $WebmasterSectionField->title_ch = "Service";
        $WebmasterSectionField->title_hi = "Service";
        $WebmasterSectionField->title_es = "Service";
        $WebmasterSectionField->title_ru = "Service";
        $WebmasterSectionField->title_pt = "Service";
        $WebmasterSectionField->title_fr = "Service";
        $WebmasterSectionField->title_de = "Service";
        $WebmasterSectionField->title_th = "Service";
        $WebmasterSectionField->title_br = "Service";
        $WebmasterSectionField->details_ar = "الخدمة ١\nالخدمة ٢\nالخدمة ٣\nالخدمة ٤\nالخدمة ٥\nالخدمة ٦\nالخدمة ٧";
        $WebmasterSectionField->details_en = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_ch = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_hi = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_es = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_ru = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_pt = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_fr = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_de = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_th = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->details_br = "Service 1\nService 2\nService 3\nService 4\nService 5\nService 6\nService 7";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 3;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "الهاتف";
        $WebmasterSectionField->title_en = "Phone";
        $WebmasterSectionField->title_ch = "Phone";
        $WebmasterSectionField->title_hi = "Phone";
        $WebmasterSectionField->title_es = "Phone";
        $WebmasterSectionField->title_ru = "Phone";
        $WebmasterSectionField->title_pt = "Phone";
        $WebmasterSectionField->title_fr = "Phone";
        $WebmasterSectionField->title_de = "Phone";
        $WebmasterSectionField->title_th = "Phone";
        $WebmasterSectionField->title_br = "Phone";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 4;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        // Quote requests
        $section = new WebmasterSection();
        $section->row_no = 14;

        $section->title_ar = "طلب عرض سعر";
        $section->title_en = "Quote Request";
        $section->title_ch = "报价请求";
        $section->title_hi = "उद्धरण अनुरोध";
        $section->title_es = "Solicitudes de cotización";
        $section->title_ru = "Запросы цен";
        $section->title_pt = "Solicitações de cotação";
        $section->title_fr = "Demandes de devis";
        $section->title_de = "Angebotsanfragen";
        $section->title_th = "คำขอใบเสนอราคา";
        $section->title_br = "Solicitações de cotação";

        $section->seo_title_ar = "طلب عرض سعر";
        $section->seo_title_en = "Quote Request";
        $section->seo_title_ch = "报价请求";
        $section->seo_title_hi = "उद्धरण अनुरोध";
        $section->seo_title_es = "Solicitudes de cotización";
        $section->seo_title_ru = "Запросы цен";
        $section->seo_title_pt = "Solicitações de cotação";
        $section->seo_title_fr = "Demandes de devis";
        $section->seo_title_de = "Angebotsanfragen";
        $section->seo_title_th = "คำขอใบเสนอราคา";
        $section->seo_title_br = "Solicitações de cotação";

        $section->seo_url_slug_ar = "طلب-عرض-سعر";
        $section->seo_url_slug_en = "quote-request";
        $section->seo_url_slug_ch = "报价请求";
        $section->seo_url_slug_hi = "उद्धरण-अनुरोध";
        $section->seo_url_slug_es = "solicitudes-de-cotización";
        $section->seo_url_slug_ru = "запросы-цен";
        $section->seo_url_slug_pt = "solicitações-de-cotação";
        $section->seo_url_slug_fr = "demandes-de-devis";
        $section->seo_url_slug_de = "angebotsanfragen";
        $section->seo_url_slug_th = "คำขอใบเสนอราคา";
        $section->seo_url_slug_br = "solicitações-de-cotação";
        $section->photo ="nav-bg.png";

        $section->type = 6;
        $section->sections_status = 0;
        $section->comments_status = 0;
        $section->title_status = 0;
        $section->date_status = 0;
        $section->longtext_status = 0;
        $section->editor_status = 0;
        $section->photo_status = 0;
        $section->attach_file_status = 0;
        $section->multi_images_status = 0;
        $section->section_icon_status = 0;
        $section->icon_status = 0;
        $section->maps_status = 0;
        $section->order_status = 0;
        $section->related_status = 0;
        $section->expire_date_status = 0;
        $section->extra_attach_file_status = 0;
        $section->status = 1;
        $section->created_by = 1;
        $section->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "الإسم";
        $WebmasterSectionField->title_en = "Name";
        $WebmasterSectionField->title_ch = "Name";
        $WebmasterSectionField->title_hi = "Name";
        $WebmasterSectionField->title_es = "Name";
        $WebmasterSectionField->title_ru = "Name";
        $WebmasterSectionField->title_pt = "Name";
        $WebmasterSectionField->title_fr = "Name";
        $WebmasterSectionField->title_de = "Name";
        $WebmasterSectionField->title_th = "Name";
        $WebmasterSectionField->title_br = "Name";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 1;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;

        $WebmasterSectionField->save();
        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "الهاتف";
        $WebmasterSectionField->title_en = "Phone";
        $WebmasterSectionField->title_ch = "Phone";
        $WebmasterSectionField->title_hi = "Phone";
        $WebmasterSectionField->title_es = "Phone";
        $WebmasterSectionField->title_ru = "Phone";
        $WebmasterSectionField->title_pt = "Phone";
        $WebmasterSectionField->title_fr = "Phone";
        $WebmasterSectionField->title_de = "Phone";
        $WebmasterSectionField->title_th = "Phone";
        $WebmasterSectionField->title_br = "Phone";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 2;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 2;
        $WebmasterSectionField->title_ar = "البريد الإلكتروني";
        $WebmasterSectionField->title_en = "Email";
        $WebmasterSectionField->title_ch = "Email";
        $WebmasterSectionField->title_hi = "Email";
        $WebmasterSectionField->title_es = "Email";
        $WebmasterSectionField->title_ru = "Email";
        $WebmasterSectionField->title_pt = "Email";
        $WebmasterSectionField->title_fr = "Email";
        $WebmasterSectionField->title_de = "Email";
        $WebmasterSectionField->title_th = "Email";
        $WebmasterSectionField->title_br = "Email";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 3;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 0;
        $WebmasterSectionField->title_ar = "اسم الشركة";
        $WebmasterSectionField->title_en = "Company";
        $WebmasterSectionField->title_ch = "Company";
        $WebmasterSectionField->title_hi = "Company";
        $WebmasterSectionField->title_es = "Company";
        $WebmasterSectionField->title_ru = "Company";
        $WebmasterSectionField->title_pt = "Company";
        $WebmasterSectionField->title_fr = "Company";
        $WebmasterSectionField->title_de = "Company";
        $WebmasterSectionField->title_th = "Company";
        $WebmasterSectionField->title_br = "Company";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 4;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 6;
        $WebmasterSectionField->title_ar = "نوع العرض";
        $WebmasterSectionField->title_en = "Quote type";
        $WebmasterSectionField->title_ch = "Quote type";
        $WebmasterSectionField->title_hi = "Quote type";
        $WebmasterSectionField->title_es = "Quote type";
        $WebmasterSectionField->title_ru = "Quote type";
        $WebmasterSectionField->title_pt = "Quote type";
        $WebmasterSectionField->title_fr = "Quote type";
        $WebmasterSectionField->title_de = "Quote type";
        $WebmasterSectionField->title_th = "Quote type";
        $WebmasterSectionField->title_br = "Quote type";
        $WebmasterSectionField->details_ar = "شهري\nربع سنوي\nنصف سنوي\nسنوي\nكل سنتين\nأخرى";
        $WebmasterSectionField->details_en = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_ch = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_hi = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_es = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_ru = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_pt = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_fr = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_de = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_th = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->details_br = "Monthly\nQuarterly\nHalf annual\nYearly\n2 Years\nOther";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 5;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 7;
        $WebmasterSectionField->title_ar = "الخدمات";
        $WebmasterSectionField->title_en = "Services";
        $WebmasterSectionField->title_ch = "Services";
        $WebmasterSectionField->title_hi = "Services";
        $WebmasterSectionField->title_es = "Services";
        $WebmasterSectionField->title_ru = "Services";
        $WebmasterSectionField->title_pt = "Services";
        $WebmasterSectionField->title_fr = "Services";
        $WebmasterSectionField->title_de = "Services";
        $WebmasterSectionField->title_th = "Services";
        $WebmasterSectionField->title_br = "Services";
        $WebmasterSectionField->details_ar = "شهري\nربع سنوي\nنصف سنوي\nسنوي\nكل سنتين\nأخرى";
        $WebmasterSectionField->details_en = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_ch = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_hi = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_es = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_ru = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_pt = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_fr = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_de = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_th = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->details_br = "Hosting\nDomains\nLogo Design\nWeb Design\nSEO % Marketing\nERP System";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 6;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 1;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();


        $WebmasterSectionField = new WebmasterSectionField();
        $WebmasterSectionField->webmaster_id = $section->id;
        $WebmasterSectionField->type = 1;
        $WebmasterSectionField->title_ar = "ملاحظات";
        $WebmasterSectionField->title_en = "Notes";
        $WebmasterSectionField->title_ch = "Notes";
        $WebmasterSectionField->title_hi = "Notes";
        $WebmasterSectionField->title_es = "Notes";
        $WebmasterSectionField->title_ru = "Notes";
        $WebmasterSectionField->title_pt = "Notes";
        $WebmasterSectionField->title_fr = "Notes";
        $WebmasterSectionField->title_de = "Notes";
        $WebmasterSectionField->title_th = "Notes";
        $WebmasterSectionField->title_br = "Notes";
        $WebmasterSectionField->default_value = null;
        $WebmasterSectionField->row_no = 7;
        $WebmasterSectionField->status = 1;
        $WebmasterSectionField->required = 1;
        $WebmasterSectionField->in_table = 1;
        $WebmasterSectionField->in_search = 1;
        $WebmasterSectionField->in_listing = 0;
        $WebmasterSectionField->in_page = 1;
        $WebmasterSectionField->in_statics = 0;
        $WebmasterSectionField->lang_code = "all";
        $WebmasterSectionField->view_permission_groups = "0";
        $WebmasterSectionField->add_permission_groups = "0";
        $WebmasterSectionField->edit_permission_groups = "0";
        $WebmasterSectionField->created_by = 1;
        $WebmasterSectionField->updated_by = 1;
        $WebmasterSectionField->save();

    }
}
