<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAnalyticsVisitorsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('analytics_visitors', function (Blueprint $table) {
            $table->id();
            $table->string('ip')->nullable();
            $table->string('city')->nullable();
            $table->string('country_code')->nullable();
            $table->string('country')->nullable();
            $table->string('region')->nullable();
            $table->string('full_address')->nullable();
            $table->string('location_cor1')->nullable();
            $table->string('location_cor2')->nullable();
            $table->string('os')->nullable();
            $table->string('browser')->nullable();
            $table->string('resolution')->nullable();
            $table->text('referrer')->nullable();
            $table->string('hostname')->nullable();
            $table->string('org')->nullable();
            $table->date('date')->nullable();
            $table->time('time')->nullable();
            $table->index(['date','time', 'country']);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('analytics_visitors');
    }
}
