<?php 
$success = $this->session->flashdata('success');
if($success){?> 

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-info">
                <?php 
                    echo $success;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>

<?php

}
?>
<?php 
$failed = $this->session->flashdata('failed');
if($failed){?>

    <div class="box box-info">
        <div class="box-body">
            <div class="callout callout-warning">
                <?php 
                    echo $failed;
                ?>
            </div>
        </div><!-- /.box-body -->
    </div>
 
<?php

}
 
?>
<div class="col-md-12">
    <div class="box box-primary">
        <div class="box-header">
            <h3 class="box-title">Edit Test Bill</h3>
        </div><!-- /.box-header -->
    </div>
</div>

<form action="<?php echo base_url();?>test/bill_edit" method="post">
<div class="col-md-4">
    <!-- general form elements -->
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Select Patient <sup>*</sup></label>
            <select name="patient_id" class="form-control selectpicker" required="" id="patient_id"  data-live-search="true">
                <option value="">Select Patient</option>
                <?php foreach ($patients as $key => $patient) { ?>
                    <option value="<?php echo $patient->id ?>" <?php echo (($patient->id==$test_bill->patient_id)?'selected="selected"':"") ?> ><?php echo $patient->idnumber ?> (<?php echo $patient->name ?>) </option>
                <?php } ?>
            </select>
             
        </div>

    </div><!-- /.box-body -->
</div>
<input name="id" type="hidden" value="<?php echo $test_bill->id ?> ">
<div class="col-md-4">
    <!-- general form elements -->
    <div class="box-body">
         <div class="form-group">
            <label for="exampleInputPassword1">Bill ID <sup>*</sup></label>
            <input name="bill_id" type="text" class="form-control"  placeholder="Bill ID" required="" readonly="" value="<?php echo $test_bill->bill_id ?> ">
        </div>
              
    </div><!-- /.box-body -->
</div>

<div class="col-md-4">
    <div class="box-body">
        <div class="form-group">
            <label for="exampleInputPassword1">Bill Date</label>
            <input name="bill_date" type="text" class="form-control date" value="<?php echo date_formate_set($test_bill->bill_date) ?>">
        </div>
    </div><!-- /.box-body -->
 
</div>
<div class="col-md-12">
    <div class="col-md-4">
        <div class="box-body">
            <div class="form-group">
                <label for="exampleInputPassword1">Test</label>
                <select class="form-control selectpicker" id="test_id" data-live-search="true" data-size="10">
                    <option value="">Select Test</option>
                    <?php foreach ($test as $key => $value) { ?>
                        <option value="<?php echo $value->id ?>" data-name="<?php echo $value->testName ?>" data-price="<?php echo $value->fee ?>"><?php echo $value->testName ?> (<?php echo $value->fee ?>) </option>
                    <?php } ?>
                </select>
            </div>
        </div>
    </div>

    <div class="col-md-8">
        <table class="table">
            <thead>
                <tr>
                    <th>Test Name</th>
                    <th>Qty</th>
                    <th>Test Amount</th>
                    <th>Total Amount</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody id="tableDynamic">
                <?php foreach ($items as $key => $item) {
                    $i = $key+1; ?>
                <tr>
                    <td>
                        <input type="text" class="form-control" value="<?php echo $item->testName ?>" readonly>
                        <input name="test_id[]" type="hidden" value="<?php echo $item->test_id ?>">
                    </td> 
                    <td> 
                        <input name="quantity[]" id="quantity_<?php echo $i ?>" type="text" class="form-control quant" value="<?php echo $item->quantity ?>">
                    </td>
                    <td>
                        <input name="price[]"  type="text" class="form-control" value="<?php echo $item->price ?>" id="unitprice_<?php echo $i ?>" readonly > 
                    </td>
                    <td>
                        <input name="total[]" id="totalprice_<?php echo $i ?>"  type="text" class="form-control totalprice" value="<?php echo $item->total_price ?>">
                    </td>
                    <td>
                        <a href="javascript:void(0);" id="deleteRow_<?php echo $i ?>"  class="deleteRow btn btn-danger btn-flat btn-sm">Delete</a>
                    </td>
                </tr>
                <?php } ?>

            </tbody>
            <tfoot>
                <tr>
                    <td colspan="2"></td>
                    <td  style="text-align: right;"><strong>Subtotal</strong></td>
                    <td > 
                        <input type="text" name="subtotal" id="subtotal" class="form-control" readonly="" value="<?php echo $test_bill->sub_total ?>">
                    </td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td  style="text-align: right;"><strong>Discount</strong></td>
                    <td ><input type="text" name="discount" id="discount" class="form-control" value="<?php echo $test_bill->discount ?>"></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td  style="text-align: right;"><strong>Net Total</strong></td>
                    <td ><input type="text" name="net_total" id="net_total" class="form-control" readonly="" value="<?php echo $test_bill->net_total ?>"></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td  style="text-align: right;"><strong>Paid</strong></td>
                    <td ><input type="text" name="paidamount" id="paidamount" class="form-control" value="<?php echo $test_bill->paid_amount ?>"></td>
                    <td></td>
                </tr>
                <tr>
                    <td colspan="2"></td>
                    <td  style="text-align: right;"><strong>Due Balance</strong></td>
                    <td ><input type="text" name="dueamount" id="dueamount" class="form-control" readonly="" value="<?php echo $test_bill->due_amount ?>"></td>
                    <td></td>
                </tr>
            </tfoot>
        </table>
    </div> 
</div> 



<div class="col-md-12" >
     
    <button type="submit" class="btn btn-primary" >Update Bill</button>
     
</div>

</form>

<script>
    var scntDiv = $('#tableDynamic');
    var i = $('#tableDynamic tr').size() + 1;
   
    $('#test_id').change(function() {
        var test_id = $('#test_id').val();
        var test_name = $("#test_id option:selected").attr('data-name');
        var test_price = $("#test_id option:selected").attr('data-price'); 
         
        $('<tr><td><input type="text" class="form-control" value="'+test_name+'" readonly><input name="test_id[]" type="hidden" value="'+test_id+'"></td> <td> <input name="quantity[]" id="quantity_'+i+'" type="text" class="form-control quant" value="1"></td><td><input name="price[]"  type="text" class="form-control" value="'+test_price+'" id="unitprice_'+i+'" readonly > </td><td><input name="total[]" id="totalprice_'+i+'"  type="text" class="form-control totalprice" value="'+test_price+'"></td><td><a href="javascript:void(0);" id="deleteRow_'+i+'"  class="deleteRow btn btn-danger btn-flat btn-sm">Delete</a></td></tr>').appendTo(scntDiv);
        i++;
        totalcalculate();
        return false;
    });

    $(document).on("click", ".deleteRow", function (e) {
        if($('#tableDynamic tr').size()>1){
            var target = e.target;

            var id_arr = $(this).attr('id');
            var id = id_arr.split("_");
            var element_id = id[id.length-1];
            //console.log(element_id);

            var totalprice =parseFloat( $("#totalprice_"+element_id).val());
            var subtotal = parseFloat($("#subtotal").val());
            var net_total = parseFloat($("#net_total").val());
            var dueamount = parseFloat($("#dueamount").val());

            if (!isNaN(totalprice)) {
            

            $("#subtotal").val(subtotal-totalprice);
            //$("#grandtotal").val(net_total-totalprice);
            $("#net_total").val(net_total-totalprice);
            $("#dueamount").val(dueamount-totalprice);
 

            }
            
            $(target).closest('tr').remove();
        

        }else{
            //alert('One row should be present in table');
        }
    });


    $(document).on("keyup", "#discount", function(event){
        var discount = $(this).val();
 
        var subtotal = parseFloat($("#subtotal").val());
        var net_total = parseFloat($("#net_total").val());
        var dueamount = parseFloat($("#dueamount").val());
        var paidamount = parseFloat($("#paidamount").val());
 
        $("#net_total").append().val(subtotal - discount);
        $("#dueamount").append().val((subtotal - discount)-paidamount);
    });

    $(document).on("keyup", "#paidamount", function(event){
        var paidamount = $(this).val();
        var net_total = $("#net_total").val();
        var dueamount = $("#dueamount").val();

        $("#dueamount").append().val(net_total - paidamount);
    });

    $(document).on("keyup", ".quant", function(){
        var quant = parseInt($(this).val());
        var id_arr = $(this).attr('id');
        var id = id_arr.split("_");
        var element_id = id[id.length-1];
        //console.log(element_id);
        
        var totalprice = $("#totalprice_"+element_id).val();
        
        $("#totalprice_"+element_id).prop('value','');
        $("#totalprice_"+element_id).attr({placeholder: 'Total Price...'});


        var total = $("#unitprice_"+element_id).val() * $("#quantity_"+element_id).val();

        $("#totalprice_"+element_id).val(total);

        totalcalculate();
                    
    });


    function totalcalculate() {
        $("#tableDynamic tr").each(function() {
            row_total = 0; 
            $("td .totalprice").each(function() {
               row_total += Number($(this).val());
            }); 
            $("#subtotal").append().val(row_total);
            var discount = $("#discount").val();
            $("#net_total").append().val(row_total-discount);
            var paid = $("#paidamount").val();
            var dueamount = (row_total-discount)-paid;
            $("#dueamount").append().val(dueamount);
            
        });
    }

</script>


