<?php
/**
* 
*/
class Invoicemodel extends CI_Model
{
	
	public function __construct() {
        parent::__construct();
    }

    public function infoupdate($data='', $db='', $field='', $id='')
    {
        $this->db->where($field, $id);
        $this->db->update($db, $data);
    }

    public function getproductname($q)
    {
    	$this->db->select('item_name');
	    $this->db->like('item_name', $q);
	    $query = $this->db->get('item');
	    if($query->num_rows > 0){
	      foreach ($query->result_array() as $row){
	        $row_set[] = htmlentities(stripslashes($row['item_name'])); //build an array
	      }
	      echo json_encode($row_set); //format the array into json data
	    }
    }

    public function prescriptioninfo($db='', $prescription_id='')
    {
 
        $this->db->where('prescription_id', $prescription_id);
        $query_results =$this->db->get($db);
        $results= $query_results->result();
        return $results;
    }
     
    public function checkproductid($proname)
    {
    	$this->db->select('item_id');
		$this->db->from('item');
		$this->db->where('item_name', $proname);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }

    public function checkproductname($proname)
    {
        $this->db->select('*');
        $this->db->from('item');
        $this->db->where('item_name', $proname);
        $query_results =$this->db->get();
        $results= $query_results->row();
        if(count($results) > 0){
            return  TRUE;
        }else{
            return FALSE;
        }
    }

    public function checksellingpricebyname($proid)
    {
    	$this->db->select('selling_price,purchasing_price');
		$this->db->from('inventory');
        $this->db->where('item_id', $proid);
        $this->db->order_by("inventory_id", "desc");
        $this->db->limit(1);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }

    public function queryinventorydetailsbyid($item_id)
    {
        $this->db->select('*');
        $this->db->from('inventory');
        $this->db->where('item_id', $item_id);
        $this->db->order_by("inventory_id", "desc");
        $this->db->limit(1);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }
	
	public function checkstockbyname($proid)
    {
    	$this->db->select('balance_stock');
		$this->db->from('inventory');
        $this->db->where('item_id', $proid);
        $this->db->order_by("inventory_id", "desc");
        $this->db->limit(1);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
    }
	
	public function queryproductstock($proname)
	{
		$this->db->select('SUM(quantity) as quantity', FALSE);
        $this->db->from('invoiced_item');
        $this->db->where('product_name', $proname);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}

    public function insertinvoice($data)
    {
    	$this->db->insert('invoice',$data);

		return true;
    }

    public function insertinvoiceditem($new)
    {
    	$this->db->insert('invoiced_item',$new);

		return true;
    }

    public function updateinventorybyinvoiced_item($info)
    {
        $this->db->insert('inventory',$info);

        return true; 
    }

    public function queryinvoicebyinvoiceid($invoice_id)
    {
    	$this->db->select('*');
        $this->db->from('invoice');
        $this->db->where('invoice_id', $invoice_id);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

    public function checkingexisting($invoice_id)
    {
        $this->db->select('*');
        $this->db->from('invoice');
        $this->db->where('invoice_id', $invoice_id);
        $query_results =$this->db->get();
        $results= $query_results->row();
        if(count($results) > 0){
            return  TRUE;
        }else{
            return FALSE;
        }
    }

    public function queryinvoiceditembyinvoiceid($invoice_id)
    {
    	$this->db->select('*');
        $this->db->from('invoiced_item');
        $this->db->where('invoice_id', $invoice_id);
        $query_results =$this->db->get();
        $results= $query_results->result();
        return $results;
    }

    public function queryinvoice()
    {
        $this->db->select('*');
        $this->db->from('invoice');
        $query_results =$this->db->get();
        $results= $query_results->result();
        return $results;
    }

    public function insertdues($duedata)
    {
        $this->db->insert('dues',$duedata);

        return true;
    }

    public function querydueinvoice()
    {
        $this->db->select('*');
        $this->db->from('invoice');
        $this->db->where('due_amount >', '1');
        $query_results =$this->db->get();
        $results= $query_results->result();
        return $results;
    }

    public function querybalancebyinvoiceid($invoice_id)
    {
        $this->db->select('due_amount');
        $this->db->from('invoice');
        $this->db->where('invoice_id', $invoice_id);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

    public function updatedueamountbyinvoiceid($duedata,$invoice_id)
    {
        $this->db->where('invoice_id', $invoice_id);
        $this->db->update('invoice', $duedata);
        return TRUE; 
    }

    public function insertpaymentofduebyinvoiceid($data)
    {
        $this->db->insert('dues',$data);

        return true;
    }
    
    

    public function duepaymenthistorybyinvoiceid($invoice_id)
    {
        $this->db->select('*');
        $this->db->from('dues');
        $this->db->where('invoice_id', $invoice_id);
        $query_results =$this->db->get();
        $results= $query_results->result();
        return $results;
    }

    public function storeInfo()
    {
        $this->db->select('*');
        $this->db->from('app_config');
        $this->db->order_by("id", "desc");
        $this->db->limit(1);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

     

    public function querycurrencytag()
    {
        $this->db->select('currency_tag');
        $this->db->from('currency_info');
        $this->db->order_by("id", "desc");
        $this->db->limit(1);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
    }

    public function deleteinvoicebyinvoiceidfrominvoice($invoice_id)
    {
        $this->db->where('invoice_id', $invoice_id);
        $this->db->delete('invoice'); 
    }

    public function deleteinvoicebyinvoiceidfrominvoiced_item($invoice_id)
    {
        $this->db->where('invoice_id', $invoice_id);
        $this->db->delete('invoiced_item'); 
    }

    public function deleteinvoicebyinvoiceidfromdues($invoice_id)
    {
        $this->db->where('invoice_id', $invoice_id);
        $this->db->delete('dues'); 
    }

    public function prescriptioninfodelete($db, $id)
    {
        $this->db->where('prescription_id', $id);
        $this->db->delete($db); 
    }
}