<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Patients extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
        date_default_timezone_set('Asia/Dhaka');
	}
	 
	public function add()
	{
 		$ymd = date('Y');
		$data = array();
		if($_POST){
		 
			$serial = $this->db->select('idnumber')->order_by('id','desc')->limit(1)->get('patients')->row('idnumber');
	        if($serial !=""){
	            $idnumber = trim($serial, 'P')+1;
	            $idnumber = "P".$idnumber;
	        }else{
	            $idnumber = "P10001"; 
	        }

		    $data['name']=  $this->input->post('name',true);
		    $data['idnumber']=  $idnumber;
		    $data['age']=  $this->input->post('age',true);
		    $data['gender']=  $this->input->post('gender',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['address']=  $this->input->post('address',true);
        	$data['doctor_id']=  $this->input->post('doctor_id',true);
        	$data['prepared_by']=  $this->session->userdata('fullname');
			$this->db->insert('patients', $data);

			$patient_id = $this->db->insert_id();
			$appointment = $this->db->select('appointment_id')->order_by('id','desc')->limit(1)->get('appointment_fee')->row('appointment_id');
	        if($appointment !=""){
	            $appointment_id = trim($appointment, 'A')+1;
	            $appointment_id = "A".$appointment_id;
	        }else{
	            $appointment_id = "A10001"; 
	        }

			$fee = array(
				"doctor_id" =>$this->input->post('doctor_id'),
				"appointment_id" =>$appointment_id,
				"patient_id" =>$patient_id,
				"appointment_fee" =>$this->input->post('appointment_fee'),
				"discount" =>$this->input->post('discount'),
				"appointment_date" =>date('Y-m-d', strtotime($this->input->post('appointment_date'))),
				"net_total" =>$this->input->post('appointment_fee')-$this->input->post('discount'),
				"prepared_by" =>$this->session->userdata('fullname'),
			);

			$this->db->insert('appointment_fee', $fee);

			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('patients/print/'.$patient_id);
		}else{
			
			$serial = $this->db->select('idnumber')->order_by('id','desc')->limit(1)->get('patients')->row('idnumber');
	        if($serial !=""){
	            $idnumber = trim($serial, 'P')+1;
	            $idnumber = "P".$idnumber;
	        }else{
	            $idnumber = "P10001"; 
	        }
	        //echo $idnumber;
	        
			$data['idnumber'] = $idnumber;
			$data['doctors'] = $this->db->get('doctors')->result();
			$data['test'] = $this->db->get('test')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/patients/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}


	
	public function invoice_create()
	{
 		$ymd = date('Y');
		$data = array();
		if($_POST){
		    $type = $this->input->post('type',true);
		    
			$serial = $this->db->select('invoice_id')->order_by('id','desc')->limit(1)->get('invoice')->row('invoice_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'i')+1;
	            $idnumber = "i".$idnumber;
	        }else{
	            $idnumber = "i10001"; 
	        }
	        
            if($type == 'fee'){
                $data['grand_total']=  $this->input->post('amount',true);
                $data['type']=  $this->input->post('type',true);
    		    $data['invoice_id']=  $idnumber;
    		    $data['invoice_date']=  date_formate_set_db($this->input->post('invoice_date'));
            	$data['doctor_id']=  $this->input->post('doctor_id',true);
            	$data['patient_id']=  $this->input->post('patient_id',true);
            	$data['prepared_by']=  $this->session->userdata('fullname');
            	
    			$this->db->insert('invoice', $data);
    			$insert_idinvoice_id = $this->db->insert_id();
            }
            if($type == 'test'){
                 
                $data['type']=  $this->input->post('type',true);
    		    $data['invoice_id']=  $idnumber;
    		    $data['invoice_date']=  date_formate_set_db($this->input->post('invoice_date'));
            	$data['doctor_id']=  $this->input->post('doctor_id',true);
            	$data['patient_id']=  $this->input->post('patient_id',true);
            	$data['prepared_by']=  $this->session->userdata('fullname');
            	
    			$this->db->insert('invoice', $data);
    			$insert_idinvoice_id = $this->db->insert_id();
    			
    			
    			$test_id = $this->input->post('test_id');
    			$totalprice = 0;
        		foreach ($test_id as $key => $id) { 
        		    $testprice = $data['test'] = $this->db->get_where('test', ['id'=>$id])->row('fee');
        		    $test['test_id']= $id;
        		    $test['invoice_id']= $insert_idinvoice_id;
        		 
        		    $test['invoice_date']= date_formate_set_db($this->input->post('invoice_date'));
        		    $test['total_price']= $testprice;
        		    
        		    $this->db->insert('invoiced_item', $test);
        		    $totalprice += $testprice;
        		}
          		
          		$this->db->update('invoice', ['grand_total'=>$totalprice], ['id'=>$insert_idinvoice_id]);
    			
            }
            
			
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('patients/invoice_print/'.$insert_idinvoice_id);
		}else{
			
				$serial = $this->db->select('invoice_id')->order_by('id','desc')->limit(1)->get('invoice')->row('invoice_id');
	        if($serial !=""){
	            $idnumber = trim($serial, 'i')+1;
	            $idnumber = "i".$idnumber;
	        }else{
	            $idnumber = "i10001"; 
	        }

			$data['idnumber'] = $idnumber;
			$data['patients'] = $this->db->get('patients')->result();
			$data['test'] = $this->db->get('test')->result();
			$data['dashboardContent'] = $this->load->view('dashboard/patients/invoice', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}
	
	public function ajaxpatients($patient_id='')
	{
		
		$this->db->select('p.*, d.name AS drname, d.specialist');
		$this->db->from('patients p');
		$this->db->where('p.id', $patient_id);
		$this->db->join('doctors d', 'p.doctor_id=d.id','left');
		$patients = $this->db->get('patients')->row();
		 
		echo json_encode($patients);
	}

	public function doctors_fee($doctor_id='')
	{ 
		
		$this->db->select('appointment_fee');
		$this->db->from('doctors');
		$this->db->where('id', $doctor_id); 
		$doctor = $this->db->get()->row();
		 
		echo $doctor->appointment_fee;
	}

	public function invoice()
	{
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age, p.gender, p.phone, p.address, d.name AS drname, d.specialist,d.educationDegree ');
		$this->db->from('invoice i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		$this->db->join('doctors d', 'i.doctor_id=d.id','left');
		//$this->db->where('i.id', $id);
		$data['invoices'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/patients/invoicelist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	
	public function viewlist()
	{
		$data = array();
		$this->db->select('p.*, d.name AS drname, d.specialist');
		$this->db->from('patients p');
		$this->db->join('doctors d', 'p.doctor_id=d.id','left');
		$data['patients'] = $this->db->get()->result();

		$data['dashboardContent'] = $this->load->view('dashboard/patients/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			 
		    $data['name']=  $this->input->post('name',true);
		    $data['age']=  $this->input->post('age',true);
		    $data['gender']=  $this->input->post('gender',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['address']=  $this->input->post('address',true);
        	$data['doctor_id']=  $this->input->post('doctor_id',true);
			$this->db->update('patients', $data, ['id'=>$id]);

			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('patients/viewlist');
		}else{
			$data['doctors'] = $this->db->get('doctors')->result();
			$data['patient'] = $this->db->get_where('patients',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/patients/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delete($id='')
	{
		  
		$this->db->delete('patients', ['id'=>$id]);
		$success = 'Deleted patients Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('patients/viewlist');
	}

	//  documents
    
    
 
	
	public function ajax_patients($agent_id='', $gender='')
	{
		if($agent_id){
			$this->db->where('agent_id', $agent_id);
		}
		if($gender){
			$this->db->where('gender', $gender);
		}
		$patients = $this->db->order_by('name', 'ASC')->get('patients')->result();
		$option = '<option value="">Select One</option>';
		foreach ($patients as $key => $value) {
			$option .= '<option value="'.$value->id.'">'.$value->name. ' ('.$value->passport.')'.'</option>';
		}
		echo $option;
	}
    
	public function invoice_print($id='')
	{
		 
		$this->db->select('i.*, p.idnumber, p.name AS pname, p.age, p.gender, p.phone, p.address, d.name AS drname, d.specialist,d.educationDegree ');
		$this->db->from('invoice i');
		$this->db->join('patients p', 'i.patient_id=p.id','left');
		$this->db->join('doctors d', 'i.doctor_id=d.id','left');
		$this->db->where('i.id', $id);
		$data['patient'] = $this->db->get()->row();
		
		$this->db->select('t.*');
		$this->db->from('invoiced_item i');
		$this->db->join('test t', 'i.test_id=t.id','left');
		$this->db->where('i.invoice_id', $id);
		$data['test'] = $this->db->get()->result();


		$data['dashboardContent'] = $this->load->view('dashboard/patients/invoice_print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}
	
    
    
	public function print($id='')
	{
		 
		$this->db->select('p.*, d.name AS drname, d.specialist,d.educationDegree ');
		$this->db->from('patients p');
		$this->db->join('doctors d', 'p.doctor_id=d.id','left');
		$this->db->where('p.id', $id);
		$data['patient'] = $this->db->get()->row();

		$this->db->select('*');
		$this->db->where('patient_id', $id);
		$this->db->group_by('id', 'DESC');
		$data['appointment_fee'] = $this->db->get('appointment_fee')->row();

		$data['current_date'] = date('Y-m-d');
		$data['app_config'] = $this->db->get_where('app_config', ['id'=>1])->row();
		$data['dashboardContent'] = $this->load->view('dashboard/patients/print', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}


	public function documents($patient_id='')
	{
		$data = array();
		if($_POST){
			 
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/patients/';
		    $config['allowed_types'] = '*';
		    $config['max_size'] = '60000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);

		    $data['patient_id']=  $this->input->post('patient_id',true);
        	$data['type']=  $this->input->post('type',true); 

		    $this->upload->do_upload('document_file');
	        $images = $this->upload->data();
	        $data['documents'] = $images['file_name'];


			$this->db->insert('patients_documents', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('patients/viewlist');
		}else{
			$data['patient_id'] = $patient_id;
			$data['documents'] = $this->db->get_where('patients_documents', ['patient_id'=>$patient_id])->result();
			$data['dashboardContent'] = $this->load->view('dashboard/patients/documents_add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function view_documents($passenger_id='')
	{
		$data = array();
		 
		$data['documents'] = $this->db->get_where('patients_documents', ['patient_id'=>$patient_id])->result();
		$data['dashboardContent'] = $this->load->view('dashboard/patients/view_documents', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
		 
	}

	public function delete_document($document_id='', $patient_id='')
	{
		$xx = $this->db->get_where("patients_documents", ['id'=>$document_id])->row();
		if($xx->documents){
        	unlink("./uploads/patients/".$xx->documents); 
        }

		$this->db->delete('patients_documents', ['id'=>$document_id]);
		$success = 'Deleted documents Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('patients/view_documents/'.$patient_id);
	}
}