<?php
/**
* 
*/
class Dashboardmodel extends CI_Model
{
	
	public function __construct() {
        parent::__construct();
    }
	
	public function hash($string){
        return hash('sha512', $string);
    }
	
	public function viewuserlist()
	{
		$this->db->select('*');
		$this->db->from('user');
		$results =$this->db->get()->result(); 
		return $results;
	}
	
	public function activateuser($id, $info_data)
	{
		$this->db->where('id', $id);
		$this->db->update('user', $info_data);
		return TRUE; 
	}
	
	public function inactivateuser($id, $info_data)
	{
		$this->db->where('id', $id);
		$this->db->update('user', $info_data);
		return TRUE; 
	}
	
	public function changepassword($id, $data)
	{
		$this->db->where('id', $id);
		$result = $this->db->update('user', $data);
		if($result){
			return TRUE;
		}else{
			return FALSE;
		}
	}

	public function querytotalsale()
	{
		$this->db->select('SUM(net_total) as grand_total', FALSE);
        $this->db->from('invoice');
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}

	public function querytotaldue()
	{
		$this->db->select('SUM(due_amount) as due_amount', FALSE);
        $this->db->from('invoice');
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}

	public function querycurrenttotalsale($first_date,$last_date)
	{
		$this->db->select('SUM(net_total) as grand_total', FALSE);
        $this->db->from('invoice');
        $this->db->where('due_date >=', $first_date);
		$this->db->where('due_date <=', $last_date);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}
    
    public function todaysales($today)
	{
		$this->db->select('SUM(net_total) as grand_total', FALSE);
        $this->db->from('invoice');
        $this->db->where('due_date', $today); 
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}

	public function todaydue($today)
	{
		$this->db->select('SUM(due_amount) as due_amount', FALSE);
        $this->db->from('invoice');
        $this->db->where('due_date', $today); 
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}
	
	public function querycurrenttotaldue($first_date,$last_date)
	{
		$this->db->select('SUM(due_amount) as due_amount', FALSE);
        $this->db->from('invoice');
        $this->db->where('due_date >=', $first_date);
		$this->db->where('due_date <=', $last_date);
        $query_results =$this->db->get();
        $results= $query_results->row();
        return $results;
	}

	public function duplicateUserChecker($name)
	{
		$this->db->select('*');
		$this->db->from('user');
		$this->db->where('name', $name);
		$query_results =$this->db->get();
		$results= $query_results->row();

		if(count($results) > 0){
			return  TRUE;
		}else{
			return FALSE;
		}
	}

	public function insertUserInfo($data)
	{
		$this->db->insert('user',$data);

		return true;
	}

	public function insertstoreinfo($data)
	{
		$this->db->insert('app_config',$data);

		return true;
	}

	public function viewstoreinfo()
	{
		$this->db->select('*');
		$this->db->from('app_config');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
	}

	public function deletestoreinfo($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('app_config'); 
	}

	public function insertvat($data)
	{
		$this->db->insert('vat_info',$data);

		return true;
	}

	public function viewvatinfo()
	{
		$this->db->select('*');
		$this->db->from('vat_info');
		$query_results =$this->db->get();
		$results= $query_results->result();
		return $results;
	}

	public function deletevatinfo($id)
	{
		$this->db->where('id', $id);
		$this->db->delete('vat_info'); 
	}

	public function insertcurrencyinfo($data)
	{
		$this->db->insert('currency_info',$data);

		return true;
	}

	public function querycurrencytag()
	{
		$this->db->select('currency_tag');
		$this->db->from('currency_info');
		$this->db->order_by("id", "desc");
        $this->db->limit(1);
		$query_results =$this->db->get();
		$results= $query_results->row();
		return $results;
	}

}