<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Inventorycontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('inventorymodel','INVENTORYMODEL',TRUE);
		
                $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }
		/*
		echo "<pre>";
		print_r($data);
		exit();
		*/
	}

	

	public function addinventory()
	{
		$data = array();
		$data['queryitemlist'] = $this->INVENTORYMODEL->queryitemlist();
		$data['querysupplierlist'] = $this->INVENTORYMODEL->querysupplierlist();
		
		$data['dashboardContent'] = $this->load->view('dashboard/inventory/addinventory', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertinventory()
	{
		$data = array();
		$today = date("y/m/d");
		$id = $this->input->post('item_id');
		$data['item_id'] = $this->input->post('item_id');
		$data['supplier_id'] = $this->input->post('supplier_id');
		$data['first_supplied_stock'] = $this->input->post('first_supplied_stock');
		$data['purchasing_price'] = $this->input->post('purchasing_price');
		$data['selling_price'] = $this->input->post('selling_price');
		$data['first_supplied_date'] = $today;
		$data['created_date'] = $today;

		

		$prev_result = $this->INVENTORYMODEL->queryforinventorybalancebyid($id);

		if(count($prev_result) > 0 )
		{
			$data['last_supplied_date'] = $prev_result->first_supplied_date;
			$data['last_supplied_stock'] = $prev_result->first_supplied_stock;
			$data['balance_stock'] = $prev_result->balance_stock + $data['first_supplied_stock'];
		}else{
			//$data['last_supplied_date'] = $prev_result->first_supplied_date;
			//$data['last_supplied_stock'] = $prev_result->first_supplied_stock;
			$data['balance_stock'] =  $data['first_supplied_stock'];
		}
		

		if(empty($data['item_id']) || empty($data['supplier_id']) || empty($data['first_supplied_stock']) || empty($data['purchasing_price']) || empty($data['selling_price']) ){
			$failed = "Please enter Required files";
			$this->session->set_flashdata('failed', $failed);
			redirect('inventorycontroller/addinventory');
		}

		$result = $this->INVENTORYMODEL->insertinventory($data);

		$item_id = $this->input->post('item_id');
		$supplier_id = $this->input->post('supplier_id');
		$first_supplied_stock = $this->input->post('first_supplied_stock');
		$purchasing_price = $this->input->post('purchasing_price');
		$selling_price = $this->input->post('selling_price');

		if ($result) {
			$success = "
				Data successfully inserted!<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('inventorycontroller/addinventory');
		}
	}

	public function queryforinventorybalancebyid()
	{
		$id = $this->input->post('item_id');
		$data = $this->INVENTORYMODEL->queryforinventorybalancebyid($id);
		echo json_encode($data);
	}

	public function queryforitemsupplierbyid()
	{
		$id = $this->input->post('item_id');
		$data = $this->INVENTORYMODEL->queryforitemsupplierbyid($id);
		echo json_encode($data);
	}

	public function queryforinventoryitemsupplierlistbyitemid()
	{
		$data = array();
		$item_id = $this->input->post('item_id');
		$data['queryforinventoryitemsupplierlistbyitemid'] = $this->INVENTORYMODEL->queryforinventoryitemsupplierlistbyitemid($item_id);
		echo json_encode($data);
		
	}

	public function viewinventory()
	{
		$data = array();
		$data['queryitemlist'] = $this->INVENTORYMODEL->queryitemlist();
		$data['dashboardContent'] = $this->load->view('dashboard/inventory/viewinventory', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deleteinventory($inventory_id)
	{
		$this->INVENTORYMODEL->deleteinventory($inventory_id);
		$success = 'Deleted Inventory Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('inventorycontroller/viewinventory');
	}
}