<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Agent extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('reportmodel','REPORTMODEL',TRUE);
        $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
        if (empty($id)) {
            redirect("authenticationcontroller");
        } 
	}
	 
	public function add()
	{
		$data = array();
		if($_POST){
			 
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/agent/';
		    $config['allowed_types'] = 'gif|jpg|jpeg|png|GIF|JPG|JPEG|PNG';
		    $config['max_size'] = '10000';
		    $config['image_width']= '4000';
		    $config['image_height']= '4000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);

		    $data['name']=  $this->input->post('name',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['email']=  $this->input->post('email',true);
        	$data['address']=  $this->input->post('address',true);
        	$data['nid']=  $this->input->post('nid',true);

		    $this->upload->do_upload('agent_pic');
	        $images = $this->upload->data();
	        $data['photo'] = $images['file_name'];

	        $config['image_library'] = 'gd2';
	        $config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
	        $config['new_image'] = 'uploads/agent/'.'thumbs_'.$this->upload->file_name;
	        $config['maintain_ratio'] = FALSE;
	        $config['width'] = 325;
	        $config['height'] = 325;
	        $this->load->library('image_lib', $config);
	        $this->image_lib->resize();
 
			$this->db->insert('agents', $data);
			$this->session->set_flashdata('success', 'Data successfully inserted!');
			redirect('agent/add');
		}else{
			$data['dashboardContent'] = $this->load->view('dashboard/agent/add', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	
	public function viewlist()
	{
		$data = array();
		 
		$data['agents'] = $this->db->get('agents')->result();
		$data['dashboardContent'] = $this->load->view('dashboard/agent/list', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function edit($id='')
	{
		$data = array();
		if($_POST){
			$id = $this->input->post('id');
			$this->load->library('upload');
		    $config['upload_path'] = './uploads/agent/';
		    $config['allowed_types'] = 'gif|jpg|jpeg|png|GIF|JPG|JPEG|PNG';
		    $config['max_size'] = '10000';
		    $config['image_width']= '4000';
		    $config['image_height']= '4000';
		    $config['encrypt_name'] = TRUE;

		    $this->upload->initialize($config);

		    $data['name']=  $this->input->post('name',true);
        	$data['phone']=  $this->input->post('phone',true);
        	$data['email']=  $this->input->post('email',true);
        	$data['address']=  $this->input->post('address',true);
        	$data['nid']=  $this->input->post('nid',true);
	        $xx = $this->db->get_where("agents", ['id'=>$id])->row();

		    $image= $this->upload->do_upload('agent_pic');
	        if($image != ""){
	        	$images = $this->upload->data();
	        	if($xx->photo){
	            	unlink("./uploads/agent/".$xx->photo);
	            	unlink("./uploads/agent/thumbs_".$xx->photo);
	            }
	        	$data['photo'] = $images['file_name'];

		        $config['image_library'] = 'gd2';
		        $config['source_image'] = $this->upload->upload_path.$this->upload->file_name;
		        $config['new_image'] = 'uploads/agent/'.'thumbs_'.$this->upload->file_name;
		        $config['maintain_ratio'] = FALSE;
		        $config['width'] = 325;
		        $config['height'] = 325;
		        $this->load->library('image_lib', $config);
		        $this->image_lib->resize();
	        }
	        
  			
			$this->db->update('agents', $data, ['id'=>$id]);
			$this->session->set_flashdata('success', 'Data successfully Update!');
			redirect('agent/viewlist');
		}else{
			$data['agents'] = $this->db->get_where('agents',['id'=>$id])->row();
			$data['dashboardContent'] = $this->load->view('dashboard/agent/edit', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

	public function delete($id='')
	{
		$xx = $this->db->get_where("agents", ['id'=>$id])->row();
		if($xx->photo){
        	unlink("./uploads/agent/".$xx->photo);
        	unlink("./uploads/agent/thumbs_".$xx->photo);
        }

		$this->db->delete('agents', ['id'=>$id]);
		$success = 'Deleted Agent Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('agent/viewlist');
	}


	public function reports($value='')
	{
		$data = array();
		$data['passengers'] = '';
		$data['agent_id'] = '';
		if($_POST){ 
		    $agent_id=  $this->input->post('agent_id',true); 
		    $agents = $this->db->get_where('agents',['id'=>$agent_id])->row();
		    $array_set = array();
		    $genders = $this->db->select('gender')->group_by('gender')->get('passenger')->result_array();
		    foreach ($genders as $key => $gender) {
		    	 
		    
			    if(!empty($agent_id)){
			    	$this->db->where('agent_id', $agent_id);
			    	$data['agent_id'] = $agent_id;
			    }
			    $this->db->where('gender', $gender['gender']);
				$passengers = $this->db->select('*')->get('passenger')->result_array();
				$set = array_merge($gender, array('list'=>$passengers));
				array_push($array_set, $set);
			}

			$data['passengers'] = $array_set;
			$data['agents_name'] = $agents->name;
			$data['agents'] = $this->db->get('agents')->result();
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['dashboardContent'] = $this->load->view('dashboard/agent/reports', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}else{
			//$data['arrayx'] = $this->db->select('gender')->group_by('gender')->get('passenger')->result();
			
			//$data['arrayx'] = array('Male'=>'Male', 'Female'=>'Female');
            $data['agents_name'] = '';
			$data['storeInfo'] = $this->REPORTMODEL->storeInfo();
			$data['agents'] = $this->db->get('agents')->result(); 
			$data['dashboardContent'] = $this->load->view('dashboard/agent/reports', $data, TRUE);
			$this->load->view('dashboard/master_dashboard_panel',$data);
		}
	}

}