<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Itemcontroller extends CI_Controller {

	function __construct()
	{
		parent::__construct();
		$this->load->model('itemmodel','ITEMMODEL',TRUE);
		
                $id = $this->session->userdata('abhinvoiser_1_1_user_id');               
                if (empty($id)) {
                    redirect("authenticationcontroller");
                }
		/*
		echo "<pre>";
		print_r($data);
		exit();
		*/
	}

	

	public function additem()
	{
		$data = array();
		$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/item/additem', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function insertitem()
	{
		$data = array();
		$data['item_code'] = $this->input->post('item_code');
		$data['item_name'] = $this->input->post('item_name');
		$data['supplier_id'] = $this->input->post('supplier_id');

		if(empty($data['item_name']) || empty($data['supplier_id'])){
			$failed = "Please enter both Item Name and Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('itemcontroller/additem');
		}

		$duplicate = $this->ITEMMODEL->duplicateItemChecker($data['item_code'],$data['item_name'],$data['supplier_id']);

		if($duplicate){
			$failed = "Please enter Unique Item Name, Code, Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect('itemcontroller/additem');
		}else{
			$result = $this->ITEMMODEL->insertItemInfo($data);
		}

		$item_code = $this->input->post('item_code');
		$item_name = $this->input->post('item_name');
		
		if ($result) {
			$success = "
				Data successfully inserted!<br>
				Item Code : $item_code<br>
				Item Name : $item_name<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect('itemcontroller/additem');
		}
	}

	public function viewitem()
	{
		$data = array();
		$data['viewitemlist'] = $this->ITEMMODEL->viewitemlist();
		$data['dashboardContent'] = $this->load->view('dashboard/item/viewitemlist', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function deleteitem($id)
	{
		$this->ITEMMODEL->deleteitem($id);
		$success = 'Deleted Item Info Successfully !!!';
		$this->session->set_flashdata('success', $success);
		redirect('itemcontroller/viewitem');
	}

	public function updateitem($id)
	{
		$data = array();
		$data['queryitem'] = $this->ITEMMODEL->queryitem($id);
		$data['querysupplierlist'] = $this->ITEMMODEL->querysupplierlist();
		$data['dashboardContent'] = $this->load->view('dashboard/item/edititem', $data, TRUE);
		$this->load->view('dashboard/master_dashboard_panel',$data);
	}

	public function changeiteminfo()
	{
		$data = array();
		$id = $this->input->post('item_id');
		$data['item_code'] = $this->input->post('item_code');
		$data['item_name'] = $this->input->post('item_name');
		$data['supplier_id'] = $this->input->post('supplier_id');

		if(empty($data['item_name']) || empty($data['supplier_id'])){
			$failed = "Please enter both Item Name and Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect("itemcontroller/updateitem/$id");
		}

		$duplicate = $this->ITEMMODEL->duplicateItemChecker($data['item_code'],$data['item_name'],$data['supplier_id']);

		if($duplicate == TRUE){
			$failed = "Please enter Unique Item Name, Code, Supplier Name";
			$this->session->set_flashdata('failed', $failed);
			redirect("itemcontroller/updateitem/$id");
		}else{
			$result = $this->ITEMMODEL->changeiteminfo($id, $data);
		}
		
		
		$item_code = $this->input->post('item_code');
		$item_name = $this->input->post('item_name');
		
		if ($result) {
			$success = "
				Data successfully updated!<br>
				Item Code : $item_code<br>
				Item Name : $item_name<br>
				";
			$this->session->set_flashdata('success', $success);
			redirect("itemcontroller/updateitem/$id");
		}
	}
}