<?php

if(!function_exists('icon_fa')){
	function icon_fa($icon_name = '', $text_after=NULL, $nbs=NULL, $class=NULL, $attr=NULL){
		return '<i class="fa fa-'.$icon_name.($class ? ' '.$class : '').'" '.($attr ? $attr.' ' : '').'aria-hidden="true"></i>'.
		($text_after ? str_repeat('&nbsp;', ($nbs ? $nbs : 1)).$text_after : '');
	}
}

if(!function_exists('active_menu_open_class')){
	function active_menu_open_class($menu_uri_array, $active_uri)
	{
		echo in_array($active_uri, $menu_uri_array) ? 'menu-open' : '';
	}
}

if(!function_exists('active_menu_class')){
	function active_menu_class($my_menu, $active_menu)
	{
		echo $my_menu==$active_menu ? 'active' : '';
	}
}

if (!function_exists('getMyDate')) {

    function getMyDate($format = "Y-m-d H:i:s", $dateString = '') {
        return $dateString == '' ? date($format) : date($format, strtotime($dateString));
    }

}


// if (!function_exists('site_ssop')) {
    
//     function site_ssop($item_array, $item_key, $default = '') {
//         $CI = &get_instance();
//         $CI->load->helper('array');
//         $items = $CI->config->item($item_array, 'site_ssop');
//         return element($item_key, $items, $default);
//     }
    
// }

if ( ! function_exists('msg_success'))
{
    function msg_success($message='',$success=true)
	{
		$CI		= &get_instance();
		if($message==''){
			return get_msg_success($CI->session->flashdata('msg_success'), $CI->session->flashdata('is_success'));
		}
		else{
			if($CI->input->is_ajax_request()){
				echo get_msg_success($message, $success);
			}
			else{
				$CI->session->set_flashdata(array('msg_success'=> $message,'is_success'=>$success));
			}
		}
	}
}

if ( ! function_exists('get_msg_success'))
{
    function get_msg_success($message='',$success=true)
	{
		if($success){
			$alert_type	= 'success';
			//$alert_icon	= 'entypo-thumbs-up';
		}
		else{
			$alert_type	= 'danger';
			//$alert_icon	= 'entypo-attention';
		}
		return $message ? '<div class="alert alert-dismissable alert-'.$alert_type.'"><button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>'.$message.'</div>' : '';		
	}
}



function no_to_words($number) {
            $no = round($number);
            $point = round($number - $no, 2) * 100;
            $hundred = null;
            $digits_1 = strlen($no);
            $i = 0;
            $str = array();
            $words = array('0' => '', '1' => 'one', '2' => 'two',
                '3' => 'three', '4' => 'four', '5' => 'five', '6' => 'six',
                '7' => 'seven', '8' => 'eight', '9' => 'nine',
                '10' => 'ten', '11' => 'eleven', '12' => 'twelve',
                '13' => 'thirteen', '14' => 'fourteen',
                '15' => 'fifteen', '16' => 'sixteen', '17' => 'seventeen',
                '18' => 'eighteen', '19' => 'nineteen', '20' => 'twenty',
                '30' => 'thirty', '40' => 'forty', '50' => 'fifty',
                '60' => 'sixty', '70' => 'seventy',
                '80' => 'eighty', '90' => 'ninety');
            $digits = array('', 'hundred', 'thousand', 'lakh', 'crore');
            while ($i < $digits_1) {
                $divider = ($i == 2) ? 10 : 100;
                $number = floor($no % $divider);
                $no = floor($no / $divider);
                $i += ($divider == 10) ? 1 : 2;
                if ($number) {
                    $plural = (($counter = count($str)) && $number > 9) ? '' : null;
                    $hundred = ($counter == 1 && $str[0]) ? ' ' : null;
                    $str [] = ($number < 21) ? $words[$number] .
                            " " . $digits[$counter] . $plural . " " . $hundred :
                            $words[floor($number / 10) * 10]
                            . " " . $words[$number % 10] . " "
                            . $digits[$counter] . $plural . " " . $hundred;
                } else
                    $str[] = null;
            }
            $str = array_reverse($str);
            $result = implode('', $str);
            $points = ($point) ?
                    "." . $words[$point / 10] . " " .
                    $words[$point = $point % 10] : '';
            return ucwords($result) . " Tk. (Only). ";
        }
        
        
        if(!function_exists('is_admin')){
	function is_admin(){
		$CI		= &get_instance();
		return $CI->session->userdata('logged')->type=='admin' ? true : false;
	}
}