<?php

defined('BASEPATH') OR exit('No direct script access allowed');

function form_dropdown_db($name = '', $options = array(), $selected = array(), $extra = '', $db_table_name, $field = NULL, $value_field = NULL, $where = NULL) {
    $field = $field ? $field : 'name';
    $value_field = $value_field ? $value_field : 'id';
    $CI = &get_instance();

    if (!is_array($options)) {
        $options = array('' => $options);
    }
    
    $result = NULL;
    if (is_object($db_table_name)) {
        $result = $db_table_name->result();
    } else {
        if ($where) {
            if (is_array($where)) {
                if(isset($where['_db_in'])){
                    $CI->db->where_in($where['_db_in'][0], $where['_db_in'][1]);
                    unset($where['_db_in']);
                }
                $CI->db->where($where);
            } else {
                $CI->db->where($where, NULL, FALSE); // Only cusotm string
            }
        }

        $CI->db->order_by($field);
        $result = $CI->db->distinct()->select("$value_field, $field")->get($db_table_name)->result();
    }

    foreach ($result as $op) {
        $options[$op->$value_field] = $op->$field;
    }

    $fd_html = form_dropdown($name, $options, $selected, $extra);

    if (!$name && $CI->input->is_ajax_request()) {
        $fd_html = str_replace('<select >', '', $fd_html);
        $fd_html = str_replace('</select>', '', $fd_html);
    }

    return $fd_html;
}

// Form Dropdown with a empty option
function form_dropdown_eo($name = '', $options = array(), $selected = array(), $extra = '', $empty_option_text = '-- Select One --') {
    $empty_option = array();
    if ($empty_option_text !== FALSE) {
        $empty_option[''] = $empty_option_text;
    }

    // Get Data from config array like 'site_ssop.sale_paid_by'
    if (!is_array($options)) {
        $CI = &get_instance();
        sscanf($options, '%[^.].%[^.]', $config_array, $config_item);
        $options = $CI->config->item($config_item, $config_array);
    }

    return form_dropdown($name, ($empty_option + $options), $selected, $extra);
}

function date_formate_set($date='')
{

    return date("d-m-Y", strtotime($date));
}

function date_formate_set_db($date='')
{

    return date("Y-m-d", strtotime($date));
}
